untrusted comment: verify with openbsd-75-base.pub
RWRGj1pRpprAftVfUP/AVFEX44/5EmaEBZaDdN9E13hPf2Why5rsuciroMnEzxrDOHiHNMkmCsj51GpwCFc40GByi1n4p3LmawA=

OpenBSD 7.5 errata 022, April 9, 2025:

iked(8) and isakmpd(8) fix double-free in ecdh mode.

Apply by doing:
    signify -Vep /etc/signify/openbsd-75-base.pub -x 022_ike.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install iked and isakmpd:
    cd /usr/src/sbin/iked
    make obj
    make
    make install
    cd /usr/src/sbin/isakmpd
    make obj
    make
    make install

Index: sbin/iked/dh.c
===================================================================
RCS file: /cvs/src/sbin/iked/dh.c,v
diff -u -p -r1.33 dh.c
--- sbin/iked/dh.c	28 Jul 2023 07:31:38 -0000	1.33
+++ sbin/iked/dh.c	25 Mar 2025 15:02:49 -0000
@@ -670,9 +670,9 @@ ec_raw2point(struct dh_group *group, uin
 {
 	const EC_GROUP	*ecgroup = NULL;
 	EC_POINT	*point = NULL;
+	EC_POINT	*ret = NULL;
 	BN_CTX		*bnctx = NULL;
 	BIGNUM		*x = NULL, *y = NULL;
-	int		 ret = -1;
 	size_t		 eclen;
 	size_t		 xlen, ylen;
 
@@ -700,10 +700,12 @@ ec_raw2point(struct dh_group *group, uin
 	if (!EC_POINT_set_affine_coordinates(ecgroup, point, x, y, bnctx))
 		goto done;
 
-	ret = 0;
+	/* success */
+	ret = point;
+	point = NULL;	/* owned by caller */
+
  done:
-	if (ret != 0 && point != NULL)
-		EC_POINT_clear_free(point);
+	EC_POINT_clear_free(point);
 	/* Make sure to erase sensitive data */
 	if (x != NULL)
 		BN_clear(x);
@@ -712,7 +714,7 @@ ec_raw2point(struct dh_group *group, uin
 	BN_CTX_end(bnctx);
 	BN_CTX_free(bnctx);
 
-	return (point);
+	return (ret);
 }
 
 int
Index: sbin/isakmpd/dh.c
===================================================================
RCS file: /cvs/src/sbin/isakmpd/dh.c,v
diff -u -p -r1.27 dh.c
--- sbin/isakmpd/dh.c	31 Mar 2023 07:28:46 -0000	1.27
+++ sbin/isakmpd/dh.c	25 Mar 2025 15:02:49 -0000
@@ -581,9 +581,9 @@ ec_raw2point(struct group *group, u_int8
 {
 	const EC_GROUP	*ecgroup = NULL;
 	EC_POINT	*point = NULL;
+	EC_POINT	*ret = NULL;
 	BN_CTX		*bnctx = NULL;
 	BIGNUM		*x = NULL, *y = NULL;
-	int		 ret = -1;
 	size_t		 eclen;
 	size_t		 xlen, ylen;
 
@@ -611,10 +611,12 @@ ec_raw2point(struct group *group, u_int8
 	if (!EC_POINT_set_affine_coordinates(ecgroup, point, x, y, bnctx))
 		goto done;
 
-	ret = 0;
+	/* success */
+	ret = point;
+	point = NULL;	/* owned by caller */
+
  done:
-	if (ret != 0 && point != NULL)
-		EC_POINT_clear_free(point);
+	EC_POINT_clear_free(point);
 	/* Make sure to erase sensitive data */
 	if (x != NULL)
 		BN_clear(x);
@@ -623,5 +625,5 @@ ec_raw2point(struct group *group, u_int8
 	BN_CTX_end(bnctx);
 	BN_CTX_free(bnctx);
 
-	return (point);
+	return (ret);
 }
