untrusted comment: verify with openbsd-73-base.pub
RWQS90bYzZ4XFjWjugF3gqZREnm1bjX6I76YNTfRNuU4LWFhtBxMOnIhh7Zb+X+004liGDfcdvl3YkQazPO74i1zaQSqdozIew0=

OpenBSD 7.3 errata 010, July 19, 2023:

In ssh-agent(1)'s PKCS#11 provider support, remote execution was
possible due to controllable access in low-quality libraries. In
addition to fixing this, the ability to remotely load PKCS#11
libraries is now disabled by default (re-enable with
'-Oallow-remote-pkcs11').

Apply by doing:
    signify -Vep /etc/signify/openbsd-73-base.pub \
        -x 010_ssh_agent.patch.sig -m - | (cd /usr/src && patch -p0)

And then rebuild and install ssh-agent(1) and ssh-pkcs11-helper(8).
    cd /usr/src/usr.bin/ssh
    make obj
    make
    make install
 
Index: usr.bin/ssh/ssh-agent.1
===================================================================
RCS file: /cvs/src/usr.bin/ssh/ssh-agent.1,v
diff -u -p -u -r1.75 ssh-agent.1
--- usr.bin/ssh/ssh-agent.1	7 Oct 2022 06:00:58 -0000	1.75
+++ usr.bin/ssh/ssh-agent.1	14 Jul 2023 12:18:24 -0000
@@ -107,9 +107,27 @@ environment variable).
 .It Fl O Ar option
 Specify an option when starting
 .Nm .
-Currently only one option is supported:
+Currently two options are supported:
+.Cm allow-remote-pkcs11
+and
 .Cm no-restrict-websafe .
-This instructs
+.Pp
+The
+.Cm allow-remote-pkcs11
+option allows clients of a forwarded
+.Nm
+to load PKCS#11 or FIDO provider libraries.
+By default only local clients may perform this operation.
+Note that signalling that a
+.Nm
+client remote is performed by
+.Xr ssh 1 ,
+and use of other tools to forward access to the agent socket may circumvent
+this restriction.
+.Pp
+The
+.Cm no-restrict-websafe ,
+instructs
 .Nm
 to permit signatures using FIDO keys that might be web authentication
 requests.
Index: usr.bin/ssh/ssh-agent.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/ssh-agent.c,v
diff -u -p -u -r1.297 ssh-agent.c
--- usr.bin/ssh/ssh-agent.c	9 Mar 2023 21:06:24 -0000	1.297
+++ usr.bin/ssh/ssh-agent.c	14 Jul 2023 12:18:24 -0000
@@ -156,6 +156,12 @@ char socket_dir[PATH_MAX];
 /* Pattern-list of allowed PKCS#11/Security key paths */
 static char *allowed_providers;
 
+/*
+ * Allows PKCS11 providers or SK keys that use non-internal providers to
+ * be added over a remote connection (identified by session-bind@openssh.com).
+ */
+static int remote_add_provider;
+
 /* locking */
 #define LOCK_SIZE	32
 #define LOCK_SALT_SIZE	16
@@ -1215,6 +1221,12 @@ process_add_identity(SocketEntry *e)
 		if (strcasecmp(sk_provider, "internal") == 0) {
 			debug_f("internal provider");
 		} else {
+			if (e->nsession_ids != 0 && !remote_add_provider) {
+				verbose("failed add of SK provider \"%.100s\": "
+				    "remote addition of providers is disabled",
+				    sk_provider);
+				goto out;
+			}
 			if (realpath(sk_provider, canonical_provider) == NULL) {
 				verbose("failed provider \"%.100s\": "
 				    "realpath: %s", sk_provider,
@@ -1378,6 +1390,11 @@ process_add_smartcard_key(SocketEntry *e
 		error_f("failed to parse constraints");
 		goto send;
 	}
+	if (e->nsession_ids != 0 && !remote_add_provider) {
+		verbose("failed PKCS#11 add of \"%.100s\": remote addition of "
+		    "providers is disabled", provider);
+		goto send;
+	}
 	if (realpath(provider, canonical_provider) == NULL) {
 		verbose("failed PKCS#11 add of \"%.100s\": realpath: %s",
 		    provider, strerror(errno));
@@ -2032,7 +2049,9 @@ main(int ac, char **av)
 			break;
 		case 'O':
 			if (strcmp(optarg, "no-restrict-websafe") == 0)
-				restrict_websafe  = 0;
+				restrict_websafe = 0;
+			else if (strcmp(optarg, "allow-remote-pkcs11") == 0)
+				remote_add_provider = 1;
 			else
 				fatal("Unknown -O option");
 			break;
Index: usr.bin/ssh/ssh-pkcs11.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/ssh-pkcs11.c,v
diff -u -p -u -r1.56 ssh-pkcs11.c
--- usr.bin/ssh/ssh-pkcs11.c	8 Mar 2023 05:33:53 -0000	1.56
+++ usr.bin/ssh/ssh-pkcs11.c	14 Jul 2023 12:18:24 -0000
@@ -1512,10 +1512,8 @@ pkcs11_register_provider(char *provider_
 		error("dlopen %s failed: %s", provider_id, dlerror());
 		goto fail;
 	}
-	if ((getfunctionlist = dlsym(handle, "C_GetFunctionList")) == NULL) {
-		error("dlsym(C_GetFunctionList) failed: %s", dlerror());
-		goto fail;
-	}
+	if ((getfunctionlist = dlsym(handle, "C_GetFunctionList")) == NULL)
+		fatal("dlsym(C_GetFunctionList) failed: %s", dlerror());
 	p = xcalloc(1, sizeof(*p));
 	p->name = xstrdup(provider_id);
 	p->handle = handle;
