untrusted comment: verify with openbsd-73-base.pub
RWQS90bYzZ4XFphffQmz/SYU+JVzJdm/iyJa9hVeMTnpTmA0jJFJS/NgTZd0Bj1X1eLlwhxQ6sFnUFkbOe76DxsmLs/Y1C1vpgc=

OpenBSD 7.3 errata 014, July 24, 2023:

Missing bounds check in console terminal emulation could cause a kernel
crash after receiving specially crafted escape sequences.

Apply by doing:
    signify -Vep /etc/signify/openbsd-73-base.pub -x 014_wscons.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/dev/wscons/wsemul_sun.c
===================================================================
RCS file: /cvs/src/sys/dev/wscons/wsemul_sun.c,v
diff -u -p -u -r1.36 wsemul_sun.c
--- sys/dev/wscons/wsemul_sun.c	6 Mar 2023 20:34:35 -0000	1.36
+++ sys/dev/wscons/wsemul_sun.c	24 Jul 2023 13:56:55 -0000
@@ -617,13 +617,14 @@ wsemul_sun_output_control(struct wsemul_
 		break;
 
 	case ';':		/* argument terminator */
-		edp->nargs++;
+		if (edp->nargs < SUN_EMUL_NARGS)
+			edp->nargs++;
 		break;
 
 	default:		/* end of escape sequence */
-		oargs = edp->nargs++;
-		if (edp->nargs > SUN_EMUL_NARGS)
-			edp->nargs = SUN_EMUL_NARGS;
+		oargs = edp->nargs;
+		if (edp->nargs < SUN_EMUL_NARGS)
+			edp->nargs++;
 		rc = wsemul_sun_control(edp, instate);
 		if (rc != 0) {
 			/* undo nargs progress */
Index: sys/dev/wscons/wsemul_vt100.c
===================================================================
RCS file: /cvs/src/sys/dev/wscons/wsemul_vt100.c,v
diff -u -p -u -r1.45 wsemul_vt100.c
--- sys/dev/wscons/wsemul_vt100.c	6 Mar 2023 20:34:35 -0000	1.45
+++ sys/dev/wscons/wsemul_vt100.c	24 Jul 2023 13:56:55 -0000
@@ -868,16 +868,12 @@ wsemul_vt100_output_dcs(struct wsemul_vt
 		    (instate->inchar - '0');
 		break;
 	case ';': /* argument terminator */
-		edp->nargs++;
+		if (edp->nargs < VT100_EMUL_NARGS)
+			edp->nargs++;
 		break;
 	default:
-		edp->nargs++;
-		if (edp->nargs > VT100_EMUL_NARGS) {
-#ifdef VT100_DEBUG
-			printf("vt100: too many arguments\n");
-#endif
-			edp->nargs = VT100_EMUL_NARGS;
-		}
+		if (edp->nargs < VT100_EMUL_NARGS)
+			edp->nargs++;
 		newstate = VT100_EMUL_STATE_STRING;
 		switch (instate->inchar) {
 		case '$':
@@ -1069,7 +1065,8 @@ wsemul_vt100_output_csi(struct wsemul_vt
 		    (instate->inchar - '0');
 		break;
 	case ';': /* argument terminator */
-		edp->nargs++;
+		if (edp->nargs < VT100_EMUL_NARGS)
+			edp->nargs++;
 		break;
 	case '?': /* DEC specific */
 	case '>': /* DA query */
@@ -1082,13 +1079,9 @@ wsemul_vt100_output_csi(struct wsemul_vt
 		edp->modif2 = (char)instate->inchar;
 		break;
 	default: /* end of escape sequence */
-		oargs = edp->nargs++;
-		if (edp->nargs > VT100_EMUL_NARGS) {
-#ifdef VT100_DEBUG
-			printf("vt100: too many arguments\n");
-#endif
-			edp->nargs = VT100_EMUL_NARGS;
-		}
+		oargs = edp->nargs;
+		if (edp->nargs < VT100_EMUL_NARGS)
+			edp->nargs++;
 		rc = wsemul_vt100_handle_csi(edp, instate);
 		if (rc != 0) {
 			edp->nargs = oargs;
