untrusted comment: verify with openbsd-73-base.pub
RWQS90bYzZ4XFmhx4NrdQSUlCEpW/iF3Z6J0kPH/RnhblJUmMgiSvdDDV/Gd0kUnsY7oW1xXoeaBkQP6li09WErRF5+HKd9oRAA=

OpenBSD 7.3 errata 002, May 16, 2023:

Avoid fatal errors in bgpd(8) due to incorrect refcounting and mishandling
of ASPA objects. Fix bgpctl(8) 'show rib in' by renaming 'invalid' into
'disqualified'.

Apply by doing:
    signify -Vep /etc/signify/openbsd-73-base.pub -x 002_bgpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install bgpctl(8), bgpd(8) and bgplgd(8):
    cd /usr/src/usr.sbin/bgpctl
    make obj
    make
    make install
    cd /usr/src/usr.sbin/bgpd
    make obj
    make
    make install
    cd /usr/src/usr.sbin/bgplgd
    make obj
    make
    make install

Index: usr.sbin/bgpctl/bgpctl.8
===================================================================
RCS file: /cvs/src/usr.sbin/bgpctl/bgpctl.8,v
diff -u -p -r1.106 bgpctl.8
--- usr.sbin/bgpctl/bgpctl.8	13 Mar 2023 16:59:22 -0000	1.106
+++ usr.sbin/bgpctl/bgpctl.8	9 May 2023 13:34:13 -0000
@@ -383,12 +383,14 @@ Additionally, the following
 .Ar options
 are defined:
 .Pp
-.Bl -tag -width "selected" -compact
+.Bl -tag -width "disqualified" -compact
 .It Cm best
 Alias for
 .Ic selected .
 .It Cm detail
 Show more detailed output for matching routes.
+.It Cm disqualified
+Show only routes which are not eligible.
 .It Cm error
 Show only prefixes which are marked invalid and were treated as withdrawn.
 .It Ar family
@@ -398,8 +400,6 @@ Show routes from the unfiltered Adj-RIB-
 The
 .Cm neighbor
 needs to be specified.
-.It Cm invalid
-Show only routes which are not eligible.
 .It Cm leaked
 Show only routes where a route leak was detected.
 .It Cm out
Index: usr.sbin/bgpctl/parser.c
===================================================================
RCS file: /cvs/src/usr.sbin/bgpctl/parser.c,v
diff -u -p -r1.122 parser.c
--- usr.sbin/bgpctl/parser.c	13 Mar 2023 16:59:22 -0000	1.122
+++ usr.sbin/bgpctl/parser.c	9 May 2023 13:36:01 -0000
@@ -177,8 +177,8 @@ static const struct token t_show_rib[] =
 	{ FLAG,		"best",		F_CTL_BEST,	t_show_rib},
 	{ FLAG,		"selected",	F_CTL_BEST,	t_show_rib},
 	{ FLAG,		"detail",	F_CTL_DETAIL,	t_show_rib},
+	{ FLAG,		"disqualified",	F_CTL_INELIGIBLE, t_show_rib},
 	{ FLAG,		"error",	F_CTL_INVALID,	t_show_rib},
-	{ FLAG,		"invalid",	F_CTL_INELIGIBLE, t_show_rib},
 	{ FLAG,		"leaked",	F_CTL_LEAKED,	t_show_rib},
 	{ FLAG,		"in",		F_CTL_ADJ_IN,	t_show_rib},
 	{ FLAG,		"out",		F_CTL_ADJ_OUT,	t_show_rib},
Index: usr.sbin/bgpd/rde_filter.c
===================================================================
RCS file: /cvs/src/usr.sbin/bgpd/rde_filter.c,v
diff -u -p -r1.134 rde_filter.c
--- usr.sbin/bgpd/rde_filter.c	10 Mar 2023 07:57:15 -0000	1.134
+++ usr.sbin/bgpd/rde_filter.c	10 May 2023 06:47:45 -0000
@@ -583,6 +583,12 @@ filterset_copy(struct filter_set_head *s
 		if ((t = malloc(sizeof(struct filter_set))) == NULL)
 			fatal(NULL);
 		memcpy(t, s, sizeof(struct filter_set));
+		if (t->type == ACTION_RTLABEL_ID)
+			rtlabel_ref(t->action.id);
+		else if (t->type == ACTION_PFTABLE_ID)
+			pftable_ref(t->action.id);
+		else if (t->type == ACTION_SET_NEXTHOP_REF)
+			nexthop_ref(t->action.nh_ref);
 		TAILQ_INSERT_TAIL(dest, t, entry);
 	}
 }
Index: usr.sbin/bgpd/rtr.c
===================================================================
RCS file: /cvs/src/usr.sbin/bgpd/rtr.c,v
diff -u -p -r1.12.4.1 rtr.c
--- usr.sbin/bgpd/rtr.c	1 May 2023 05:13:59 -0000	1.12.4.1
+++ usr.sbin/bgpd/rtr.c	10 May 2023 17:56:17 -0000
@@ -577,7 +577,8 @@ rtr_recalc(void)
 	imsg_compose(ibuf_rde, IMSG_RECONF_ASPA_PREP, 0, 0, -1,
 	    &ap, sizeof(ap));
 
-	RB_FOREACH(aspa, aspa_tree, &at) {
+	/* walk tree in reverse because aspa_add_set requires that */
+	RB_FOREACH_REVERSE(aspa, aspa_tree, &at) {
 		uint32_t	as[2];
 		as[0] = aspa->as;
 		as[1] = aspa->num;
Index: usr.sbin/bgplgd/qs.c
===================================================================
RCS file: /cvs/src/usr.sbin/bgplgd/qs.c,v
diff -u -p -r1.4 qs.c
--- usr.sbin/bgplgd/qs.c	13 Mar 2023 17:31:28 -0000	1.4
+++ usr.sbin/bgplgd/qs.c	10 May 2023 06:33:09 -0000
@@ -391,7 +391,7 @@ qs_argv(char **argv, size_t argc, size_t
 			argv[argc++] = "error";
 	} else if (ctx->qs_args[QS_INVALID].one) {
 		if (argc < len)
-			argv[argc++] = "invalid";
+			argv[argc++] = "disqualified";
 	} else if (ctx->qs_args[QS_LEAKED].one) {
 		if (argc < len)
 			argv[argc++] = "leaked";
