untrusted comment: verify with openbsd-65-base.pub
RWSZaRmt1LEQT6BbgZzVAzGzS4qMd5IK3YlpYo28zb//IQHPoBAYx0+JblP+qtMyS3yKBFyaWZyVNNEFcbbXHvud8y8zxOaSggw=

OpenBSD 6.5 errata 001, May 3, 2019:

If a userland program sets the IPv6 checksum offset on a raw socket,
an incoming packet could crash the kernel.  ospf6d is such a program.

Apply by doing:
    signify -Vep /etc/signify/openbsd-65-base.pub -x 001_rip6cksum.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/netinet6/ip6_output.c
===================================================================
RCS file: /cvs/src/sys/netinet6/ip6_output.c,v
retrieving revision 1.241
diff -u -p -r1.241 ip6_output.c
--- sys/netinet6/ip6_output.c	3 Dec 2018 17:25:22 -0000	1.241
+++ sys/netinet6/ip6_output.c	23 Apr 2019 01:41:02 -0000
@@ -1620,8 +1620,12 @@ ip6_raw_ctloutput(int op, struct socket 
 				break;
 			}
 			optval = *mtod(m, int *);
-			if ((optval % 2) != 0) {
-				/* the API assumes even offset values */
+			if (optval < -1 ||
+			    (optval > 0 && (optval % 2) != 0)) {
+				/*
+				 * The API assumes non-negative even offset
+				 * values or -1 as a special value.
+				 */
 				error = EINVAL;
 			} else if (so->so_proto->pr_protocol == IPPROTO_ICMPV6) {
 				if (optval != icmp6off)
Index: sys/netinet6/raw_ip6.c
===================================================================
RCS file: /cvs/src/sys/netinet6/raw_ip6.c,v
retrieving revision 1.134
diff -u -p -r1.134 raw_ip6.c
--- sys/netinet6/raw_ip6.c	4 Feb 2019 21:40:52 -0000	1.134
+++ sys/netinet6/raw_ip6.c	23 Apr 2019 01:41:02 -0000
@@ -184,7 +184,16 @@ rip6_input(struct mbuf **mp, int *offp, 
 		}
 		if (proto != IPPROTO_ICMPV6 && in6p->inp_cksum6 != -1) {
 			rip6stat_inc(rip6s_isum);
-			if (in6_cksum(m, proto, *offp,
+			/*
+			 * Although in6_cksum() does not need the position of
+			 * the checksum field for verification, enforce that it
+			 * is located within the packet.  Userland has given
+			 * a checksum offset, a packet too short for that is
+			 * invalid.  Avoid overflow with user supplied offset.
+			 */
+			if (m->m_pkthdr.len < *offp + 2 ||
+			    m->m_pkthdr.len - *offp - 2 < in6p->inp_cksum6 ||
+			    in6_cksum(m, proto, *offp,
 			    m->m_pkthdr.len - *offp)) {
 				rip6stat_inc(rip6s_badsum);
 				continue;
@@ -439,7 +448,7 @@ rip6_output(struct mbuf *m, struct socke
 			off = offsetof(struct icmp6_hdr, icmp6_cksum);
 		else
 			off = in6p->inp_cksum6;
-		if (plen < off + 1) {
+		if (plen < 2 || plen - 2 < off) {
 			error = EINVAL;
 			goto bad;
 		}
