untrusted comment: verify with openbsd-64-base.pub
RWQq6XmS4eDAcRAOfeUCbGqUWj50zm29hbEjXtrgMa/HklrJkeaSB7u3+n+TDpBoJBfnjI5X13yx/LEG4TYWNTV1MDmAD3hKFQM=

OpenBSD 6.4 errata 020, August 2, 2019

smtpd can crash on excessively large input, causing a denial of service.

Apply by doing:
    signify -Vep /etc/signify/openbsd-64-base.pub -x 020_smtpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install smtpd:
    cd /usr/src/usr.sbin/smtpd
    make obj
    make
    make install

Index: usr.sbin/smtpd/smtp_session.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/smtp_session.c,v
retrieving revision 1.337
diff -u -p -r1.337 smtp_session.c
--- usr.sbin/smtpd/smtp_session.c	3 Sep 2018 19:01:29 -0000	1.337
+++ usr.sbin/smtpd/smtp_session.c	1 Aug 2019 21:18:53 -0000
@@ -1650,15 +1650,21 @@ smtp_reply(struct smtp_session *s, char 
 {
 	va_list	 ap;
 	int	 n;
-	char	 buf[LINE_MAX], tmp[LINE_MAX];
+	char	 buf[LINE_MAX*2], tmp[LINE_MAX*2];
 
 	va_start(ap, fmt);
 	n = vsnprintf(buf, sizeof buf, fmt, ap);
 	va_end(ap);
-	if (n == -1 || n >= LINE_MAX)
-		fatalx("smtp_reply: line too long");
+	if (n < 0)
+		fatalx("smtp_reply: response format error");
 	if (n < 4)
 		fatalx("smtp_reply: response too short");
+	if (n >= (int)sizeof buf) {
+		/* only first three bytes are used by SMTP logic,
+		 * so if _our_ reply does not fit entirely in the
+		 * buffer, it's ok to truncate.
+		 */
+	}
 
 	log_trace(TRACE_SMTP, "smtp: %p: >>> %s", s, buf);
 
