untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ111xX2lFlJ3LCcKBI85hpABi/RjQa8d6h4VhhaqLR+RX5noSq5d7ruQbfgXkxJ5E20drXrdr5BzvuS+XWePSAk=

OpenBSD 6.0 errata 15, Nov 5, 2016:

Avoid continual processing of an unlimited number of TLS records.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 015_libssl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libssl:
        cd /usr/src/lib/libssl
        make obj
        make depend
        make
        make install

Index: lib/libssl/src/ssl/s3_pkt.c
===================================================================
retrieving revision 1.58
retrieving revision 1.58.2.1
diff -u -p -r1.58 -r1.58.2.1
--- lib/libssl/src/ssl/s3_pkt.c	10 Jul 2016 23:07:34 -0000	1.58
+++ lib/libssl/src/ssl/s3_pkt.c	3 Nov 2016 16:28:36 -0000	1.58.2.1
@@ -839,10 +839,11 @@ ssl3_write_pending(SSL *s, int type, con
 int
 ssl3_read_bytes(SSL *s, int type, unsigned char *buf, int len, int peek)
 {
-	int al, i, j, ret;
+	void (*cb)(const SSL *ssl, int type2, int val) = NULL;
+	int al, i, j, ret, rrcount = 0;
 	unsigned int n;
 	SSL3_RECORD *rr;
-	void (*cb)(const SSL *ssl, int type2, int val) = NULL;
+	BIO *bio;
 
 	if (s->s3->rbuf.buf == NULL) /* Not initialized yet */
 		if (!ssl3_setup_read_buffer(s))
@@ -896,7 +897,27 @@ ssl3_read_bytes(SSL *s, int type, unsign
 			return (-1);
 		}
 	}
+
 start:
+	/*
+	 * Do not process more than three consecutive records, otherwise the
+	 * peer can cause us to loop indefinitely. Instead, return with an
+	 * SSL_ERROR_WANT_READ so the caller can choose when to handle further
+	 * processing. In the future, the total number of non-handshake and
+	 * non-application data records per connection should probably also be
+	 * limited...
+	 */
+	if (rrcount++ >= 3) {
+		if ((bio = SSL_get_rbio(s)) == NULL) {
+			SSLerr(SSL_F_SSL3_READ_BYTES, ERR_R_INTERNAL_ERROR);
+			return -1;
+		}
+		BIO_clear_retry_flags(bio);
+		BIO_set_retry_read(bio);
+		s->rwstate = SSL_READING;
+		return -1;
+	}
+
 	s->rwstate = SSL_NOTHING;
 
 	/*
@@ -1050,7 +1071,6 @@ start:
 				if (!(s->mode & SSL_MODE_AUTO_RETRY)) {
 					if (s->s3->rbuf.left == 0) {
 						/* no read-ahead left? */
-						BIO *bio;
 			/* In the case where we try to read application data,
 			 * but we trigger an SSL handshake, we return -1 with
 			 * the retry option set.  Otherwise renegotiation may
