/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * **********************************************************/

#ifndef __DRIVER_H__
#define __DRIVER_H__


#define DRIVER_MAX_PIDS      16

struct VMDriver;

typedef struct MemRange {
	struct MemRange *next;
	VA kAddr;
	PA pAddr;
	unsigned long numPages;
} MemRange;

struct vmx86_softc {
	struct VMDriver *vm_vm;
	struct selinfo vm_rsel;
	struct callout vm_callout;
	int vm_flags;
	dev_t vm_dev;
	struct vmmon_softc *vm_monsc;
	VmTimeStart startTime;
	MemRange vm_low_pages;
};

#define VMFL_SELTIMO	0x01
#define VMFL_SELWAIT	0x02

#define MAXVMS		16

#define DEVICE_BUFFER_SIZE 32
#define NETBSDLOG_BUFFER_SIZE  1024

struct vmmon_softc {
	struct vmx86_softc *sc_vms[MAXVMS];
	int sc_maxvm;
	int sc_flags;
	int sc_dev;
	char devicebuf[DEVICE_BUFFER_SIZE];
	char buf[NETBSDLOG_BUFFER_SIZE];
};

#define VMNUM(dev)	(minor(dev) - 1)
#define MAKEVMDEV(m,v)	(makedev(major(m),(v)+1))

#endif
