atf_test_case noflags
noflags_head() {
    atf_set "descr" "Tests fsu_cp with PR flags"
}
noflags_body() {
    if [ -z "$FSU_DIR" -o -z "$FSU_IMG" ]; then
	atf_fail "variables: \$FSU_DIR and \$FSU_IMG should be set";
    fi
    ${FSU_DIR}/src/fsu_touch/fsu_touch ${FSU_IMG} file
    ${FSU_DIR}/src/fsu_ln/fsu_ln ${FSU_IMG} file filelnk
    echo -e "2 " >expout
    atf_check '${FSU_DIR}/src/fsu_ls/fsu_ls ${FSU_IMG} -- -l file  | grep -v sysctl_createv | cut -c 13,14' \
	0 expout ignore
}
noflags_cleanup() {
    ${FSU_DIR}/src/fsu_rm/fsu_rm ${FSU_IMG} file filelnk
}

atf_test_case sflag
sflag_head() {
    atf_set "descr" "Tests fsu_cp with PR flags"
}
sflag_body() {
    if [ -z "$FSU_DIR" -o -z "$FSU_IMG" ]; then
	atf_fail "variables: \$FSU_DIR and \$FSU_IMG should be set";
    fi
    ${FSU_DIR}/src/fsu_touch/fsu_touch ${FSU_IMG} file
    ${FSU_DIR}/src/fsu_ln/fsu_ln ${FSU_IMG} -- -s file filelnk

    atf_check \
'${FSU_DIR}/src/fsu_ls/fsu_ls ${FSU_IMG} -- -l filelnk | grep "filelnk \-> file"' \
	0 ignore ignore
}
sflag_cleanup() {
    ${FSU_DIR}/src/fsu_rm/fsu_rm ${FSU_IMG} file filelnk
}

atf_init_test_cases() {
    atf_add_test_case noflags
    atf_add_test_case sflag
}
