atf_test_case PRflags
PRflags_head() {
    atf_set "descr" "Tests fsu_cp with PR flags"
}
PRflags_body() {
    if [ -z "$FSU_DIR" -o -z "$FSU_IMG" ]; then
	atf_fail "variables: \$FSU_DIR and \$FSU_IMG should be set";
    fi
    ${FSU_DIR}/src/fsu_mkdir/fsu_mkdir ${FSU_IMG} -- -p test/a/b/c test/d/e
    ${FSU_DIR}/src/fsu_touch/fsu_touch ${FSU_IMG} test/a/b/c/foo test/bar
    echo abc | ${FSU_DIR}/src/fsu_write/fsu_write ${FSU_IMG} test/a/bar
    echo sdkjss | ${FSU_DIR}/src/fsu_write/fsu_write ${FSU_IMG} test/a/b/c/foo
    ${FSU_DIR}/src/fsu_cp/fsu_cp ${FSU_IMG} -- -PR test test.cp

    atf_check '${FSU_DIR}/src/fsu_diff/fsu_diff ${FSU_IMG} test test.cp' \
	0 ignore ignore
}
PRflags_cleanup() {
    ${FSU_DIR}/src/fsu_rm/fsu_rm ${FSU_IMG} -- -r test.cp test
}

atf_init_test_cases() {
    atf_add_test_case PRflags
}
