/* $Id: fsu_utils.h,v 1.1 2008/09/23 16:21:55 stacktic Exp $ */

/*
 * Copyright (c) 2008 Arnaud Ysmal.  All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _FSU_UTILS_H_
#define _FSU_UTILS_H_

#include <stdbool.h>

struct ukfs;

int fsu_cat_main(struct ukfs *, int, char **);

int fsu_chflags_main(struct ukfs *, int, char **);

int fsu_chmod_main(struct ukfs *, int, char **);

int fsu_chown_main(struct ukfs *, int, char **);

int fsu_cp_main(struct ukfs *, int, char **);

int fsu_diff_main(struct ukfs *, int, char **);

int fsu_du_main(struct ukfs *, int, char **);

int fsu_ecp_main(struct ukfs *, int, char **);

int fsu_exec_main(struct ukfs *, int, char **);

int fsu_find_main(struct ukfs *, int, char **);

int fsu_ln_main(struct ukfs *, int, char **);

int fsu_ls_main(struct ukfs *, int, char **);

int fsu_mkdir_main(struct ukfs *, int, char **);

int fsu_mkfifo_main(struct ukfs *, int, char **);

int fsu_mknod_main(struct ukfs *, int, char **);

int fsu_mv_main(struct ukfs *, int, char **);

int fsu_rm_main(struct ukfs *, int, char **);

int fsu_rmdir_main(struct ukfs *, int, char **);

int fsu_touch_main(struct ukfs *, int, char **);

int fsu_write(struct ukfs *, int, const char *, int);
int fsu_write_main(struct ukfs *, int, char **);

int fsu_console(struct ukfs *, char *, char *, char *);

#endif /* !_FSU_UTILS_H_ */
