#ifndef _FSU_CONSOLE_EXTERN_H_
#define _FSU_CONSOLE_EXTERN_H_

struct ukfs;

typedef struct command_s {
        const char *c_name;
        int (*c_fun)(struct ukfs *, int, char **);
} command_t;

typedef struct alias_s {
	struct alias_s *al_next;
	char *al_name;
	int al_argc;
	char **al_argv;
} alias_t;

int fsu_alias_main(struct ukfs *, int, char **);
int fsu_cd_main(struct ukfs *, int, char **);
int fsu_exit_main(struct ukfs *, int, char **);
int fsu_help_main(struct ukfs *, int, char **);
int fsu_pwd_main(struct ukfs *, int, char **);
int fsu_umask_main(struct ukfs *, int, char **);
int fsu_unalias_main(struct ukfs *, int, char **);

#endif /* !_FSU_CONSOLE_EXTERN_H_ */
