/*	$NetBSD: tps65217pmicreg.h,v 1.6 2013/08/04 00:24:28 rkujawa Exp $ */

/*-
 * Copyright (c) 2013 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Radoslaw Kujawa.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*#include <sys/cdefs.h>*/

#ifndef _TPS65217PMICREG_H_
#define _TPS65217PMICREG_H_

#define TPS65217PMIC_ADDR		0x24

#define TPS65217PMIC_CHIPID		0x00
#define TPS65217PMIC_CHIPID_VER_MASK	0xF0
#define TPS65217PMIC_CHIPID_REV_MASK	0x0F
#define TPS65217PMIC_CHIPID_VER_A		0x70
#define TPS65217PMIC_CHIPID_VER_B		0xF0
#define TPS65217PMIC_CHIPID_VER_C		0xE0
#define TPS65217PMIC_CHIPID_VER_D		0x60

#define TPS65217PMIC_PPATH		0x01
#define TPS65217PMIC_PPATH_IUSB			__BITS(0,1)
#define TPS65217PMIC_PPATH_IUSB_100MA			0
#define TPS65217PMIC_PPATH_IUSB_500MA			1
#define TPS65217PMIC_PPATH_IUSB_1300MA			2
#define TPS65217PMIC_PPATH_IUSB_1800MA			3
#define TPS65217PMIC_PPATH_IAC			__BITS(2,3)
#define TPS65217PMIC_PPATH_IAC_RSHFIT		2
#define TPS65217PMIC_PPATH_IAC_100MA			0
#define TPS65217PMIC_PPATH_IAC_500MA			1
#define TPS65217PMIC_PPATH_IAC_1300MA			2
#define TPS65217PMIC_PPATH_IAC_2500MA			3
#define TPS65217PMIC_PPATH_USB_EN		__BIT(4)
#define TPS65217PMIC_PPATH_AC_EN		__BIT(5)

#define TPS65217PMIC_INT		0x02
#define TPS65217PMIC_INT_USBI			__BIT(0)
#define TPS65217PMIC_INT_ACI			__BIT(1)
#define TPS65217PMIC_INT_PBI			__BIT(2)
#define TPS65217PMIC_INT_USBM			__BIT(4)
#define TPS65217PMIC_INT_ACM			__BIT(5)
#define TPS65217PMIC_INT_PBM			__BIT(6)

#define TPS65217PMIC_WLEDCTRL1		0x07
#define TPS65217PMIC_WLEDCTRL1_FDIM		__BITS(1,0)
#define TPS65217PMIC_WLEDCTRL1_FDIM_100Hz		0
#define TPS65217PMIC_WLEDCTRL1_FDIM_200Hz		1
#define TPS65217PMIC_WLEDCTRL1_FDIM_500Hz		2
#define TPS65217PMIC_WLEDCTRL1_FDIM_1000Hz		3
#define TPS65217PMIC_WLEDCTRL1_ISEL		__BIT(2)
#define TPS65217PMIC_WLEDCTRL1_ISINK_EN		__BIT(3)

#define TPS65217PMIC_WLEDCTRL2		0x08
#define TPS65217PMIC_WLEDCTRL2_DUTY		__BITS(6,0)

#define TPS65217PMIC_STATUS		0x0A
#define TPS65217PMIC_STATUS_USBPWR		__BIT(2)
#define TPS65217PMIC_STATUS_ACPWR		__BIT(3)

#define TPS65217PMIC_PGOOD		0x0C
#define TPS65217PMIC_PGOOD_LDO3PG		__BIT(0)
#define TPS65217PMIC_PGOOD_LDO4PG		__BIT(1)
#define TPS65217PMIC_PGOOD_DC1PG		__BIT(2)
#define TPS65217PMIC_PGOOD_DC2PG		__BIT(3)
#define TPS65217PMIC_PGOOD_DC3PG		__BIT(4)
#define TPS65217PMIC_PGOOD_LDO1PG		__BIT(5)
#define TPS65217PMIC_PGOOD_LDO2PG		__BIT(6)

#define TPS65217PMIC_DEFLDO1		0x12
#define TPS65217PMIC_DEFLDO2		0x13
#define TPS65217PMIC_DEFLDO3		0x14
#define TPS65217PMIC_DEFLDO4		0x15
#define TPS65217PMIC_DEFDCDC1		0x0E
#define TPS65217PMIC_DEFDCDC2		0x0F
#define TPS65217PMIC_DEFDCDC3		0x10

#define TPS65217PMIC_DEFX_VOLTAGE_16		__BITS(0,3)
#define TPS65217PMIC_DEFX_VOLTAGE_32		__BITS(0,4)
#define TPS65217PMIC_DEFX_VOLTAGE_64		__BITS(0,5)
#define TPS65217PMIC_DEFX_TRACKING		__BIT(6)
#define TPS65217PMIC_DEFX_XADJ			__BIT(7)
#define TPS65217PMIC_DEFX_LS			__BIT(5)

#define TPS65217PMIC_ENABLE		0x16
#define TPS65217PMIC_ENABLE_LDO2		__BIT(0)
#define TPS65217PMIC_ENABLE_LDO1		__BIT(1)
#define TPS65217PMIC_ENABLE_DCDC3		__BIT(2)
#define TPS65217PMIC_ENABLE_DCDC2		__BIT(3)
#define TPS65217PMIC_ENABLE_DCDC1		__BIT(4)
#define TPS65217PMIC_ENABLE_LDO4		__BIT(5)
#define TPS65217PMIC_ENABLE_LDO3		__BIT(6)

#endif /* _TPS65217PMICREG_H_ */
