/* $NetBSD: linux_sysent.c,v 1.48 2013/12/08 15:56:12 njoly Exp $ */

/*
 * System call switch table.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.46 2013/12/08 15:55:10 njoly Exp
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: linux_sysent.c,v 1.48 2013/12/08 15:56:12 njoly Exp $");

#if defined(_KERNEL_OPT)
#include "opt_sysv.h"
#include "opt_compat_43.h"
#include "opt_compat_netbsd.h"
#endif
#include <sys/param.h>
#include <sys/poll.h>
#include <sys/systm.h>
#include <sys/signal.h>
#include <sys/mount.h>
#include <sys/syscallargs.h>
#include <sys/time.h>
#include <compat/sys/time.h>
#include <compat/linux/common/linux_types.h>
#include <compat/linux/common/linux_mmap.h>
#include <compat/linux/common/linux_ipc.h>
#include <compat/linux/common/linux_msg.h>
#include <compat/linux/common/linux_sem.h>
#include <compat/linux/common/linux_shm.h>
#include <compat/linux/common/linux_signal.h>
#include <compat/linux/common/linux_siginfo.h>
#include <compat/linux/common/linux_machdep.h>
#include <compat/linux/linux_syscallargs.h>

#define	s(type)	sizeof(type)
#define	n(type)	(sizeof(type)/sizeof (register_t))
#define	ns(type)	n(type), s(type)

struct sysent linux_sysent[] = {
	{ ns(struct sys_read_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_read },		/* 0 = read */
	{ ns(struct sys_write_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_write },		/* 1 = write */
	{ ns(struct linux_sys_open_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_open },	/* 2 = open */
	{ ns(struct sys_close_args), 0,
	    (sy_call_t *)sys_close },		/* 3 = close */
	{ ns(struct linux_sys_stat64_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_stat64 },	/* 4 = stat64 */
	{ ns(struct linux_sys_fstat64_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_fstat64 },	/* 5 = fstat64 */
	{ ns(struct linux_sys_lstat64_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_lstat64 },	/* 6 = lstat64 */
	{ ns(struct sys_poll_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_poll },		/* 7 = poll */
	{ ns(struct compat_43_sys_lseek_args), 0,
	    (sy_call_t *)compat_43_sys_lseek },	/* 8 = lseek */
	{ ns(struct linux_sys_mmap_args), 0,
	    (sy_call_t *)linux_sys_mmap },	/* 9 = mmap */
	{ ns(struct linux_sys_mprotect_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_mprotect },	/* 10 = mprotect */
	{ ns(struct sys_munmap_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_munmap },		/* 11 = munmap */
	{ ns(struct linux_sys_brk_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_brk },	/* 12 = brk */
	{ ns(struct linux_sys_rt_sigaction_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_rt_sigaction },/* 13 = rt_sigaction */
	{ ns(struct linux_sys_rt_sigprocmask_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_rt_sigprocmask },/* 14 = rt_sigprocmask */
	{ 0, 0, 0,
	    (sy_call_t *)linux_sys_rt_sigreturn },/* 15 = rt_sigreturn */
	{ ns(struct linux_sys_ioctl_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_ioctl },	/* 16 = ioctl */
	{ ns(struct linux_sys_pread_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_pread },	/* 17 = pread */
	{ ns(struct linux_sys_pwrite_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_pwrite },	/* 18 = pwrite */
	{ ns(struct sys_readv_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_readv },		/* 19 = readv */
	{ ns(struct sys_writev_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_writev },		/* 20 = writev */
	{ ns(struct sys_access_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_access },		/* 21 = access */
	{ ns(struct linux_sys_pipe_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_pipe },	/* 22 = pipe */
	{ ns(struct linux_sys_select_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_select },	/* 23 = select */
	{ 0, 0, 0,
	    (sy_call_t *)linux_sys_sched_yield },/* 24 = sched_yield */
	{ ns(struct linux_sys_mremap_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_mremap },	/* 25 = mremap */
	{ ns(struct sys___msync13_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys___msync13 },	/* 26 = __msync13 */
	{ ns(struct sys_mincore_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_mincore },		/* 27 = mincore */
	{ ns(struct sys_madvise_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_madvise },		/* 28 = madvise */
#ifdef SYSVSHM
	{ ns(struct linux_sys_shmget_args), 0,
	    (sy_call_t *)linux_sys_shmget },	/* 29 = shmget */
	{ ns(struct sys_shmat_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_shmat },		/* 30 = shmat */
	{ ns(struct linux_sys_shmctl_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_shmctl },	/* 31 = shmctl */
#else
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 29 = unimplemented shmget */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 30 = unimplemented shmat */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 31 = unimplemented shmctl */
#endif
	{ ns(struct sys_dup_args), 0,
	    (sy_call_t *)sys_dup },		/* 32 = dup */
	{ ns(struct sys_dup2_args), 0,
	    (sy_call_t *)sys_dup2 },		/* 33 = dup2 */
	{ 0, 0, 0,
	    (sy_call_t *)linux_sys_pause },	/* 34 = pause */
	{ ns(struct linux_sys_nanosleep_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_nanosleep },	/* 35 = nanosleep */
	{ ns(struct compat_50_sys_getitimer_args), SYCALL_ARG_PTR,
	    (sy_call_t *)compat_50_sys_getitimer },/* 36 = getitimer */
	{ ns(struct linux_sys_alarm_args), 0,
	    (sy_call_t *)linux_sys_alarm },	/* 37 = alarm */
	{ ns(struct compat_50_sys_setitimer_args), SYCALL_ARG_PTR,
	    (sy_call_t *)compat_50_sys_setitimer },/* 38 = setitimer */
	{ 0, 0, 0,
	    (sy_call_t *)sys_getpid },		/* 39 = getpid */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 40 = unimplemented sendfile */
	{ ns(struct linux_sys_socket_args), 0,
	    (sy_call_t *)linux_sys_socket },	/* 41 = socket */
	{ ns(struct linux_sys_connect_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_connect },	/* 42 = connect */
	{ ns(struct linux_sys_accept_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_accept },	/* 43 = oaccept */
	{ ns(struct linux_sys_sendto_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_sendto },	/* 44 = sendto */
	{ ns(struct linux_sys_recvfrom_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_recvfrom },	/* 45 = recvfrom */
	{ ns(struct linux_sys_sendmsg_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_sendmsg },	/* 46 = sendmsg */
	{ ns(struct linux_sys_recvmsg_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_recvmsg },	/* 47 = recvmsg */
	{ ns(struct sys_shutdown_args), 0,
	    (sy_call_t *)sys_shutdown },	/* 48 = shutdown */
	{ ns(struct linux_sys_bind_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_bind },	/* 49 = bind */
	{ ns(struct sys_listen_args), 0,
	    (sy_call_t *)sys_listen },		/* 50 = listen */
	{ ns(struct linux_sys_getsockname_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_getsockname },/* 51 = getsockname */
	{ ns(struct linux_sys_getpeername_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_getpeername },/* 52 = getpeername */
	{ ns(struct linux_sys_socketpair_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_socketpair },/* 53 = socketpair */
	{ ns(struct linux_sys_setsockopt_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_setsockopt },/* 54 = setsockopt */
	{ ns(struct linux_sys_getsockopt_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_getsockopt },/* 55 = getsockopt */
	{ ns(struct linux_sys_clone_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_clone },	/* 56 = clone */
	{ 0, 0, 0,
	    (sy_call_t *)sys_fork },		/* 57 = fork */
	{ 0, 0, 0,
	    (sy_call_t *)sys___vfork14 },	/* 58 = __vfork14 */
	{ ns(struct sys_execve_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_execve },		/* 59 = execve */
	{ ns(struct linux_sys_exit_args), 0,
	    (sy_call_t *)linux_sys_exit },	/* 60 = exit */
	{ ns(struct linux_sys_wait4_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_wait4 },	/* 61 = wait4 */
	{ ns(struct linux_sys_kill_args), 0,
	    (sy_call_t *)linux_sys_kill },	/* 62 = kill */
	{ ns(struct linux_sys_uname_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_uname },	/* 63 = uname */
#ifdef SYSVSEM
	{ ns(struct sys_semget_args), 0,
	    (sy_call_t *)sys_semget },		/* 64 = semget */
	{ ns(struct sys_semop_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_semop },		/* 65 = semop */
	{ ns(struct linux_sys_semctl_args), 0,
	    (sy_call_t *)linux_sys_semctl },	/* 66 = semctl */
#else
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 64 = unimplemented semget */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 65 = unimplemented semop */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 66 = unimplemented semctl */
#endif
#ifdef SYSVSHM
	{ ns(struct sys_shmdt_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_shmdt },		/* 67 = shmdt */
#else
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 67 = unimplemented shmdt */
#endif
#ifdef SYSVMSG
	{ ns(struct sys_msgget_args), 0,
	    (sy_call_t *)sys_msgget },		/* 68 = msgget */
	{ ns(struct sys_msgsnd_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_msgsnd },		/* 69 = msgsnd */
	{ ns(struct sys_msgrcv_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_msgrcv },		/* 70 = msgrcv */
	{ ns(struct linux_sys_msgctl_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_msgctl },	/* 71 = msgctl */
#else
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 68 = unimplemented msgget */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 69 = unimplemented msgsnd */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 70 = unimplemented msgrcv */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 71 = unimplemented msgctl */
#endif
	{ ns(struct linux_sys_fcntl_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_fcntl },	/* 72 = fcntl */
	{ ns(struct sys_flock_args), 0,
	    (sy_call_t *)sys_flock },		/* 73 = flock */
	{ ns(struct sys_fsync_args), 0,
	    (sy_call_t *)sys_fsync },		/* 74 = fsync */
	{ ns(struct linux_sys_fdatasync_args), 0,
	    (sy_call_t *)linux_sys_fdatasync },	/* 75 = fdatasync */
	{ ns(struct linux_sys_truncate64_args), SYCALL_NARGS64_VAL(1) | SYCALL_ARG1_64 | SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_truncate64 },/* 76 = truncate64 */
	{ ns(struct linux_sys_ftruncate64_args), SYCALL_NARGS64_VAL(1) | SYCALL_ARG1_64,
	    (sy_call_t *)linux_sys_ftruncate64 },/* 77 = ftruncate64 */
	{ ns(struct linux_sys_getdents_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_getdents },	/* 78 = getdents */
	{ ns(struct sys___getcwd_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys___getcwd },	/* 79 = __getcwd */
	{ ns(struct sys_chdir_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_chdir },		/* 80 = chdir */
	{ ns(struct sys_fchdir_args), 0,
	    (sy_call_t *)sys_fchdir },		/* 81 = fchdir */
	{ ns(struct sys___posix_rename_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys___posix_rename },	/* 82 = __posix_rename */
	{ ns(struct sys_mkdir_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_mkdir },		/* 83 = mkdir */
	{ ns(struct sys_rmdir_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_rmdir },		/* 84 = rmdir */
	{ ns(struct linux_sys_creat_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_creat },	/* 85 = creat */
	{ ns(struct sys_link_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_link },		/* 86 = link */
	{ ns(struct linux_sys_unlink_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_unlink },	/* 87 = unlink */
	{ ns(struct sys_symlink_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_symlink },		/* 88 = symlink */
	{ ns(struct sys_readlink_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_readlink },	/* 89 = readlink */
	{ ns(struct sys_chmod_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_chmod },		/* 90 = chmod */
	{ ns(struct sys_fchmod_args), 0,
	    (sy_call_t *)sys_fchmod },		/* 91 = fchmod */
	{ ns(struct sys___posix_chown_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys___posix_chown },	/* 92 = __posix_chown */
	{ ns(struct sys___posix_fchown_args), 0,
	    (sy_call_t *)sys___posix_fchown },	/* 93 = __posix_fchown */
	{ ns(struct sys___posix_lchown_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys___posix_lchown },	/* 94 = __posix_lchown */
	{ ns(struct sys_umask_args), 0,
	    (sy_call_t *)sys_umask },		/* 95 = umask */
	{ ns(struct linux_sys_gettimeofday_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_gettimeofday },/* 96 = gettimeofday */
	{ ns(struct linux_sys_getrlimit_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_getrlimit },	/* 97 = getrlimit */
	{ ns(struct compat_50_sys_getrusage_args), SYCALL_ARG_PTR,
	    (sy_call_t *)compat_50_sys_getrusage },/* 98 = getrusage */
	{ ns(struct linux_sys_sysinfo_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_sysinfo },	/* 99 = sysinfo */
	{ ns(struct linux_sys_times_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_times },	/* 100 = times */
	{ ns(struct linux_sys_ptrace_args), 0,
	    (sy_call_t *)linux_sys_ptrace },	/* 101 = ptrace */
	{ 0, 0, 0,
	    (sy_call_t *)sys_getuid },		/* 102 = getuid */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 103 = unimplemented syslog */
	{ 0, 0, 0,
	    (sy_call_t *)sys_getgid },		/* 104 = getgid */
	{ ns(struct sys_setuid_args), 0,
	    (sy_call_t *)sys_setuid },		/* 105 = setuid */
	{ ns(struct sys_setgid_args), 0,
	    (sy_call_t *)sys_setgid },		/* 106 = setgid */
	{ 0, 0, 0,
	    (sy_call_t *)sys_geteuid },		/* 107 = geteuid */
	{ 0, 0, 0,
	    (sy_call_t *)sys_getegid },		/* 108 = getegid */
	{ ns(struct sys_setpgid_args), 0,
	    (sy_call_t *)sys_setpgid },		/* 109 = setpgid */
	{ 0, 0, 0,
	    (sy_call_t *)sys_getppid },		/* 110 = getppid */
	{ 0, 0, 0,
	    (sy_call_t *)sys_getpgrp },		/* 111 = getpgrp */
	{ 0, 0, 0,
	    (sy_call_t *)sys_setsid },		/* 112 = setsid */
	{ ns(struct sys_setreuid_args), 0,
	    (sy_call_t *)sys_setreuid },	/* 113 = setreuid */
	{ ns(struct sys_setregid_args), 0,
	    (sy_call_t *)sys_setregid },	/* 114 = setregid */
	{ ns(struct sys_getgroups_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_getgroups },	/* 115 = getgroups */
	{ ns(struct sys_setgroups_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_setgroups },	/* 116 = setgroups */
	{ ns(struct linux_sys_setresuid_args), 0,
	    (sy_call_t *)linux_sys_setresuid },	/* 117 = setresuid */
	{ ns(struct linux_sys_getresuid_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_getresuid },	/* 118 = getresuid */
	{ ns(struct linux_sys_setresgid_args), 0,
	    (sy_call_t *)linux_sys_setresgid },	/* 119 = setresgid */
	{ ns(struct linux_sys_getresgid_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_getresgid },	/* 120 = getresgid */
	{ ns(struct sys_getpgid_args), 0,
	    (sy_call_t *)sys_getpgid },		/* 121 = getpgid */
	{ ns(struct linux_sys_setfsuid_args), 0,
	    (sy_call_t *)linux_sys_setfsuid },	/* 122 = setfsuid */
	{ ns(struct linux_sys_setfsgid_args), 0,
	    (sy_call_t *)linux_sys_setfsgid },	/* 123 = setfsgid */
	{ ns(struct sys_getsid_args), 0,
	    (sy_call_t *)sys_getsid },		/* 124 = getsid */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 125 = unimplemented capget */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 126 = unimplemented capset */
	{ ns(struct linux_sys_rt_sigpending_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_rt_sigpending },/* 127 = rt_sigpending */
	{ ns(struct linux_sys_rt_sigtimedwait_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_rt_sigtimedwait },/* 128 = rt_sigtimedwait */
	{ ns(struct linux_sys_rt_queueinfo_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_rt_queueinfo },/* 129 = rt_queueinfo */
	{ ns(struct linux_sys_rt_sigsuspend_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_rt_sigsuspend },/* 130 = rt_sigsuspend */
	{ ns(struct linux_sys_sigaltstack_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_sigaltstack },/* 131 = sigaltstack */
	{ ns(struct linux_sys_utime_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_utime },	/* 132 = utime */
	{ ns(struct linux_sys_mknod_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_mknod },	/* 133 = mknod */
#ifdef EXEC_AOUT
	{ ns(struct linux_sys_uselib_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_uselib },	/* 134 = uselib */
#else
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 134 = unimplemented sys_uselib */
#endif
	{ ns(struct linux_sys_personality_args), 0,
	    (sy_call_t *)linux_sys_personality },/* 135 = personality */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 136 = unimplemented ustat */
	{ ns(struct linux_sys_statfs_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_statfs },	/* 137 = statfs */
	{ ns(struct linux_sys_fstatfs_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_fstatfs },	/* 138 = fstatfs */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 139 = unimplemented sysfs */
	{ ns(struct linux_sys_getpriority_args), 0,
	    (sy_call_t *)linux_sys_getpriority },/* 140 = getpriority */
	{ ns(struct sys_setpriority_args), 0,
	    (sy_call_t *)sys_setpriority },	/* 141 = setpriority */
	{ ns(struct linux_sys_sched_setparam_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_sched_setparam },/* 142 = sched_setparam */
	{ ns(struct linux_sys_sched_getparam_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_sched_getparam },/* 143 = sched_getparam */
	{ ns(struct linux_sys_sched_setscheduler_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_sched_setscheduler },/* 144 = sched_setscheduler */
	{ ns(struct linux_sys_sched_getscheduler_args), 0,
	    (sy_call_t *)linux_sys_sched_getscheduler },/* 145 = sched_getscheduler */
	{ ns(struct linux_sys_sched_get_priority_max_args), 0,
	    (sy_call_t *)linux_sys_sched_get_priority_max },/* 146 = sched_get_priority_max */
	{ ns(struct linux_sys_sched_get_priority_min_args), 0,
	    (sy_call_t *)linux_sys_sched_get_priority_min },/* 147 = sched_get_priority_min */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 148 = unimplemented sys_sched_rr_get_interval */
	{ ns(struct sys_mlock_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_mlock },		/* 149 = mlock */
	{ ns(struct sys_munlock_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_munlock },		/* 150 = munlock */
	{ ns(struct sys_mlockall_args), 0,
	    (sy_call_t *)sys_mlockall },	/* 151 = mlockall */
	{ 0, 0, 0,
	    (sy_call_t *)sys_munlockall },	/* 152 = munlockall */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 153 = unimplemented vhangup */
	{ ns(struct linux_sys_modify_ldt_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_modify_ldt },/* 154 = modify_ldt */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 155 = unimplemented pivot_root */
	{ ns(struct linux_sys___sysctl_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys___sysctl },	/* 156 = __sysctl */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 157 = unimplemented prctl */
	{ ns(struct linux_sys_arch_prctl_args), 0,
	    (sy_call_t *)linux_sys_arch_prctl },/* 158 = arch_prctl */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 159 = unimplemented adjtimex */
	{ ns(struct linux_sys_setrlimit_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_setrlimit },	/* 160 = setrlimit */
	{ ns(struct sys_chroot_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_chroot },		/* 161 = chroot */
	{ 0, 0, 0,
	    (sy_call_t *)sys_sync },		/* 162 = sync */
	{ ns(struct sys_acct_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_acct },		/* 163 = acct */
	{ ns(struct linux_sys_settimeofday_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_settimeofday },/* 164 = settimeofday */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 165 = unimplemented mount */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 166 = unimplemented umount2 */
	{ ns(struct linux_sys_swapon_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_swapon },	/* 167 = swapon */
	{ ns(struct linux_sys_swapoff_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_swapoff },	/* 168 = swapoff */
	{ ns(struct linux_sys_reboot_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_reboot },	/* 169 = reboot */
	{ ns(struct compat_43_sys_sethostname_args), SYCALL_ARG_PTR,
	    (sy_call_t *)compat_43_sys_sethostname },/* 170 = sethostname */
	{ ns(struct linux_sys_setdomainname_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_setdomainname },/* 171 = setdomainname */
	{ ns(struct linux_sys_iopl_args), 0,
	    (sy_call_t *)linux_sys_iopl },	/* 172 = iopl */
	{ ns(struct linux_sys_ioperm_args), 0,
	    (sy_call_t *)linux_sys_ioperm },	/* 173 = ioperm */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 174 = unimplemented create_module */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 175 = unimplemented init_module */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 176 = unimplemented delete_module */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 177 = unimplemented get_kernel_syms */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 178 = unimplemented query_module */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 179 = unimplemented quotactl */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 180 = unimplemented nfsservctl */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 181 = unimplemented getpmsg */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 182 = unimplemented putpmsg */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 183 = unimplemented afs_syscall */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 184 = unimplemented tuxcall */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 185 = unimplemented security */
	{ 0, 0, 0,
	    (sy_call_t *)linux_sys_gettid },	/* 186 = gettid */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 187 = unimplemented readahead */
	{ ns(struct linux_sys_setxattr_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_setxattr },	/* 188 = setxattr */
	{ ns(struct linux_sys_lsetxattr_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_lsetxattr },	/* 189 = lsetxattr */
	{ ns(struct linux_sys_fsetxattr_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_fsetxattr },	/* 190 = fsetxattr */
	{ ns(struct linux_sys_getxattr_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_getxattr },	/* 191 = getxattr */
	{ ns(struct linux_sys_lgetxattr_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_lgetxattr },	/* 192 = lgetxattr */
	{ ns(struct linux_sys_fgetxattr_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_fgetxattr },	/* 193 = fgetxattr */
	{ ns(struct linux_sys_listxattr_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_listxattr },	/* 194 = listxattr */
	{ ns(struct linux_sys_llistxattr_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_llistxattr },/* 195 = llistxattr */
	{ ns(struct linux_sys_flistxattr_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_flistxattr },/* 196 = flistxattr */
	{ ns(struct linux_sys_removexattr_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_removexattr },/* 197 = removexattr */
	{ ns(struct linux_sys_lremovexattr_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_lremovexattr },/* 198 = lremovexattr */
	{ ns(struct linux_sys_fremovexattr_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_fremovexattr },/* 199 = fremovexattr */
	{ ns(struct linux_sys_tkill_args), 0,
	    (sy_call_t *)linux_sys_tkill },	/* 200 = tkill */
	{ ns(struct linux_sys_time_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_time },	/* 201 = time */
	{ ns(struct linux_sys_futex_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_futex },	/* 202 = futex */
	{ ns(struct linux_sys_sched_setaffinity_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_sched_setaffinity },/* 203 = sched_setaffinity */
	{ ns(struct linux_sys_sched_getaffinity_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_sched_getaffinity },/* 204 = sched_getaffinity */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 205 = unimplemented set_thread_area */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 206 = unimplemented io_setup */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 207 = unimplemented io_destroy */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 208 = unimplemented io_getevents */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 209 = unimplemented io_submit */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 210 = unimplemented io_cancel */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 211 = unimplemented get_thread_area */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 212 = unimplemented lookup_dcookie */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 213 = unimplemented epoll_create */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 214 = unimplemented epoll_ctl_old */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 215 = unimplemented epoll_wait_old */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 216 = unimplemented remap_file_pages */
	{ ns(struct linux_sys_getdents64_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_getdents64 },/* 217 = getdents64 */
	{ ns(struct linux_sys_set_tid_address_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_set_tid_address },/* 218 = set_tid_address */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 219 = unimplemented restart_syscall */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 220 = unimplemented semtimedop */
	{ ns(struct linux_sys_fadvise64_args), 0,
	    (sy_call_t *)linux_sys_fadvise64 },	/* 221 = fadvise64 */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 222 = unimplemented timer_create */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 223 = unimplemented timer_settime */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 224 = unimplemented timer_gettime */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 225 = unimplemented timer_getoverrun */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 226 = unimplemented timer_delete */
	{ ns(struct linux_sys_clock_settime_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_clock_settime },/* 227 = clock_settime */
	{ ns(struct linux_sys_clock_gettime_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_clock_gettime },/* 228 = clock_gettime */
	{ ns(struct linux_sys_clock_getres_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_clock_getres },/* 229 = clock_getres */
	{ ns(struct linux_sys_clock_nanosleep_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_clock_nanosleep },/* 230 = clock_nanosleep */
	{ ns(struct linux_sys_exit_group_args), 0,
	    (sy_call_t *)linux_sys_exit_group },/* 231 = exit_group */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 232 = unimplemented epoll_wait */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 233 = unimplemented epoll_ctl */
	{ ns(struct linux_sys_tgkill_args), 0,
	    (sy_call_t *)linux_sys_tgkill },	/* 234 = tgkill */
	{ ns(struct linux_sys_utimes_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_utimes },	/* 235 = utimes */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 236 = unimplemented vserver */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 237 = unimplemented mbind */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 238 = unimplemented set_mempolicy */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 239 = unimplemented get_mempolicy */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 240 = unimplemented mq_open */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 241 = unimplemented mq_unlink */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 242 = unimplemented mq_timedsend */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 243 = unimplemented mq_timedreceive */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 244 = unimplemented mq_notify */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 245 = unimplemented mq_getsetattr */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 246 = unimplemented kexec_load */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 247 = unimplemented waitid */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 248 = unimplemented add_key */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 249 = unimplemented request_key */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 250 = unimplemented keyctl */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 251 = unimplemented ioprio_set */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 252 = unimplemented ioprio_get */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 253 = unimplemented inotify_init */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 254 = unimplemented inotify_add_watch */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 255 = unimplemented inotify_rm_watch */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 256 = unimplemented migrate_pages */
	{ ns(struct linux_sys_openat_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_openat },	/* 257 = openat */
	{ ns(struct sys_mkdirat_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_mkdirat },		/* 258 = mkdirat */
	{ ns(struct linux_sys_mknodat_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_mknodat },	/* 259 = mknodat */
	{ ns(struct linux_sys_fchownat_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_fchownat },	/* 260 = fchownat */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 261 = unimplemented futimesat */
	{ ns(struct linux_sys_fstatat64_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_fstatat64 },	/* 262 = fstatat64 */
	{ ns(struct linux_sys_unlinkat_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_unlinkat },	/* 263 = unlinkat */
	{ ns(struct sys_renameat_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_renameat },	/* 264 = renameat */
	{ ns(struct linux_sys_linkat_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_linkat },	/* 265 = linkat */
	{ ns(struct sys_symlinkat_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_symlinkat },	/* 266 = symlinkat */
	{ ns(struct sys_readlinkat_args), SYCALL_ARG_PTR,
	    (sy_call_t *)sys_readlinkat },	/* 267 = readlinkat */
	{ ns(struct linux_sys_fchmodat_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_fchmodat },	/* 268 = fchmodat */
	{ ns(struct linux_sys_faccessat_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_faccessat },	/* 269 = faccessat */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 270 = unimplemented pselect6 */
	{ ns(struct linux_sys_ppoll_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_ppoll },	/* 271 = ppoll */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 272 = unimplemented unshare */
	{ ns(struct linux_sys_set_robust_list_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_set_robust_list },/* 273 = set_robust_list */
	{ ns(struct linux_sys_get_robust_list_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_get_robust_list },/* 274 = get_robust_list */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 275 = unimplemented splice */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 276 = unimplemented tee */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 277 = unimplemented sync_file_range */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 278 = unimplemented vmsplice */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 279 = unimplemented move_pages */
	{ ns(struct linux_sys_utimensat_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_utimensat },	/* 280 = utimensat */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 281 = unimplemented epoll_pwait */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 282 = unimplemented signalfd */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 283 = unimplemented timerfd_create */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 284 = unimplemented eventfd */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 285 = unimplemented fallocate */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 286 = unimplemented timerfd_settime */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 287 = unimplemented timerfd_gettime */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 288 = unimplemented accept4 */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 289 = unimplemented signalfd4 */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 290 = unimplemented eventfd2 */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 291 = unimplemented epoll_create1 */
	{ ns(struct linux_sys_dup3_args), 0,
	    (sy_call_t *)linux_sys_dup3 },	/* 292 = dup3 */
	{ ns(struct linux_sys_pipe2_args), SYCALL_ARG_PTR,
	    (sy_call_t *)linux_sys_pipe2 },	/* 293 = pipe2 */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 294 = unimplemented inotify_init1 */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 295 = unimplemented preadv */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 296 = unimplemented pwritev */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 297 = unimplemented rt_tgsigqueueinfo */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 298 = unimplemented perf_counter_open */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 299 = unimplemented recvmmsg */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 300 = unimplemented fanotify_init */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 301 = unimplemented fanotify_mark */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 302 = unimplemented prlimit64 */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 303 = unimplemented name_to_handle_at */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 304 = unimplemented open_by_handle_at */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 305 = unimplemented clock_adjtime */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 306 = unimplemented syncfs */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 307 = unimplemented sendmmsg */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 308 = unimplemented setns */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 309 = unimplemented getcpu */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 310 = unimplemented process_vm_readv */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 311 = unimplemented process_vm_writev */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 312 = unimplemented kcmp */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 313 = unimplemented finit_module */
	{ 0, 0, 0,
	    (sy_call_t *)linux_sys_nosys },	/* 314 = nosys */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 315 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 316 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 317 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 318 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 319 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 320 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 321 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 322 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 323 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 324 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 325 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 326 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 327 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 328 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 329 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 330 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 331 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 332 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 333 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 334 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 335 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 336 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 337 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 338 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 339 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 340 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 341 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 342 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 343 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 344 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 345 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 346 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 347 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 348 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 349 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 350 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 351 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 352 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 353 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 354 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 355 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 356 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 357 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 358 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 359 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 360 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 361 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 362 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 363 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 364 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 365 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 366 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 367 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 368 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 369 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 370 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 371 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 372 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 373 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 374 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 375 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 376 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 377 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 378 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 379 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 380 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 381 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 382 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 383 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 384 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 385 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 386 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 387 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 388 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 389 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 390 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 391 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 392 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 393 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 394 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 395 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 396 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 397 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 398 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 399 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 400 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 401 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 402 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 403 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 404 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 405 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 406 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 407 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 408 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 409 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 410 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 411 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 412 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 413 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 414 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 415 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 416 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 417 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 418 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 419 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 420 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 421 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 422 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 423 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 424 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 425 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 426 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 427 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 428 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 429 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 430 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 431 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 432 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 433 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 434 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 435 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 436 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 437 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 438 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 439 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 440 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 441 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 442 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 443 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 444 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 445 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 446 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 447 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 448 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 449 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 450 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 451 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 452 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 453 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 454 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 455 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 456 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 457 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 458 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 459 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 460 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 461 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 462 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 463 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 464 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 465 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 466 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 467 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 468 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 469 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 470 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 471 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 472 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 473 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 474 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 475 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 476 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 477 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 478 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 479 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 480 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 481 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 482 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 483 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 484 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 485 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 486 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 487 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 488 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 489 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 490 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 491 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 492 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 493 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 494 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 495 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 496 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 497 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 498 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 499 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 500 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 501 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 502 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 503 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 504 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 505 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 506 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 507 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 508 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 509 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 510 = filler */
	{ 0, 0, 0,
	    linux_sys_nosys },			/* 511 = filler */
};
