/*	$NetBSD: modsi3.S,v 1.4 2013/08/15 21:40:11 matt Exp $	*/

/*
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <machine/asm.h>

#ifndef __ARM_EABI__
/* 
 * stack is aligned as there's a possibility of branching to .L_overflow
 * which makes a C call
 */

ENTRY(__modsi3)
#ifdef __ARM_ARCH_EXT_IDIV__
	sdiv	r3, r0, r1
	mls	r0, r3, r1, r0
#else
	str	lr, [sp, #-8]!	/* push lr */
	bl	PIC_SYM(__divsi3, PLT)
	mov	r0, r1
	ldr	lr, [sp], #8	/* pop lr */
#endif
	RET
END(__modsi3)

#endif
