/*	$NetBSD$	*/

/*
 * Copyright (c) 2006 Stephen M. Rumble <rumble@ephemeral.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * EFS extent descriptor format and sundry.
 *
 * See IRIX inode(4)
 */

#ifndef _EFS_EXTENT_H_
#define _EFS_EXTENT_H_

/*
 * EFS on-disk extent descriptor (8 bytes)
 *
 * SGI smushed this structure's members into bit fields, but we have to
 * be a little more portable. Therefore we use the native_extent type
 * for in-core manipulation and convert immediately to and from disk.
 *
 * [0] - ex_bn and ex_offset fields are maximally 24 bits in the disk bitfield.
 */
struct efs_extent {
	union {
		uint8_t  bytes[8];
		uint32_t words[2];
	} ex_muddle;
} __packed;
#define ex_bytes ex_muddle.bytes
#define ex_words ex_muddle.words

struct efs_native_extent {
	uint8_t  ex_magic;		/* magic number (always 0) */
	uint32_t ex_bn;			/* bb number in filesystem [0] */
	uint8_t  ex_length;		/* length of extent (in bb) */
	uint32_t ex_offset;		/* logical file offset (in bb) [0] */
};

#define EFS_EXTENT_MAGIC	0
#define EFS_EXTENT_BN_MASK	0x00ffffff
#define EFS_EXTENT_OFFSET_MASK	0x00ffffff

#endif /* !_EFS_EXTENT_H_ */
