#include <sys/param.h>
#include <sys/event.h>
#include <sys/time.h>

#include <err.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>


int
main(int argc, char **argv)
{
	struct timespec	timeout;
	struct timeval	then, now, diff;
	struct kevent	event[2];
	char		buffer[128], *pref;
	int		fd, kq, n, i;

	if (argc != 2)
		errx(1, "Usage: %s file", argv[0]);
	
	fd = open(argv[1], O_RDONLY);
	if (fd == -1)
		err(1, "open: %s", argv[1]);

#ifdef READ_TEST
	lseek(fd, 0, SEEK_END);
#endif

        kq = kqueue();
        if (kq == -1)
                err(1, "kqueue");

printf("registering fd %d\n", fd);
	i=0;
	EV_SET(&event[i], fd, EVFILT_VNODE, EV_ADD | EV_ENABLE | EV_CLEAR,
		NOTE_DELETE | NOTE_WRITE | NOTE_EXTEND | NOTE_ATTRIB |
		NOTE_LINK | NOTE_RENAME | NOTE_REVOKE, NULL, NULL);
	i++;

#ifdef READ_TEST
	EV_SET(&event[i], fd, EVFILT_READ, EV_ADD | EV_ENABLE, 0, NULL, NULL);
	i++;
	printf("i is %d\n", i);
#endif

	n = kevent(kq, event, i, NULL, 0, NULL);
	if (n == -1)
		err(1, "kevent(1)");
	
	timeout.tv_sec = 5;
	timeout.tv_nsec = 0;

	for (;;) {
		pref="";
		if (gettimeofday(&then, NULL) == -1)
			err(1, "gettimeofday then");
		n = kevent(kq, NULL, 0, event, 1, &timeout);
		if (gettimeofday(&now, NULL) == -1)
			err(1, "gettimeofday now");
		timersub(&now, &then, &diff);
		printf("kevent returned %d in %ld.%06ld\n", n,
		    diff.tv_sec, diff.tv_usec);

		if (n == -1)
			err(1, "kevent");
		else if (n == 0)
			continue;

		printf("kevent: filter %d flags: 0x%02x, fflags: 0x%02x [",
		    event[0].filter, event[0].flags, event[0].fflags);

#define DUMPFLAG(x) \
	do \
		if (event[0].fflags & x) { \
			printf ("%s%s", pref, #x); \
			pref=", "; \
		} \
	while (0)

		DUMPFLAG(NOTE_DELETE);
		DUMPFLAG(NOTE_WRITE);
		DUMPFLAG(NOTE_EXTEND);
		DUMPFLAG(NOTE_ATTRIB);
		DUMPFLAG(NOTE_LINK);
		DUMPFLAG(NOTE_RENAME);
		DUMPFLAG(NOTE_REVOKE);
		printf("], data 0x%lx\n", event[0].data);

		if (event[0].filter == EVFILT_READ) {
			if (event[0].data < 0)
				lseek(fd, 0, SEEK_END);
			n = read(fd, buffer, 128);
			buffer[n] = '\0';
			printf("[%d] %s", n, buffer);
		}

		if (event[0].fflags & NOTE_REVOKE) {
			printf("%s revoked\n", argv[1]);
			break;
		}
	}
	return (0);
}
