/*-
 * Copyright(c) 2002-2011 Exar Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification are permitted provided the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. Neither the name of the Exar Corporation nor the names of its
 *       contributors may be used to endorse or promote products derived from
 *       this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*$FreeBSD: stable/9/tools/tools/vxge/vxge_log.h 221175 2011-04-28 16:29:19Z gnn $*/

#ifndef	_VXGE_LOG_H_
#define	_VXGE_LOG_H_

#include "vxge_cmn.h"

#define	VXGE_STR_MAX_LEN_REGS		40
#define	VXGE_STR_MAX_LEN_STATS		32
#define	VXGE_STR_MAX_LEN_PCICONF	20
#define	VXGE_STR_MAX_LEN_DEVCONF	32

#define	VXGE_FORMAT_STATS	"%s%*s%d"
#define	VXGE_FORMAT_DEVCONF	"%s%*s\t%d"
#define	VXGE_FORMAT_PCICONF	"%s%*s\t0x%.4llx\t0x%.4llx"
#define	VXGE_FORMAT_REGS	"| %.8llx | %s%*s | %.16llx      |"
#define	VXGE_FORMAT_HEADER	\
	"| Address  | Name%*s | Value                 |"

static int vxge_nspaces = 0;
static char vxge_line[120] = \
"+-----------------------------------------------------------------------------+";

#define	VXGE_PRINT_LINE(fd) VXGE_PRINT(fd, vxge_line);

#define	VXGE_PRINT_REG_NAME(fd,	parameter) {				\
	VXGE_PRINT(fd, parameter);					\
}

#define	VXGE_PRINT_HEADER(fd, maxSize, Offset)	{			\
	VXGE_PRINT_LINE(fd);						\
	vxge_nspaces = maxSize - 4;					\
	if (Offset == 1) {						\
		VXGE_PRINT(fd, VXGE_FORMAT_HEADER, vxge_nspaces, " ");	\
	} else {							\
		VXGE_PRINT(fd, "Name%*s\tValue", vxge_nspaces, " ");	\
	}								\
	VXGE_PRINT_LINE(fd);						\
}

#define	VXGE_PRINT_HEADER_REGS(fd)					\
	VXGE_PRINT_HEADER(fd, VXGE_STR_MAX_LEN_REGS, 1)

#define	VXGE_PRINT_HEADER_PCICONF(fd)					\
	VXGE_PRINT_HEADER(fd, VXGE_STR_MAX_LEN_PCICONF, 1)

#define	VXGE_PRINT_HEADER_DEVCONF(fd)					\
	VXGE_PRINT_HEADER(fd, VXGE_STR_MAX_LEN_DEVCONF, 0)

#define	VXGE_PRINT_REGS(fd, parameter, offset, value) {			\
	vxge_nspaces = VXGE_STR_MAX_LEN_REGS - strlen(parameter);	\
	VXGE_PRINT(fd, VXGE_FORMAT_REGS, (offset), (parameter),		\
	    (vxge_nspaces), " ", (value));				\
}

#define	VXGE_PRINT_STATS(fd, parameter,	value) {			\
	vxge_nspaces = VXGE_STR_MAX_LEN_STATS - strlen(parameter);	\
	VXGE_PRINT(fd, VXGE_FORMAT_STATS, (parameter),			\
	    (vxge_nspaces), " ", (value));				\
}

#define	STR_FUNC_MODE_SF1_VP17	"Single Function - 1 function(s) 17 VPath(s)/function"
#define	STR_FUNC_MODE_MF2_VP8	"Multi Function - 2 function(s) 8 VPath(s)/function"
#define	STR_FUNC_MODE_MF4_VP4	"Multi Function - 4 function(s) 4 VPath(s)/function"
#define	STR_FUNC_MODE_MF8_VP2	"Multi Function - 8 function(s) 2 VPath(s)/function"
#define	STR_FUNC_MODE_MF8P_VP2	"Multi Function (DirectIO) - 8 function(s) 2 VPath(s)/function"

const char *
vxge_func_mode[12] =
{
	STR_FUNC_MODE_SF1_VP17,
	STR_FUNC_MODE_MF8_VP2,
	"Not supported",
	"Not supported",
	"Not supported",
	"Not supported",
	"Not supported",
	"Not supported",
	STR_FUNC_MODE_MF2_VP8,
	STR_FUNC_MODE_MF4_VP4,
	"Not supported",
	STR_FUNC_MODE_MF8P_VP2
};

const char *
vxge_port_mode[6] =
{
	"Default",
	"Reserved",
	"Active/Passive",
	"Single Port",
	"Dual Port",
	"Disabled"
};

const char *
vxge_port_failure[3] =
{
	"No Failover",
	"Failover only",
	"Failover & Failback"
};

vxge_pci_bar0_t reginfo_registers[] =
{
	{"PRC_STATUS1",					0x00A00, 1},
	{"RXDCM_RESET_IN_PROGRESS",			0x00A08, 1},
	{"REPLICQ_FLUSH_IN_PROGRESS",			0x00A10, 1},
	{"RXPE_CMDS_RESET_IN_PROGRESS",			0x00A18, 1},
	{"MXP_CMDS_RESET_IN_PROGRESS",			0x00A20, 1},
	{"NOFFLOAD_RESET_IN_PROGRESS",			0x00A28, 1},
	{"RD_REQ_IN_PROGRESS",				0x00A30, 1},
	{"RD_REQ_OUTSTANDING",				0x00A38, 1},
	{"KDFC_RESET_IN_PROGRESS",			0x00A40, 1},
	{"ONE_CFG_VP",					0x00B00, 1},
	{"ONE_COMMON",					0x00B08, 1},
	{"TIM_INT_EN",					0x00B80, 1},
	{"TIM_SET_INT_EN",				0x00B88, 1},
	{"TIM_CLR_INT_EN",				0x00B90, 1},
	{"TIM_MASK_INT_DURING_RESET",			0x00B98, 1},
	{"TIM_RESET_IN_PROGRESS",			0x00BA0, 1},
	{"TIM_OUTSTANDING_BMAP",			0x00BA8, 1},
	{"MSG_RESET_IN_PROGRESS",			0x00C00, 1},
	{"MSG_MXP_MR_READY",				0x00C08, 1},
	{"MSG_UXP_MR_READY",				0x00C10, 1},
	{"MSG_DMQ_NONI_RTL_PREFETCH",			0x00C18, 1},
	{"MSG_UMQ_RTL_BWR",				0x00C20, 1},
	{"CMN_RSTHDLR_CFG%d",				0x00D00, 5},
	{"CMN_RSTHDLR_CFG8",				0x00D40, 1},
	{"STATS_CFG0",					0x00D48, 1},
	{"CLEAR_MSIX_MASK_VECT%d",			0x00DA8, 4},
	{"SET_MSIX_MASK_VECT%d",			0x00DC8, 4},
	{"CLEAR_MSIX_MASK_ALL_VECT",			0x00DE8, 1},
	{"SET_MSIX_MASK_ALL_VECT",			0x00DF0, 1},
	{"MASK_VECTOR_%d",				0x00DF8, 4},
	{"MSIX_PENDING_VECTOR_%d",			0x00E18, 4},
	{"CLR_MSIX_ONE_SHOT_VEC%d",			0x00E38, 4},
	{"TITAN_ASIC_ID",				0x00E58, 1},
	{"TITAN_GENERAL_INT_STATUS",			0x00E60, 1},
	{"TITAN_MASK_ALL_INT",				0x00E70, 1},
	{"TIM_INT_STATUS0",				0x00E80, 1},
	{"TIM_INT_MASK0",				0x00E88, 1},
	{"TIM_INT_STATUS1",				0x00E90, 1},
	{"TIM_INT_MASK1",				0x00E98, 1},
	{"RTI_INT_STATUS",				0x00EA0, 1},
	{"RTI_INT_MASK",				0x00EA8, 1},
	{"ADAPTER_STATUS",				0x00EB0, 1},
	{"GEN_CTRL",					0x00EB8, 1},
	{"ADAPTER_READY",				0x00ED0, 1},
	{"OUTSTANDING_READ",				0x00ED8, 1},
	{"VPATH_RST_IN_PROG",				0x00EE0, 1},
	{"VPATH_REG_MODIFIED",				0x00EE8, 1},
	{"QCC_RESET_IN_PROGRESS",			0x00F40, 1},
	{"CP_RESET_IN_PROGRESS",			0x00FC0, 1},
	{"H2L_RESET_IN_PROGRESS",			0x01000, 1},
	{"XGMAC_READY",					0x01080, 1},
	{"FBIF_READY",					0x010C0, 1},
	{"VPLANE_ASSIGNMENTS",				0x01100, 1},
	{"VPATH_ASSIGNMENTS",				0x01108, 1},
	{"RESOURCE_ASSIGNMENTS",			0x01110, 1},
	{"HOST_TYPE_ASSIGNMENTS",			0x01118, 1},
	{"MAX_RESOURCE_ASSIGNMENTS",			0x01128, 1},
	{"PF_VPATH_ASSIGNMENTS",			0x01130, 1},
	{"RTS_ACCESS_ICMP",				0x01200, 1},
	{"RTS_ACCESS_TCPSYN",				0x01208, 1},
	{"RTS_ACCESS_ZL4PYLD",				0x01210, 1},
	{"RTS_ACCESS_L4PRTCL_TCP",			0x01218, 1},
	{"RTS_ACCESS_L4PRTCL_UDP",			0x01220, 1},
	{"RTS_ACCESS_L4PRTCL_FLEX",			0x01228, 1},
	{"RTS_ACCESS_IPFRAG",				0x01230, 1}
};

vxge_pci_bar0_t reginfo_legacy[] =
{
	{"TOC_SWAPPER_FB",				0x00010, 1},
	{"PIFM_RD_SWAP_EN",				0x00018, 1},
	{"PIFM_RD_FLIP_EN",				0x00020, 1},
	{"PIFM_WR_SWAP_EN",				0x00028, 1},
	{"PIFM_WR_FLIP_EN",				0x00030, 1},
	{"TOC_FIRST_POINTER",				0x00038, 1},
	{"HOST_ACCESS_EN",				0x00040, 1}
};

vxge_pci_bar0_t reginfo_pcicfgmgmt[] =
{
	{"RESOURCE_NO",					0x00000, 1},
	{"BARGRP_PF_OR_VF_BAR%d_MASK",			0x00008, 3},
	{"MSIXGRP_NO",					0x00020, 1}
};

vxge_pci_bar0_t reginfo_toc[] =
{
	{"TOC_COMMON_POINTER",				0x00050, 1},
	{"TOC_MEMREPAIR_POINTER",			0x00058, 1},
	{"TOC_PCICFGMGMT_POINTER_%d",			0x00060, 17},
	{"TOC_MRPCIM_POINTER",				0x001E0, 1},
	{"TOC_SRPCIM_POINTER_%d",			0x001E8, 17},
	{"TOC_VPMGMT_POINTER_%d",			0x00278, 17},
	{"TOC_VPATH_POINTER_%d",			0x00390, 17},
	{"TOC_KDFC",					0x004A0, 1},
	{"TOC_USDC",					0x004A8, 1},
	{"TOC_KDFC_VPATH_STRIDE",			0x004B0, 1},
	{"TOC_KDFC_FIFO_STRIDE",			0x004B8, 1}
};

vxge_pci_bar0_t reginfo_vpath[] =
{
	{"USDC_VPATH_VP%d",				0x00300, 1},
	{"WRDMA_ALARM_STATUS_VP%d",			0x00A00, 1},
	{"WRDMA_ALARM_MASK_VP%d",			0x00A08, 1},
	{"PRC_ALARM_REG_VP%d",				0x00A30, 1},
	{"PRC_ALARM_MASK_VP%d",				0x00A38, 1},
	{"PRC_ALARM_ALARM_VP%d",			0x00A40, 1},
	{"PRC_CFG1_VP%d",				0x00A48, 1},
	{"PRC_CFG4_VP%d",				0x00A60, 1},
	{"PRC_CFG5_VP%d",				0x00A68, 1},
	{"PRC_CFG6_VP%d",				0x00A70, 1},
	{"PRC_CFG7_VP%d",				0x00A78, 1},
	{"TIM_DEST_ADDR_VP%d",				0x00A80, 1},
	{"PRC_RXD_DOORBELL_VP%d",			0x00A88, 1},
	{"RQA_PRTY_FOR_VP_VP%d",			0x00A90, 1},
	{"RXDMEM_SIZE_VP%d",				0x00A98, 1},
	{"FRM_IN_PROGRESS_CNT_VP%d",			0x00AA0, 1},
	{"RX_MULTI_CAST_STATS_VP%d",			0x00AA8, 1},
	{"RX_FRM_TRANSFERRED_VP%d",			0x00AB0, 1},
	{"RXD_RETURNED_VP%d",				0x00AB8, 1},
	{"KDFC_FIFO_TRPL_PARTITION_VP%d",		0x00C00, 1},
	{"KDFC_FIFO_TRPL_CTRL_VP%d",			0x00C08, 1},
	{"KDFC_TRPL_FIFO_%d_CTRL_VP%d",			0x00C10, 3},
	{"KDFC_TRPL_FIFO_%d_WB_ADDRESS_VP%d",		0x00C28, 3},
	{"KDFC_TRPL_FIFO_OFFSET_VP%d",			0x00C40, 1},
	{"KDFC_DRBL_TRIPLET_TOTAL_VP%d",		0x00C48, 1},
	{"USDC_DRBL_CTRL_VP%d",				0x00C60, 1},
	{"USDC_VP_READY_VP%d",				0x00C68, 1},
	{"KDFC_STATUS_VP%d",				0x00C70, 1},
	{"XMAC_RPA_VCFG_VP%d",				0x00C80, 1},
	{"RXMAC_VCFG%d_VP%d",				0x00C88, 2},
	{"RTS_ACCESS_STEER_CTRL_VP%d",			0x00C98, 1},
	{"RTS_ACCESS_STEER_DATA%d_VP%d",		0x00CA0, 2},
	{"XMAC_VSPORT_CHOICE_VP%d",			0x00D00, 1},
	{"XMAC_STATS_CFG_VP%d",				0x00D08, 1},
	{"XMAC_STATS_ACCESS_CMD_VP%d",			0x00D10, 1},
	{"XMAC_STATS_ACCESS_DATA_VP%d",			0x00D18, 1},
	{"ASIC_NTWK_VP_CTRL_VP%d",			0x00D20, 1},
	{"XGMAC_VP_INT_STATUS_VP%d",			0x00D30, 1},
	{"XGMAC_VP_INT_MASK_VP%d",			0x00D38, 1},
	{"ASIC_NTWK_VP_ERR_REG_VP%d",			0x00D40, 1},
	{"ASIC_NTWK_VP_ERR_MASK_VP%d",			0x00D48, 1},
	{"ASIC_NTWK_VP_ERR_ALARM_VP%d",			0x00D50, 1},
	{"RTDMA_BW_CTRL_VP%d",				0x00D80, 1},
	{"RTDMA_RD_OPTIMIZATION_CTRL_VP%d",		0x00D88, 1},
	{"PDA_PCC_JOB_MONITOR_VP%d",			0x00D90, 1},
	{"TX_PROTOCOL_ASSIST_CFG_VP%d",			0x00D98, 1},
	{"TIM_CFG1_INT_NUM_%d_VP%d",			0x01000, 4},
	{"TIM_CFG2_INT_NUM_%d_VP%d",			0x01020, 4},
	{"TIM_CFG3_INT_NUM_%d_VP%d",			0x01040, 4},
	{"TIM_WRKLD_CLC_VP%d",				0x01060, 1},
	{"TIM_BITMAP_VP%d",				0x01068, 1},
	{"TIM_RING_ASSN_VP%d",				0x01070, 1},
	{"TIM_REMAP_VP%d",				0x01078, 1},
	{"TIM_VPATH_MAP_VP%d",				0x01080, 1},
	{"TIM_PCI_CFG_VP%d",				0x01088, 1},
	{"SGRP_ASSIGN_VP%d",				0x01100, 1},
	{"SGRP_AOA_AND_RESULT_VP%d",			0x01108, 1},
	{"RPE_PCI_CFG_VP%d",				0x01110, 1},
	{"RPE_LRO_CFG_VP%d",				0x01118, 1},
	{"PE_MR2VP_ACK_BLK_LIMIT_VP%d",			0x01120, 1},
	{"PE_MR2VP_RIRR_LIRR_BLK_LIMIT_VP%d",		0x01128, 1},
	{"TXPE_PCI_NCE_CFG_VP%d",			0x01130, 1},
	{"MSG_QPAD_EN_CFG_VP%d",			0x01180, 1},
	{"MSG_PCI_CFG_VP%d",				0x01188, 1},
	{"UMQDMQ_IR_INIT_VP%d",				0x01190, 1},
	{"DMQ_IR_INT_VP%d",				0x01198, 1},
	{"DMQ_BWR_INIT_ADD_VP%d",			0x011A0, 1},
	{"DMQ_BWR_INIT_BYTE_VP%d",			0x011A8, 1},
	{"DMQ_IR_VP%d",					0x011B0, 1},
	{"UMQ_INT_VP%d",				0x011B8, 1},
	{"UMQ_MR2VP_BWR_PFCH_INIT_VP%d",		0x011C0, 1},
	{"UMQ_BWR_PFCH_CTRL_VP%d",			0x011C8, 1},
	{"UMQ_MR2VP_BWR_EOL_VP%d",			0x011D0, 1},
	{"UMQ_BWR_INIT_ADD_VP%d",			0x011D8, 1},
	{"UMQ_BWR_INIT_BYTE_VP%d",			0x011E0, 1},
	{"GENDMA_INT_VP%d",				0x011E8, 1},
	{"UMQDMQ_IR_INIT_NOTIFY_VP%d",			0x011F0, 1},
	{"DMQ_INIT_NOTIFY_VP%d",			0x011F8, 1},
	{"UMQ_INIT_NOTIFY_VP%d",			0x01200, 1},
	{"TPA_CFG_VP%d",				0x01380, 1},
	{"TX_VP_RESET_DISCARDED_FRMS_VP%d",		0x01400, 1},
	{"FAU_RPA_VCFG_VP%d",				0x01480, 1},
	{"FAU_ADAPTIVE_LRO_FILTER_CTRL_VP%d",		0x014A8, 1},
	{"FAU_ADAPTIVE_LRO_FILTER_IP_DATA0_VP%d",	0x014B0, 1},
	{"FAU_ADAPTIVE_LRO_FILTER_IP_DATA1_VP%d",	0x014B8, 1},
	{"FAU_ADAPTIVE_LRO_FILTER_VLAN_DATA_VP%d",	0x014C0, 1},
	{"DBG_STATS_RX_MPA_VP%d",			0x014D0, 1},
	{"DBG_STATS_RX_FAU_VP%d",			0x014D8, 1},
	{"FBMC_VP_RDY_VP%d",				0x014F0, 1},
	{"VPATH_PCIPIF_INT_STATUS_VP%d",		0x01E00, 1},
	{"VPATH_PCIPIF_INT_MASK_VP%d",			0x01E08, 1},
	{"SRPCIM_MSG_TO_VPATH_REG_VP%d",		0x01E20, 1},
	{"SRPCIM_MSG_TO_VPATH_MASK_VP%d",		0x01E28, 1},
	{"SRPCIM_MSG_TO_VPATH_ALARM_VP%d",		0x01E30, 1},
	{"VPATH_TO_SRPCIM_WMSG_VP%d",			0x01EA0, 1},
	{"VPATH_TO_SRPCIM_WMSG_TRIG_VP%d",		0x01EA8, 1},
	{"VPATH_GENERAL_INT_STATUS_VP%d",		0x02000, 1},
	{"VPATH_GENERAL_INT_MASK_VP%d",			0x02008, 1},
	{"VPATH_PPIF_INT_STATUS_VP%d",			0x02010, 1},
	{"VPATH_PPIF_INT_MASK_VP%d",			0x02018, 1},
	{"KDFCCTL_ERRORS_REG_VP%d",			0x02020, 1},
	{"KDFCCTL_ERRORS_MASK_VP%d",			0x02028, 1},
	{"KDFCCTL_ERRORS_ALARM_VP%d",			0x02030, 1},
	{"GENERAL_ERRORS_REG_VP%d",			0x02040, 1},
	{"GENERAL_ERRORS_MASK_VP%d",			0x02048, 1},
	{"GENERAL_ERRORS_ALARM_VP%d",			0x02050, 1},
	{"PCI_CONFIG_ERRORS_REG_VP%d",			0x02058, 1},
	{"PCI_CONFIG_ERRORS_MASK_VP%d",			0x02060, 1},
	{"PCI_CONFIG_ERRORS_ALARM_VP%d",		0x02068, 1},
	{"MRPCIM_TO_VPATH_ALARM_REG_VP%d",		0x02070, 1},
	{"MRPCIM_TO_VPATH_ALARM_MASK_VP%d",		0x02078, 1},
	{"MRPCIM_TO_VPATH_ALARM_ALARM_VP%d",		0x02080, 1},
	{"SRPCIM_TO_VPATH_ALARM_REG_VP%d",		0x02088, 1},
	{"SRPCIM_TO_VPATH_ALARM_MASK_VP%d",		0x02090, 1},
	{"SRPCIM_TO_VPATH_ALARM_ALARM_VP%d",		0x02098, 1},
	{"KDFCCTL_STATUS_VP%d",				0x02108, 1},
	{"RSTHDLR_STATUS_VP%d",				0x02110, 1},
	{"FIFO%d_STATUS_VP%d",				0x02118, 3},
	{"TGT_ILLEGAL_ACCESS_VP%d",			0x02158, 1},
	{"VPATH_GENERAL_CFG1_VP%d",			0x02200, 1},
	{"VPATH_GENERAL_CFG2_VP%d",			0x02208, 1},
	{"VPATH_GENERAL_CFG3_VP%d",			0x02210, 1},
	{"KDFCCTL_CFG0_VP%d",				0x02220, 1},
	{"DBLGEN_CFG%d_VP%d",				0x02228, 8},
	{"STATS_CFG_VP%d",				0x02268, 1},
	{"INTERRUPT_CFG0_VP%d",				0x02270, 1},
	{"INTERRUPT_CFG2_VP%d",				0x02280, 1},
	{"ONE_SHOT_VECT%d_EN_VP%d",			0x02288, 4},
	{"PCI_CONFIG_ACCESS_CFG1_VP%d",			0x022B0, 1},
	{"PCI_CONFIG_ACCESS_CFG2_VP%d",			0x022B8, 1},
	{"PCI_CONFIG_ACCESS_STATUS_VP%d",		0x022C0, 1},
	{"VPATH_DEBUG_STATS%d_VP%d",			0x02300, 7},
	{"VPATH_GENSTATS_COUNT01_VP%d",			0x02338, 1},
	{"VPATH_GENSTATS_COUNT23_VP%d",			0x02340, 1},
	{"VPATH_GENSTATS_COUNT4_VP%d",			0x02348, 1},
	{"VPATH_GENSTATS_COUNT5_VP%d",			0x02350, 1},
	{"QCC_PCI_CFG_VP%d",				0x02540, 1},
	{"H2L_VPATH_CONFIG_VP%d",			0x02600, 1},
	{"H2L_ZERO_BYTE_READ_ADDRESS_VP%d",		0x02608, 1},
	{"PH2L_VP_CFG0_VP%d",				0x02640, 1}
};

vxge_pci_bar0_t reginfo_vpmgmt[] =
{
	{"ONE_CFG_SR_RDY",				0x00000, 1},
	{"SGRP_OWN",					0x00008, 1},
	{"VPATH_TO_FUNC_MAP_CFG1",			0x00040, 1},
	{"VPATH_IS_FIRST",				0x00048, 1},
	{"SRPCIM_TO_VPATH_WMSG",			0x00050, 1},
	{"SRPCIM_TO_VPATH_WMSG_TRIG",			0x00058, 1},
	{"TIM_VPATH_ASSIGNMENT",			0x00100, 1},
	{"RQA_TOP_PRTY_FOR_VP",				0x00140, 1},
	{"USDC_VPATH_OWN",				0x00180, 1},
	{"RXMAC_RX_PA_CFG0_VPMGMT_CLONE",		0x001C0, 1},
	{"RTS_MGR_CFG0_VPMGMT_CLONE",			0x001C8, 1},
	{"RTS_MGR_CRITERIA_PRIORITY_VPMGMT_CLONE",	0x001D0, 1},
	{"RXMAC_CFG0_PORT_VPMGMT_CLONE_%d",		0x001D8, 3},
	{"RXMAC_PAUSE_CFG_PORT_VPMGMT_CLONE_%d",	0x001F0, 3},
	{"XMAC_VSPORT_CHOICES_VP",			0x00240, 1},
	{"XGMAC_GEN_STATUS_VPMGMT_CLONE",		0x00260, 1},
	{"XGMAC_STATUS_PORT_VPMGMT_CLONE_%d",		0x00268, 2},
	{"XMAC_GEN_CFG_VPMGMT_CLONE",			0x00278, 1},
	{"XMAC_TIMESTAMP_VPMGMT_CLONE",			0x00280, 1},
	{"XMAC_STATS_GEN_CFG_VPMGMT_CLONE",		0x00288, 1},
	{"XMAC_CFG_PORT_VPMGMT_CLONE_%d",		0x00290, 3},
	{"TXMAC_GEN_CFG0_VPMGMT_CLONE",			0x002C0, 1},
	{"TXMAC_CFG0_PORT_VPMGMT_CLONE_%d",		0x002C8, 3},
	{"WOL_MP_CRC",					0x00300, 1},
	{"WOL_MP_MASK_A",				0x00308, 1},
	{"WOL_MP_MASK_B",				0x00310, 1},
	{"FAU_PA_CFG_VPMGMT_CLONE",			0x00360, 1},
	{"RX_DATAPATH_UTIL_VP_CLONE",			0x00368, 1},
	{"TX_DATAPATH_UTIL_VP_CLONE",			0x00380, 1}
};

vxge_pci_bar0_t reginfo_mrpcim[] =
{
	{"G3FBCT_INT_STATUS",				0x00000, 1},
	{"G3FBCT_INT_MASK",				0x00008, 1},
	{"G3FBCT_ERR_REG",				0x00010, 1},
	{"G3FBCT_ERR_MASK",				0x00018, 1},
	{"G3FBCT_ERR_ALARM",				0x00020, 1},
	{"G3FBCT_CONFIG%d",				0x00028, 3},
	{"G3FBCT_INIT%d",				0x00040, 6},
	{"G3FBCT_DLL_TRAINING1",			0x00070, 1},
	{"G3FBCT_DLL_TRAINING2",			0x00078, 1},
	{"G3FBCT_DLL_TRAINING3",			0x00080, 1},
	{"G3FBCT_DLL_TRAINING4",			0x00088, 1},
	{"G3FBCT_DLL_TRAINING6",			0x00090, 1},
	{"G3FBCT_DLL_TRAINING7",			0x00098, 1},
	{"G3FBCT_DLL_TRAINING8",			0x000A0, 1},
	{"G3FBCT_DLL_TRAINING9",			0x000A8, 1},
	{"G3FBCT_DLL_TRAINING5",			0x000B0, 1},
	{"G3FBCT_DLL_TRAINING10",			0x000B8, 1},
	{"G3FBCT_DLL_TRAINING11",			0x000C0, 1},
	{"G3FBCT_INIT6",				0x000C8, 1},
	{"G3FBCT_TEST0",				0x000D0, 1},
	{"G3FBCT_TEST01",				0x000D8, 1},
	{"G3FBCT_TEST1",				0x000E0, 1},
	{"G3FBCT_TEST2",				0x000E8, 1},
	{"G3FBCT_TEST11",				0x000F0, 1},
	{"G3FBCT_TEST21",				0x000F8, 1},
	{"G3FBCT_TEST3",				0x00100, 1},
	{"G3FBCT_TEST4",				0x00108, 1},
	{"G3FBCT_TEST31",				0x00110, 1},
	{"G3FBCT_TEST41",				0x00118, 1},
	{"G3FBCT_TEST5",				0x00120, 1},
	{"G3FBCT_TEST6",				0x00128, 1},
	{"G3FBCT_TEST51",				0x00130, 1},
	{"G3FBCT_TEST61",				0x00138, 1},
	{"G3FBCT_TEST7",				0x00140, 1},
	{"G3FBCT_TEST71",				0x00148, 1},
	{"G3FBCT_LOOP_BACK",				0x001B0, 1},
	{"G3FBCT_LOOP_BACK1",				0x001B8, 1},
	{"G3FBCT_LOOP_BACK2",				0x001C0, 1},
	{"G3FBCT_LOOP_BACK3",				0x001C8, 1},
	{"G3FBCT_LOOP_BACK4",				0x001D0, 1},
	{"G3FBCT_LOOP_BACK5",				0x001D8, 1},
	{"G3FBCT_LOOP_BACK_RDLL_%d",			0x00200, 4},
	{"G3FBCT_LOOP_BACK_WDLL_%d",			0x00220, 4},
	{"G3FBCT_TRAN_WRD_CNT",				0x00240, 1},
	{"G3FBCT_TRAN_AP_CNT",				0x00248, 1},
	{"G3FBCT_G3BIST",				0x00250, 1},
	{"WRDMA_INT_STATUS",				0x00A00, 1},
	{"WRDMA_INT_MASK",				0x00A08, 1},
	{"RC_ALARM_REG",				0x00A10, 1},
	{"RC_ALARM_MASK",				0x00A18, 1},
	{"RC_ALARM_ALARM",				0x00A20, 1},
	{"RXDRM_SM_ERR_REG",				0x00A28, 1},
	{"RXDRM_SM_ERR_MASK",				0x00A30, 1},
	{"RXDRM_SM_ERR_ALARM",				0x00A38, 1},
	{"RXDCM_SM_ERR_REG",				0x00A40, 1},
	{"RXDCM_SM_ERR_MASK",				0x00A48, 1},
	{"RXDCM_SM_ERR_ALARM",				0x00A50, 1},
	{"RXDWM_SM_ERR_REG",				0x00A58, 1},
	{"RXDWM_SM_ERR_MASK",				0x00A60, 1},
	{"RXDWM_SM_ERR_ALARM",				0x00A68, 1},
	{"RDA_ERR_REG",					0x00A70, 1},
	{"RDA_ERR_MASK",				0x00A78, 1},
	{"RDA_ERR_ALARM",				0x00A80, 1},
	{"RDA_ECC_DB_REG",				0x00A88, 1},
	{"RDA_ECC_DB_MASK",				0x00A90, 1},
	{"RDA_ECC_DB_ALARM",				0x00A98, 1},
	{"RDA_ECC_SG_REG",				0x00AA0, 1},
	{"RDA_ECC_SG_MASK",				0x00AA8, 1},
	{"RDA_ECC_SG_ALARM",				0x00AB0, 1},
	{"RQA_ERR_REG",					0x00AB8, 1},
	{"RQA_ERR_MASK",				0x00AC0, 1},
	{"RQA_ERR_ALARM",				0x00AC8, 1},
	{"FRF_ALARM_REG",				0x00AD0, 1},
	{"FRF_ALARM_MASK",				0x00AD8, 1},
	{"FRF_ALARM_ALARM",				0x00AE0, 1},
	{"ROCRC_ALARM_REG",				0x00AE8, 1},
	{"ROCRC_ALARM_MASK",				0x00AF0, 1},
	{"ROCRC_ALARM_ALARM",				0x00AF8, 1},
	{"WDE0_ALARM_REG",				0x00B00, 1},
	{"WDE0_ALARM_MASK",				0x00B08, 1},
	{"WDE0_ALARM_ALARM",				0x00B10, 1},
	{"WDE1_ALARM_REG",				0x00B18, 1},
	{"WDE1_ALARM_MASK",				0x00B20, 1},
	{"WDE1_ALARM_ALARM",				0x00B28, 1},
	{"WDE2_ALARM_REG",				0x00B30, 1},
	{"WDE2_ALARM_MASK",				0x00B38, 1},
	{"WDE2_ALARM_ALARM",				0x00B40, 1},
	{"WDE3_ALARM_REG",				0x00B48, 1},
	{"WDE3_ALARM_MASK",				0x00B50, 1},
	{"WDE3_ALARM_ALARM",				0x00B58, 1},
	{"RC_CFG",					0x00B60, 1},
	{"ECC_CFG",					0x00B68, 1},
	{"RXD_CFG_1BM",					0x00B70, 1},
	{"RXD_CFG1_1BM",				0x00B78, 1},
	{"RXD_CFG2_1BM",				0x00B80, 1},
	{"RXD_CFG3_1BM",				0x00B88, 1},
	{"RXD_CFG4_1BM",				0x00B90, 1},
	{"RXD_CFG_3BM",					0x00B98, 1},
	{"RXD_CFG1_3BM",				0x00BA0, 1},
	{"RXD_CFG2_3BM",				0x00BA8, 1},
	{"RXD_CFG3_3BM",				0x00BB0, 1},
	{"RXD_CFG4_3BM",				0x00BB8, 1},
	{"RXD_CFG_5BM",					0x00BC0, 1},
	{"RXD_CFG1_5BM",				0x00BC8, 1},
	{"RXD_CFG2_5BM",				0x00BD0, 1},
	{"RXD_CFG3_5BM",				0x00BD8, 1},
	{"RXD_CFG4_5BM",				0x00BE0, 1},
	{"RX_W_ROUND_ROBIN_%d",				0x00BE8, 22},
	{"RX_QUEUE_PRIORITY_%d",			0x00C98, 3},
	{"REPLICATION_QUEUE_PRIORITY",			0x00CC8, 1},
	{"RX_QUEUE_SELECT",				0x00CD0, 1},
	{"RQA_VPBP_CTRL",				0x00CD8, 1},
	{"RX_MULTI_CAST_CTRL",				0x00CE0, 1},
	{"WDE_PRM_CTRL",				0x00CE8, 1},
	{"NOA_CTRL",					0x00CF0, 1},
	{"PHASE_CFG",					0x00CF8, 1},
	{"RCQ_BYPQ_CFG",				0x00D00, 1},
	{"DOORBELL_INT_STATUS",				0x00E00, 1},
	{"DOORBELL_INT_MASK",				0x00E08, 1},
	{"KDFC_ERR_REG",				0x00E10, 1},
	{"KDFC_ERR_MASK",				0x00E18, 1},
	{"KDFC_ERR_REG_ALARM",				0x00E20, 1},
	{"USDC_ERR_REG",				0x00E28, 1},
	{"USDC_ERR_MASK",				0x00E30, 1},
	{"USDC_ERR_REG_ALARM",				0x00E38, 1},
	{"KDFC_VP_PARTITION_%d",			0x00E40, 9},
	{"KDFC_W_ROUND_ROBIN_%d",			0x00E88, 60},
	{"KDFC_ENTRY_TYPE_SEL_%d",			0x01068, 2},
	{"KDFC_FIFO_%d_CTRL",				0x01078, 51},
	{"KDFC_KRNL_USR_CTRL",				0x01210, 1},
	{"KDFC_PDA_MONITOR",				0x01218, 1},
	{"KDFC_MP_MONITOR",				0x01220, 1},
	{"KDFC_PE_MONITOR",				0x01228, 1},
	{"KDFC_READ_CNTRL",				0x01230, 1},
	{"KDFC_READ_DATA",				0x01238, 1},
	{"KDFC_FORCE_VALID_CTRL",			0x01240, 1},
	{"KDFC_MULTI_CYCLE_CTRL",			0x01248, 1},
	{"KDFC_ECC_CTRL",				0x01250, 1},
	{"KDFC_VPBP_CTRL",				0x01258, 1},
	{"RXMAC_INT_STATUS",				0x01600, 1},
	{"RXMAC_INT_MASK",				0x01608, 1},
	{"RXMAC_GEN_ERR_REG",				0x01618, 1},
	{"RXMAC_GEN_ERR_MASK",				0x01620, 1},
	{"RXMAC_GEN_ERR_ALARM",				0x01628, 1},
	{"RXMAC_ECC_ERR_REG",				0x01630, 1},
	{"RXMAC_ECC_ERR_MASK",				0x01638, 1},
	{"RXMAC_ECC_ERR_ALARM",				0x01640, 1},
	{"RXMAC_VARIOUS_ERR_REG",			0x01648, 1},
	{"RXMAC_VARIOUS_ERR_MASK",			0x01650, 1},
	{"RXMAC_VARIOUS_ERR_ALARM",			0x01658, 1},
	{"RXMAC_GEN_CFG",				0x01660, 1},
	{"RXMAC_AUTHORIZE_ALL_ADDR",			0x01668, 1},
	{"RXMAC_AUTHORIZE_ALL_VID",			0x01670, 1},
	{"RXMAC_THRESH_CROSS_REPL",			0x016B8, 1},
	{"RXMAC_RED_RATE_REPL_QUEUE",			0x016C0, 1},
	{"RXMAC_CFG0_PORT%d",				0x016E0, 3},
	{"RXMAC_CFG2_PORT%d",				0x01710, 3},
	{"RXMAC_PAUSE_CFG_PORT%d",			0x01728, 3},
	{"RXMAC_RED_CFG0_PORT%d",			0x01758, 3},
	{"RXMAC_RED_CFG1_PORT%d",			0x01770, 3},
	{"RXMAC_RED_CFG2_PORT%d",			0x01788, 3},
	{"RXMAC_LINK_UTIL_PORT%d",			0x017A0, 3},
	{"RXMAC_STATUS_PORT%d",				0x017D0, 3},
	{"RXMAC_RX_PA_CFG%d",				0x01800, 2},
	{"RTS_MGR_CFG%d",				0x01828, 2},
	{"RTS_MGR_CRITERIA_PRIORITY",			0x01838, 1},
	{"RTS_MGR_DA_PAUSE_CFG",			0x01840, 1},
	{"RTS_MGR_DA_SLOW_PROTO_CFG",			0x01848, 1},
	{"RTS_MGR_STEER_CTRL",				0x018A8, 1},
	{"RTS_MGR_STEER_DATA0",				0x018B0, 1},
	{"RTS_MGR_STEER_DATA1",				0x018B8, 1},
	{"RTS_MGR_STEER_VPATH_VECTOR",			0x018C0, 1},
	{"XMAC_STATS_RX_XGMII_CHAR",			0x01930, 1},
	{"XMAC_STATS_RX_XGMII_COLUMN1",			0x01938, 1},
	{"XMAC_STATS_RX_XGMII_COLUMN2",			0x01940, 1},
	{"XMAC_STATS_RX_XGMII_BEHAV_COLUMN2",		0x01948, 1},
	{"XMAC_RX_XGMII_CAPTURE_CTRL_PORT%d",		0x01950, 3},
	{"DBG_STAT_RX_ANY_FRMS",			0x01968, 1},
	{"RXMAC_RED_RATE_VP%d",				0x01A00, 17},
	{"RXMAC_THRESH_CROSS_VP%d",			0x01C00, 17},
	{"XGMAC_INT_STATUS",				0x01E00, 1},
	{"XGMAC_INT_MASK",				0x01E08, 1},
	{"XMAC_GEN_ERR_REG",				0x01E10, 1},
	{"XMAC_GEN_ERR_MASK",				0x01E18, 1},
	{"XMAC_GEN_ERR_ALARM",				0x01E20, 1},
	{"XMAC_LINK_ERR_PORT_REG%d",			0x01E28, 2},
	{"XMAC_LINK_ERR_PORT_MASK%d",			0x01E30, 2},
	{"XMAC_LINK_ERR_PORT_ALARM%d",			0x01E38, 2},
	{"XGXS_GEN_ERR_REG",				0x01E58, 1},
	{"XGXS_GEN_ERR_MASK",				0x01E60, 1},
	{"XGXS_GEN_ERR_ALARM",				0x01E68, 1},
	{"ASIC_NTWK_ERR_REG",				0x01E70, 1},
	{"ASIC_NTWK_ERR_MASK",				0x01E78, 1},
	{"ASIC_NTWK_ERR_ALARM",				0x01E80, 1},
	{"ASIC_GPIO_ERR_REG",				0x01E88, 1},
	{"ASIC_GPIO_ERR_MASK",				0x01E90, 1},
	{"ASIC_GPIO_ERR_ALARM",				0x01E98, 1},
	{"XGMAC_GEN_STATUS",				0x01EA0, 1},
	{"XGMAC_GEN_FW_MEMO_STATUS",			0x01EA8, 1},
	{"XGMAC_GEN_FW_MEMO_MASK",			0x01EB0, 1},
	{"XGMAC_GEN_FW_VPATH_TO_VSPORT_STATUS",		0x01EB8, 1},
	{"XGMAC_MAIN_CFG_PORT%d",			0x01EC0, 2},
	{"XGMAC_DEBOUNCE_PORT%d",			0x01ED0, 2},
	{"XGMAC_STATUS_PORT%d",				0x01EE0, 2},
	{"XMAC_GEN_CFG",				0x01F40, 1},
	{"XMAC_TIMESTAMP",				0x01F48, 1},
	{"XMAC_STATS_GEN_CFG",				0x01F50, 1},
	{"XMAC_STATS_SYS_CMD",				0x01F58, 1},
	{"XMAC_STATS_SYS_DATA",				0x01F60, 1},
	{"ASIC_NTWK_CTRL",				0x01F80, 1},
	{"ASIC_NTWK_CFG_SHOW_PORT_INFO",		0x01F88, 1},
	{"ASIC_NTWK_CFG_PORT_NUM",			0x01F90, 1},
	{"XMAC_CFG_PORT%d",				0x01F98, 3},
	{"XMAC_STATION_ADDR_PORT%d",			0x01FB0, 2},
	{"ASIC_LED_ACTIVITY_CTRL_PORT%d",		0x01FC0, 3},
	{"LAG_CFG",					0x02020, 1},
	{"LAG_STATUS",					0x02028, 1},
	{"LAG_ACTIVE_PASSIVE_CFG",			0x02030, 1},
	{"LAG_LACP_CFG",				0x02040, 1},
	{"LAG_TIMER_CFG_1",				0x02048, 1},
	{"LAG_TIMER_CFG_2",				0x02050, 1},
	{"LAG_SYS_ID",					0x02058, 1},
	{"LAG_SYS_CFG",					0x02060, 1},
	{"LAG_AGGR_ADDR_CFG%d",				0x02070, 2},
	{"LAG_AGGR_ID_CFG%d",				0x02080, 2},
	{"LAG_AGGR_ADMIN_KEY%d",			0x02090, 2},
	{"LAG_AGGR_ALT_ADMIN_KEY",			0x020A0, 1},
	{"LAG_AGGR_OPER_KEY%d",				0x020A8, 2},
	{"LAG_AGGR_PARTNER_SYS_ID%d",			0x020B8, 2},
	{"LAG_AGGR_PARTNER_INFO%d",			0x020C8, 2},
	{"LAG_AGGR_STATE%d",				0x020D8, 2},
	{"LAG_PORT_CFG%d",				0x020F0, 2},
	{"LAG_PORT_ACTOR_ADMIN_CFG%d",			0x02100, 2},
	{"LAG_PORT_ACTOR_ADMIN_STATE%d",		0x02110, 2},
	{"LAG_PORT_PARTNER_ADMIN_SYS_ID%d",		0x02120, 2},
	{"LAG_PORT_PARTNER_ADMIN_CFG%d",		0x02130, 2},
	{"LAG_PORT_PARTNER_ADMIN_STATE%d",		0x02140, 2},
	{"LAG_PORT_TO_AGGR%d",				0x02150, 2},
	{"LAG_PORT_ACTOR_OPER_KEY%d",			0x02160, 2},
	{"LAG_PORT_ACTOR_OPER_STATE%d",			0x02170, 2},
	{"LAG_PORT_PARTNER_OPER_SYS_ID%d",		0x02180, 2},
	{"LAG_PORT_PARTNER_OPER_INFO%d",		0x02190, 2},
	{"LAG_PORT_PARTNER_OPER_STATE%d",		0x021A0, 2},
	{"LAG_PORT_STATE_VARS%d",			0x021B0, 2},
	{"LAG_PORT_TIMER_CNTR%d",			0x021C0, 2},
	{"TRANSCEIVER_RESET_PORT%d",			0x021E0, 2},
	{"TRANSCEIVER_CTRL_PORT%d",			0x021F0, 2},
	{"ASIC_GPIO_CTRL",				0x02200, 1},
	{"ASIC_LED_BEACON_CTRL",			0x02208, 1},
	{"ASIC_LED_CTRL%d",				0x02210, 2},
	{"ASIC_LED_DEBUG_SEL",				0x02220, 1},
	{"USDC_SGRP_PARTITION",				0x02300, 1},
	{"USDC_UGRP_PRIORITY_%d",			0x02308, 17},
	{"UGRP_HTN_WRR_PRIORITY_%d",			0x02398, 20},
	{"USDC_VPLANE_%d",				0x02438, 17},
	{"USDC_SGRP_ASSIGNMENT",			0x024C8, 1},
	{"USDC_CNTRL",					0x024D0, 1},
	{"USDC_READ_CNTRL",				0x024D8, 1},
	{"USDC_READ_DATA",				0x024E0, 1},
	{"UGRP_SRQ_WRR_PRIORITY_%d",			0x02500, 20},
	{"UGRP_CQRQ_WRR_PRIORITY_%d",			0x025A0, 20},
	{"USDC_ECC_CTRL",				0x02640, 1},
	{"USDC_VPBP_CTRL",				0x02648, 1},
	{"RTDMA_INT_STATUS",				0x02700, 1},
	{"RTDMA_INT_MASK",				0x02708, 1},
	{"PDA_ALARM_REG",				0x02710, 1},
	{"PDA_ALARM_MASK",				0x02718, 1},
	{"PDA_ALARM_ALARM",				0x02720, 1},
	{"PCC_ERROR_REG",				0x02728, 1},
	{"PCC_ERROR_MASK",				0x02730, 1},
	{"PCC_ERROR_ALARM",				0x02738, 1},
	{"LSO_ERROR_REG",				0x02740, 1},
	{"LSO_ERROR_MASK",				0x02748, 1},
	{"LSO_ERROR_ALARM",				0x02750, 1},
	{"SM_ERROR_REG",				0x02758, 1},
	{"SM_ERROR_MASK",				0x02760, 1},
	{"SM_ERROR_ALARM",				0x02768, 1},
	{"PDA_CONTROL",					0x02770, 1},
	{"PDA_PDA_CONTROL_0",				0x02778, 1},
	{"PDA_PDA_SERVICE_STATE_%d",			0x02780, 3},
	{"PDA_PDA_TASK_PRIORITY_NUMBER",		0x02798, 1},
	{"PDA_VP",					0x027A0, 1},
	{"TXD_OWNERSHIP_CTRL",				0x027A8, 1},
	{"PCC_CFG",					0x027B0, 1},
	{"PCC_CONTROL",					0x027B8, 1},
	{"PDA_STATUS1",					0x027C0, 1},
	{"RTDMA_BW_TIMER",				0x027C8, 1},
	{"G3CMCT_INT_STATUS",				0x02900, 1},
	{"G3CMCT_INT_MASK",				0x02908, 1},
	{"G3CMCT_ERR_REG",				0x02910, 1},
	{"G3CMCT_ERR_MASK",				0x02918, 1},
	{"G3CMCT_ERR_ALARM",				0x02920, 1},
	{"G3CMCT_CONFIG%d",				0x02928, 3},
	{"G3CMCT_INIT%d",				0x02940, 6},
	{"G3CMCT_DLL_TRAINING1",			0x02970, 1},
	{"G3CMCT_DLL_TRAINING2",			0x02978, 1},
	{"G3CMCT_DLL_TRAINING3",			0x02980, 1},
	{"G3CMCT_DLL_TRAINING4",			0x02988, 1},
	{"G3CMCT_DLL_TRAINING6",			0x02990, 1},
	{"G3CMCT_DLL_TRAINING7",			0x02998, 1},
	{"G3CMCT_DLL_TRAINING8",			0x029A0, 1},
	{"G3CMCT_DLL_TRAINING9",			0x029A8, 1},
	{"G3CMCT_DLL_TRAINING5",			0x029B0, 1},
	{"G3CMCT_DLL_TRAINING10",			0x029B8, 1},
	{"G3CMCT_DLL_TRAINING11",			0x029C0, 1},
	{"G3CMCT_INIT6",				0x029C8, 1},
	{"G3CMCT_TEST0",				0x029D0, 1},
	{"G3CMCT_TEST01",				0x029D8, 1},
	{"G3CMCT_TEST1",				0x029E0, 1},
	{"G3CMCT_TEST2",				0x029E8, 1},
	{"G3CMCT_TEST11",				0x029F0, 1},
	{"G3CMCT_TEST21",				0x029F8, 1},
	{"G3CMCT_TEST3",				0x02A00, 1},
	{"G3CMCT_TEST4",				0x02A08, 1},
	{"G3CMCT_TEST31",				0x02A10, 1},
	{"G3CMCT_TEST41",				0x02A18, 1},
	{"G3CMCT_TEST5",				0x02A20, 1},
	{"G3CMCT_TEST6",				0x02A28, 1},
	{"G3CMCT_TEST51",				0x02A30, 1},
	{"G3CMCT_TEST61",				0x02A38, 1},
	{"G3CMCT_TEST7",				0x02A40, 1},
	{"G3CMCT_TEST71",				0x02A48, 1},
	{"G3CMCT_INIT41",				0x02A50, 1},
	{"G3CMCT_TEST8",				0x02A58, 1},
	{"G3CMCT_TEST9",				0x02A60, 1},
	{"G3CMCT_TEST10",				0x02A68, 1},
	{"G3CMCT_TEST101",				0x02A70, 1},
	{"G3CMCT_TEST12",				0x02A78, 1},
	{"G3CMCT_TEST13",				0x02A80, 1},
	{"G3CMCT_TEST14",				0x02A88, 1},
	{"G3CMCT_TEST15",				0x02A90, 1},
	{"G3CMCT_TEST16",				0x02A98, 1},
	{"G3CMCT_TEST17",				0x02AA0, 1},
	{"G3CMCT_TEST18",				0x02AA8, 1},
	{"G3CMCT_LOOP_BACK",				0x02AB0, 1},
	{"G3CMCT_LOOP_BACK1",				0x02AB8, 1},
	{"G3CMCT_LOOP_BACK2",				0x02AC0, 1},
	{"G3CMCT_LOOP_BACK3",				0x02AC8, 1},
	{"G3CMCT_LOOP_BACK4",				0x02AD0, 1},
	{"G3CMCT_LOOP_BACK5",				0x02AD8, 1},
	{"G3CMCT_LOOP_BACK_RDLL_%d",			0x02B00, 4},
	{"G3CMCT_LOOP_BACK_WDLL_%d",			0x02B20, 4},
	{"G3CMCT_TRAN_WRD_CNT",				0x02B40, 1},
	{"G3CMCT_TRAN_AP_CNT",				0x02B48, 1},
	{"G3CMCT_G3BIST",				0x02B50, 1},
	{"MC_INT_STATUS",				0x03000, 1},
	{"MC_INT_MASK",					0x03008, 1},
	{"MC_ERR_REG",					0x03010, 1},
	{"MC_ERR_MASK",					0x03018, 1},
	{"MC_ERR_ALARM",				0x03020, 1},
	{"GROCRC_ALARM_REG",				0x03028, 1},
	{"GROCRC_ALARM_MASK",				0x03030, 1},
	{"GROCRC_ALARM_ALARM",				0x03038, 1},
	{"RX_THRESH_CFG_REPL",				0x03100, 1},
	{"DBG_REG1_%d",					0x03108, 8},
	{"DBG_REG2",					0x03148, 1},
	{"DBG_REG3",					0x03150, 1},
	{"DBG_REG4",					0x03158, 1},
	{"DBG_REG5",					0x03160, 1},
	{"RX_QUEUE_CFG",				0x03200, 1},
	{"RX_QUEUE_SIZE_Q%d",				0x03208, 15},
	{"RX_QUEUE_SIZE_Q15",				0x03280, 0},
	{"RX_QUEUE_SIZE_Q16",				0x03288, 0},
	{"RX_QUEUE_SIZE_Q17",				0x03290, 0},
	{"RX_QUEUE_START_Q%d",				0x032A0, 18},
	{"FM_DEFINITION",				0x03330, 1},
	{"TRAFFIC_CTRL",				0x03380, 1},
	{"XFMD_ARB_CTRL",				0x03388, 1},
	{"XFMD_ARB_CTRL1",				0x03390, 1},
	{"RD_TRANC_CTRL",				0x03398, 1},
	{"FM_ARB",					0x033A0, 1},
	{"ARB",						0x033A8, 1},
	{"SETTINGS0",					0x033B0, 1},
	{"FBMC_ECC_CFG",				0x033B8, 1},
	{"PCIPIF_INT_STATUS",				0x03400, 1},
	{"PCIPIF_INT_MASK",				0x03408, 1},
	{"DBECC_ERR_REG",				0x03410, 1},
	{"DBECC_ERR_MASK",				0x03418, 1},
	{"DBECC_ERR_ALARM",				0x03420, 1},
	{"SBECC_ERR_REG",				0x03428, 1},
	{"SBECC_ERR_MASK",				0x03430, 1},
	{"SBECC_ERR_ALARM",				0x03438, 1},
	{"GENERAL_ERR_REG",				0x03440, 1},
	{"GENERAL_ERR_MASK",				0x03448, 1},
	{"GENERAL_ERR_ALARM",				0x03450, 1},
	{"SRPCIM_MSG_REG",				0x03458, 1},
	{"SRPCIM_MSG_MASK",				0x03460, 1},
	{"SRPCIM_MSG_ALARM",				0x03468, 1},
	{"GCMG1_INT_STATUS",				0x03600, 1},
	{"GCMG1_INT_MASK",				0x03608, 1},
	{"GSSCC_ERR_REG",				0x03610, 1},
	{"GSSCC_ERR_MASK",				0x03618, 1},
	{"GSSCC_ERR_ALARM",				0x03620, 1},
	{"GSSC_ERR0_REG_%d",				0x03628, 3},
	{"GSSC_ERR0_MASK_%d",				0x03630, 3},
	{"GSSC_ERR0_ALARM_%d",				0x03638, 3},
	{"GSSC_ERR1_REG_%d",				0x03670, 3},
	{"GSSC_ERR1_MASK_%d",				0x03678, 3},
	{"GSSC_ERR1_ALARM_%d",				0x03680, 3},
	{"GQCC_ERR_REG",				0x036B8, 1},
	{"GQCC_ERR_MASK",				0x036C0, 1},
	{"GQCC_ERR_ALARM",				0x036C8, 1},
	{"UQM_ERR_REG",					0x036D0, 1},
	{"UQM_ERR_MASK",				0x036D8, 1},
	{"UQM_ERR_ALARM",				0x036E0, 1},
	{"SSCC_CONFIG",					0x036E8, 1},
	{"SSCC_MASK_%d",				0x036F0, 6},
	{"GCMG1_ECC",					0x03720, 1},
	{"PCMG1_INT_STATUS",				0x03A00, 1},
	{"PCMG1_INT_MASK",				0x03A08, 1},
	{"PSSCC_ERR_REG",				0x03A10, 1},
	{"PSSCC_ERR_MASK",				0x03A18, 1},
	{"PSSCC_ERR_ALARM",				0x03A20, 1},
	{"PQCC_ERR_REG",				0x03A28, 1},
	{"PQCC_ERR_MASK",				0x03A30, 1},
	{"PQCC_ERR_ALARM",				0x03A38, 1},
	{"PQCC_CQM_ERR_REG",				0x03A40, 1},
	{"PQCC_CQM_ERR_MASK",				0x03A48, 1},
	{"PQCC_CQM_ERR_ALARM",				0x03A50, 1},
	{"PQCC_SQM_ERR_REG",				0x03A58, 1},
	{"PQCC_SQM_ERR_MASK",				0x03A60, 1},
	{"PQCC_SQM_ERR_ALARM",				0x03A68, 1},
	{"QCC_SRQ_CQRQ",				0x03A70, 1},
	{"QCC_ERR_POLICY",				0x03A78, 1},
	{"QCC_BP_CTRL",					0x03A80, 1},
	{"PCMG1_ECC",					0x03A88, 1},
	{"QCC_CQM_CQRQ_ID",				0x03A90, 1},
	{"QCC_SQM_SRQ_ID",				0x03A98, 1},
	{"QCC_CQM_FLM_ID",				0x03AA0, 1},
	{"QCC_SQM_FLM_ID",				0x03AA8, 1},
	{"ONE_INT_STATUS",				0x04000, 1},
	{"ONE_INT_MASK",				0x04008, 1},
	{"RPE_ERR_REG",					0x04010, 1},
	{"RPE_ERR_MASK",				0x04018, 1},
	{"RPE_ERR_ALARM",				0x04020, 1},
	{"PE_ERR_REG",					0x04028, 1},
	{"PE_ERR_MASK",					0x04030, 1},
	{"PE_ERR_ALARM",				0x04038, 1},
	{"RXPE_ERR_REG",				0x04040, 1},
	{"RXPE_ERR_MASK",				0x04048, 1},
	{"RXPE_ERR_ALARM",				0x04050, 1},
	{"DLM_ERR_REG",					0x04058, 1},
	{"DLM_ERR_MASK",				0x04060, 1},
	{"DLM_ERR_ALARM",				0x04068, 1},
	{"OES_ERR_REG",					0x04070, 1},
	{"OES_ERR_MASK",				0x04078, 1},
	{"OES_ERR_ALARM",				0x04080, 1},
	{"TXPE_ERR_REG",				0x04088, 1},
	{"TXPE_ERR_MASK",				0x04090, 1},
	{"TXPE_ERR_ALARM",				0x04098, 1},
	{"TXPE_BCC_MEM_SG_ECC_ERR_REG",			0x040A0, 1},
	{"TXPE_BCC_MEM_SG_ECC_ERR_MASK",		0x040A8, 1},
	{"TXPE_BCC_MEM_SG_ECC_ERR_ALARM",		0x040B0, 1},
	{"TXPE_BCC_MEM_DB_ECC_ERR_REG",			0x040B8, 1},
	{"TXPE_BCC_MEM_DB_ECC_ERR_MASK",		0x040C0, 1},
	{"TXPE_BCC_MEM_DB_ECC_ERR_ALARM",		0x040C8, 1},
	{"RPE_FSM_ERR_REG",				0x040D0, 1},
	{"RPE_FSM_ERR_MASK",				0x040D8, 1},
	{"RPE_FSM_ERR_ALARM",				0x040E0, 1},
	{"ONE_CFG",					0x04100, 1},
	{"SGRP_ALLOC_%d",				0x04108, 17},
	{"SGRP_IWARP_LRO_ALLOC",			0x04190, 1},
	{"RPE_CFG0",					0x04198, 1},
	{"RPE_CFG1",					0x041A0, 1},
	{"RPE_CFG2",					0x041A8, 1},
	{"RPE_CFG5",					0x041C0, 1},
	{"WQEOWN%d",					0x041C8, 2},
	{"RPE_WQEOWN2",					0x041D8, 1},
	{"PE_CTXT",					0x04200, 1},
	{"PE_CFG",					0x04208, 1},
	{"PE_STATS_CMD",				0x04210, 1},
	{"PE_STATS_DATA",				0x04218, 1},
	{"RXPE_FP_MASK",				0x04220, 1},
	{"RXPE_CFG",					0x04228, 1},
	{"PE_XT_CTRL%d",				0x04230, 4},
	{"PET_IWARP_COUNTERS",				0x04250, 1},
	{"PET_IWARP_SLOW_COUNTER",			0x04258, 1},
	{"PET_IWARP_TIMERS",				0x04260, 1},
	{"PET_LRO_CFG",					0x04268, 1},
	{"PET_LRO_COUNTERS",				0x04270, 1},
	{"PET_TIMER_BP_CTRL",				0x04278, 1},
	{"PE_VP_ACK_%d",				0x04280, 17},
	{"PE_VP%d",					0x04308, 17},
	{"DLM_CFG",					0x04390, 1},
	{"TXPE_TOWI_CFG",				0x04400, 1},
	{"TXPE_PMON",					0x04410, 1},
	{"TXPE_PMON_DOWNCOUNT",				0x04418, 1},
	{"TXPE_PMON_EVENT",				0x04420, 1},
	{" TXPE_PMON_OTHER",				0x04428, 1},
	{"OES_INEVT",					0x04500, 1},
	{"OES_INBKBKEVT",				0x04508, 1},
	{"OES_INEVT_WRR%d",				0x04510, 2},
	{"OES_PENDEVT",					0x04520, 1},
	{"OES_PENDBKBKEVT",				0x04528, 1},
	{"OES_PENDEVT_WRR%d",				0x04530, 2},
	{"OES_PEND_QUEUE",				0x04540, 1},
	{"ROCRC_BYPQ%d_STAT_WATERMARK",			0x04800, 3},
	{"NOA_WCT_CTRL",				0x04818, 1},
	{"RC_CFG2",					0x04820, 1},
	{"RC_CFG3",					0x04828, 1},
	{"RX_MULTI_CAST_CTRL1",				0x04830, 1},
	{"RXDM_DBG_RD",					0x04838, 1},
	{"RXDM_DBG_RD_DATA",				0x04840, 1},
	{"RQA_TOP_PRTY_FOR_VH%d",			0x04848, 17},
	{"TIM_STATUS",					0x04900, 1},
	{"TIM_ECC_ENABLE",				0x04908, 1},
	{"TIM_BP_CTRL",					0x04910, 1},
	{"TIM_RESOURCE_ASSIGNMENT_VH%d",		0x04918, 17},
	{"TIM_BMAP_MAPPING_VP_ERR%d",			0x049A0, 17},
	{"GCMG2_INT_STATUS",				0x04B00, 1},
	{"GCMG2_INT_MASK",				0x04B08, 1},
	{"GXTMC_ERR_REG",				0x04B10, 1},
	{"GXTMC_ERR_MASK",				0x04B18, 1},
	{"GXTMC_ERR_ALARM",				0x04B20, 1},
	{"CMC_ERR_REG",					0x04B28, 1},
	{"CMC_ERR_MASK",				0x04B30, 1},
	{"CMC_ERR_ALARM",				0x04B38, 1},
	{"GCP_ERR_REG",					0x04B40, 1},
	{"GCP_ERR_MASK",				0x04B48, 1},
	{"GCP_ERR_ALARM",				0x04B50, 1},
	{"CMC_L2_CLIENT_UQM_1",				0x04B58, 1},
	{"CMC_L2_CLIENT_SSC_L",				0x04B60, 1},
	{"CMC_L2_CLIENT_QCC_SQM_0",			0x04B68, 1},
	{"CMC_L2_CLIENT_DAM_0",				0x04B70, 1},
	{"CMC_L2_CLIENT_H2L_0",				0x04B78, 1},
	{"CMC_L2_CLIENT_STC_0",				0x04B80, 1},
	{"CMC_L2_CLIENT_XTMC_0",			0x04B88, 1},
	{"CMC_WRR_L2_CALENDAR_%d",			0x04B90, 4},
	{"CMC_L3_CLIENT_QCC_SQM_1",			0x04BB0, 1},
	{"CMC_L3_CLIENT_QCC_CQM",			0x04BB8, 1},
	{"CMC_L3_CLIENT_DAM_1",				0x04BC0, 1},
	{"CMC_L3_CLIENT_H2L_1",				0x04BC8, 1},
	{"CMC_L3_CLIENT_STC_1",				0x04BD0, 1},
	{"CMC_L3_CLIENT_XTMC_1",			0x04BD8, 1},
	{"CMC_WRR_L3_CALENDAR_%d",			0x04BE0, 3},
	{"CMC_USER_DOORBELL_PARTITION",			0x04BF8, 1},
	{"CMC_HIT_RECORD_PARTITION_%d",			0x04C00, 8},
	{"CMC_C_SCR_RECORD_PARTITION_%d",		0x04C40, 8},
	{"CMC_WQE_OD_GROUP_RECORD_PARTITION",		0x04C80, 1},
	{"CMC_ACK_RECORD_PARTITION",			0x04C88, 1},
	{"CMC_LIRR_RECORD_PARTITION",			0x04C90, 1},
	{"CMC_RIRR_RECORD_PARTITION",			0x04C98, 1},
	{"CMC_TCE_RECORD_PARTITION",			0x04CA0, 1},
	{"CMC_HOQ_RECORD_PARTITION",			0x04CA8, 1},
	{"CMC_STAG_VP_RECORD_PARTITION_%d",		0x04CB0, 17},
	{"CMC_R_SCR_RECORD_PARTITION",			0x04D38, 1},
	{"CMC_CQRQ_CONTEXT_RECORD_PARTITION",		0x04D40, 1},
	{"CMC_CQE_GROUP_RECORD_PARTITION",		0x04D48, 1},
	{"CMC_P_SCR_RECORD_PARTITION",			0x04D50, 1},
	{"CMC_NCE_CONTEXT_RECORD_PARTITION",		0x04D58, 1},
	{"CMC_BYPASS_QUEUE_PARTITION",			0x04D60, 1},
	{"CMC_H_SCR_RECORD_PARTITION",			0x04D68, 1},
	{"CMC_PBL_RECORD_PARTITION",			0x04D70, 1},
	{"CMC_LIT_RECORD_PARTITION",			0x04D78, 1},
	{"CMC_SRQ_CONTEXT_RECORD_PARTITION",		0x04D80, 1},
	{"CMC_P_SCR_RECORD",				0x04D88, 1},
	{"CMC_DEVICE_SELECT",				0x04D90, 1},
	{"G3IF_FIFO_DST_ECC",				0x04D98, 1},
	{"GXTMC_CFG",					0x04DA0, 1},
	{"PCMG2_INT_STATUS",				0x04F00, 1},
	{"PCMG2_INT_MASK",				0x04F08, 1},
	{"PXTMC_ERR_REG",				0x04F10, 1},
	{"PXTMC_ERR_MASK",				0x04F18, 1},
	{"PXTMC_ERR_ALARM",				0x04F20, 1},
	{"CP_ERR_REG",					0x04F28, 1},
	{"CP_ERR_MASK",					0x04F30, 1},
	{"CP_ERR_ALARM",				0x04F38, 1},
	{"CP_XT_CTRL1",					0x04F40, 1},
	{"CP_GEN_CFG",					0x04F48, 1},
	{"CP_EXC_REG",					0x04F50, 1},
	{"CP_EXC_MASK",					0x04F58, 1},
	{"CP_EXC_ALARM",				0x04F60, 1},
	{"CP_EXC_CAUSE",				0x04F68, 1},
	{"XTMC_IMG_CTRL%d",				0x04FE8, 5},
	{"PXTMC_CFG0%d",				0x05010, 2},
	{"XTMC_MEM_CFG",				0x05020, 1},
	{"XTMC_MEM_BYPASS_CFG",				0x05028, 1},
	{"XTMC_CXP_REGION0",				0x05030, 1},
	{"XTMC_MXP_REGION0",				0x05038, 1},
	{"XTMC_UXP_REGION0",				0x05040, 1},
	{"XTMC_CXP_REGION1",				0x05048, 1},
	{"XTMC_MXP_REGION1",				0x05050, 1},
	{"XTMC_UXP_REGION1",				0x05058, 1},
	{"XTMC_CXP_REGION2",				0x05060, 1},
	{"XTMC_MXP_REGION2",				0x05068, 1},
	{"XTMC_UXP_REGION2",				0x05070, 1},
	{"MSG_INT_STATUS",				0x05200, 1},
	{"MSG_INT_MASK",				0x05208, 1},
	{"TIM_ERR_REG",					0x05210, 1},
	{"TIM_ERR_MASK",				0x05218, 1},
	{"TIM_ERR_ALARM",				0x05220, 1},
	{"MSG_ERR_REG",					0x05228, 1},
	{"MSG_ERR_MASK",				0x05230, 1},
	{"MSG_ERR_ALARM",				0x05238, 1},
	{"MSG_XT_CTRL",					0x05240, 1},
	{"MSG_DISPATCH",				0x052A8, 1},
	{"MSG_EXC_REG",					0x05340, 1},
	{"MSG_EXC_MASK",				0x05348, 1},
	{"MSG_EXC_ALARM",				0x05350, 1},
	{"MSG_EXC_CAUSE",				0x05358, 1},
	{"MSG_DIRECT_PIC",				0x05368, 1},
	{"UMQ_IR_TEST_VPA",				0x05370, 1},
	{"UMQ_IR_TEST_BYTE",				0x05378, 1},
	{"MSG_ERR2_REG",				0x05380, 1},
	{"MSG_ERR2_MASK",				0x05388, 1},
	{"MSG_ERR2_ALARM",				0x05390, 1},
	{"MSG_ERR3_REG",				0x05398, 1},
	{"MSG_ERR3_MASK",				0x053A0, 1},
	{"MSG_ERR3_ALARM",				0x053A8, 1},
	{"UMQ_IR_TEST_BYTE_NOTIFY",			0x053B0, 1},
	{"MSG_BP_CTRL",					0x053B8, 1},
	{"UMQ_BWR_PFCH_INIT_%d",			0x053C0, 17},
	{"UMQ_BWR_PFCH_INIT_NOTIFY_%d",			0x05448, 17},
	{"UMQ_BWR_EOL",					0x054D0, 1},
	{"UMQ_BWR_EOL_LATENCY_NOTIFY",			0x054D8, 1},
	{"FAU_GEN_ERR_REG",				0x05600, 1},
	{"FAU_GEN_ERR_MASK",				0x05608, 1},
	{"FAU_GEN_ERR_ALARM",				0x05610, 1},
	{"FAU_ECC_ERR_REG",				0x05618, 1},
	{"FAU_ECC_ERR_MASK",				0x05620, 1},
	{"FAU_ECC_ERR_ALARM",				0x05628, 1},
	{"FAU_GLOBAL_CFG",				0x05648, 1},
	{"RX_DATAPATH_UTIL",				0x05650, 1},
	{"FAU_PA_CFG",					0x05658, 1},
	{"DBG_STATS_FAU_RX_PATH",			0x05668, 1},
	{"FAU_AUTO_LRO_CONTROL",			0x05670, 1},
	{"FAU_AUTO_LRO_DATA_%d",			0x05678, 5},
	{"FAU_LAG_CFG",					0x056C0, 1},
	{"FAU_MPA_CFG",					0x05700, 1},
	{"XMAC_RX_XGMII_CAPTURE_DATA_PORT%d",		0x057A0, 3},
	{"TPA_INT_STATUS",				0x05800, 1},
	{"TPA_INT_MASK",				0x05808, 1},
	{"ORP_ERR_REG",					0x05810, 1},
	{"ORP_ERR_MASK",				0x05818, 1},
	{"ORP_ERR_ALARM",				0x05820, 1},
	{"PTM_ALARM_REG",				0x05828, 1},
	{"PTM_ALARM_MASK",				0x05830, 1},
	{"PTM_ALARM_ALARM",				0x05838, 1},
	{"TPA_ERROR_REG",				0x05840, 1},
	{"TPA_ERROR_MASK",				0x05848, 1},
	{"TPA_ERROR_ALARM",				0x05850, 1},
	{"TPA_GLOBAL_CFG",				0x05858, 1},
	{"TX_DATAPATH_UTIL",				0x05860, 1},
	{"ORP_CFG",					0x05868, 1},
	{"PTM_ECC_CFG",					0x05870, 1},
	{"PTM_PHASE_CFG",				0x05878, 1},
	{"ORP_LRO_EVENTS",				0x05880, 1},
	{"ORP_BS_EVENTS",				0x05888, 1},
	{"ORP_IWARP_EVENTS",				0x05890, 1},
	{"DBG_STATS_TPA_TX_PATH",			0x05898, 1},
	{"TMAC_INT_STATUS",				0x05900, 1},
	{"TMAC_INT_MASK",				0x05908, 1},
	{"TXMAC_GEN_ERR_REG",				0x05910, 1},
	{"TXMAC_GEN_ERR_MASK",				0x05918, 1},
	{"TXMAC_GEN_ERR_ALARM",				0x05920, 1},
	{"TXMAC_ECC_ERR_REG",				0x05928, 1},
	{"TXMAC_ECC_ERR_MASK",				0x05930, 1},
	{"TXMAC_ECC_ERR_ALARM",				0x05938, 1},
	{"TXMAC_GEN_CFG1",				0x05948, 1},
	{"TXMAC_ERR_INJECT_CFG",			0x05958, 1},
	{"TXMAC_FRMGEN_CFG",				0x05960, 1},
	{"TXMAC_FRMGEN_CONTENTS",			0x05968, 1},
	{"TXMAC_FRMGEN_DATA",				0x05970, 1},
	{"DBG_STAT_TX_ANY_FRMS",			0x05978, 1},
	{"TXMAC_LINK_UTIL_PORT%d",			0x059A0, 3},
	{"TXMAC_CFG0_PORT%d",				0x059B8, 3},
	{"TXMAC_CFG1_PORT%d",				0x059D0, 3},
	{"TXMAC_STATUS_PORT%d",				0x059E8, 3},
	{"LAG_DISTRIB_DEST",				0x05A20, 1},
	{"LAG_MARKER_CFG",				0x05A28, 1},
	{"LAG_TX_CFG",					0x05A30, 1},
	{"LAG_TX_STATUS",				0x05A38, 1},
	{"TXMAC_STATS_TX_XGMII_CHAR",			0x05A50, 1},
	{"TXMAC_STATS_TX_XGMII_COLUMN1",		0x05A58, 1},
	{"TXMAC_STATS_TX_XGMII_COLUMN2",		0x05A60, 1},
	{"TXMAC_STATS_TX_XGMII_BEHAV_COLUMN2",		0x05A68, 1},
	{"SHAREDIO_STATUS",				0x05B00, 1},
	{"CRDT_STATUS1_VPLANE%d",			0x05B08, 17},
	{"CRDT_STATUS2_VPLANE%d",			0x05B90, 17},
	{"CRDT_STATUS3_VPLANE%d",			0x05C18, 17},
	{"CRDT_STATUS4_VPLANE%d",			0x05CA0, 17},
	{"CRDT_STATUS5",				0x05D28, 1},
	{"CRDT_STATUS6",				0x05D30, 1},
	{"CRDT_STATUS7",				0x05D38, 1},
	{"CRDT_STATUS8",				0x05D40, 1},
	{"SRPCIM_TO_MRPCIM_VPLANE_RMSG_%d",		0x05D48, 17},
	{"PCIE_LANE_CFG1",				0x06000, 1},
	{"PCIE_LANE_CFG2",				0x06008, 1},
	{"PCICFG_NO_TO_FUNC_CFG_%d",			0x06010, 25},
	{"RESOURCE_TO_VPLANE_CFG_%d",			0x060D8, 17},
	{"PCICFG_NO_TO_VPLANE_CFG_%d",			0x06160, 25},
	{"GENERAL_CFG",					0x06228, 1},
	{"START_BIST",					0x06230, 1},
	{"BIST_CFG",					0x06238, 1},
	{"PCI_LINK_CONTROL",				0x06240, 1},
	{"SHOW_SRIOV_CAP",				0x06248, 1},
	{"LINK_RST_WAIT_CNT",				0x06250, 1},
	{"PCIE_BASED_CRDT_CFG1",			0x06258, 1},
	{"PCIE_BASED_CRDT_CFG2",			0x06260, 1},
	{"SHAREDIO_ABS_BASED_CRDT_CFG1_VPLANE%d",	0x06268, 17},
	{"SHAREDIO_ABS_BASED_CRDT_CFG2_VPLANE%d",	0x062F0, 17},
	{"ARBITER_CFG",					0x06378, 1},
	{"SERDES_CFG1",					0x06380, 1},
	{"SERDES_CFG2",					0x06388, 1},
	{"SERDES_CFG3",					0x06390, 1},
	{"VHLABEL_TO_VPLANE_CFG_%d",			0x06398, 17},
	{"MRPCIM_TO_SRPCIM_VPLANE_WMSG_%d",		0x06420, 17},
	{"MRPCIM_TO_SRPCIM_VPLANE_WMSG_TRIG_%d",	0x064A8, 17},
	{"DEBUG_STATS%d",				0x06530, 3},
	{"DEBUG_STATS3_VPLANE%d",			0x06548, 17},
	{"DEBUG_STATS4_VPLANE%d",			0x065D0, 17},
	{"RC_RXDMEM_END_OFST_%d",			0x06B00, 16},
	{"MRPCIM_GENERAL_INT_STATUS",			0x07000, 1},
	{"MRPCIM_GENERAL_INT_MASK",			0x07008, 1},
	{"MRPCIM_PPIF_INT_STATUS",			0x07010, 1},
	{"MRPCIM_PPIF_INT_MASK",			0x07018, 1},
	{"INI_ERRORS_REG",				0x07028, 1},
	{"INI_ERRORS_MASK",				0x07030, 1},
	{"INI_ERRORS_ALARM",				0x07038, 1},
	{"DMA_ERRORS_REG",				0x07040, 1},
	{"DMA_ERRORS_MASK",				0x07048, 1},
	{"DMA_ERRORS_ALARM",				0x07050, 1},
	{"TGT_ERRORS_REG",				0x07058, 1},
	{"TGT_ERRORS_MASK",				0x07060, 1},
	{"TGT_ERRORS_ALARM",				0x07068, 1},
	{"CONFIG_ERRORS_REG",				0x07070, 1},
	{"CONFIG_ERRORS_MASK",				0x07078, 1},
	{"CONFIG_ERRORS_ALARM",				0x07080, 1},
	{"CRDT_ERRORS_REG",				0x07090, 1},
	{"CRDT_ERRORS_MASK",				0x07098, 1},
	{"CRDT_ERRORS_ALARM",				0x070A0, 1},
	{"MRPCIM_GENERAL_ERRORS_REG",			0x070B0, 1},
	{"MRPCIM_GENERAL_ERRORS_MASK",			0x070B8, 1},
	{"MRPCIM_GENERAL_ERRORS_ALARM",			0x070C0, 1},
	{"PLL_ERRORS_REG",				0x070D0, 1},
	{"PLL_ERRORS_MASK",				0x070D8, 1},
	{"PLL_ERRORS_ALARM",				0x070E0, 1},
	{"SRPCIM_TO_MRPCIM_ALARM_REG",			0x070E8, 1},
	{"SRPCIM_TO_MRPCIM_ALARM_MASK",			0x070F0, 1},
	{"SRPCIM_TO_MRPCIM_ALARM_ALARM",		0x070F8, 1},
	{"VPATH_TO_MRPCIM_ALARM_REG",			0x07100, 1},
	{"VPATH_TO_MRPCIM_ALARM_MASK",			0x07108, 1},
	{"VPATH_TO_MRPCIM_ALARM_ALARM",			0x07110, 1},
	{"CRDT_ERRORS_VPLANE_REG_%d",			0x07128, 17},
	{"CRDT_ERRORS_VPLANE_MASK_%d",			0x07130, 17},
	{"CRDT_ERRORS_VPLANE_ALARM_%d",			0x07138, 17},
	{"MRPCIM_RST_IN_PROG",				0x072F0, 1},
	{"MRPCIM_REG_MODIFIED",				0x072F8, 1},
	{"SPLIT_TABLE_STATUS1",				0x07300, 1},
	{"SPLIT_TABLE_STATUS2",				0x07308, 1},
	{"SPLIT_TABLE_STATUS3",				0x07310, 1},
	{"MRPCIM_GENERAL_STATUS1",			0x07318, 1},
	{"MRPCIM_GENERAL_STATUS2",			0x07320, 1},
	{"MRPCIM_GENERAL_STATUS3",			0x07328, 1},
	{"TEST_STATUS",					0x07338, 1},
	{"KDFCCTL_DBG_STATUS",				0x07348, 1},
	{"MSIX_ADDR",					0x07350, 1},
	{"MSIX_TABLE",					0x07358, 1},
	{"MSIX_CTL",					0x07360, 1},
	{"MSIX_ACCESS_TABLE",				0x07368, 1},
	{"WRITE_ARB_PENDING",				0x07378, 1},
	{"READ_ARB_PENDING",				0x07380, 1},
	{"DMAIF_DMADBL_PENDING",			0x07388, 1},
	{"WRCRDTARB_STATUS0_VPLANE%d",			0x07390, 17},
	{"WRCRDTARB_STATUS1_VPLANE%d",			0x07418, 17},
	{"MRPCIM_GENERAL_CFG1",				0x07500, 1},
	{"MRPCIM_GENERAL_CFG2",				0x07508, 1},
	{"MRPCIM_GENERAL_CFG3",				0x07510, 1},
	{"MRPCIM_STATS_START_HOST_ADDR",		0x07518, 1},
	{"ASIC_MODE",					0x07520, 1},
	{"DIS_FW_PIPELINE_WR",				0x07528, 1},
	{"INI_TIMEOUT_VAL",				0x07530, 1},
	{"PIC_ARBITER_CFG",				0x07538, 1},
	{"READ_ARBITER",				0x07540, 1},
	{"WRITE_ARBITER",				0x07548, 1},
	{"ADAPTER_CONTROL",				0x07550, 1},
	{"PROGRAM_CFG0",				0x07558, 1},
	{"PROGRAM_CFG1",				0x07560, 1},
	{"DBLGEN_WRR_CFG%d",				0x07568, 21},
	{"DEBUG_CFG1",					0x07608, 1},
	{"TEST_CFG1%d",					0x07900, 3},
	{"WRCRDTARB_CFG%d",				0x07918, 3},
	{"TEST_WRCRDTARB_CFG%d",			0x07930, 4},
	{"RDCRDTARB_CFG%d",				0x07950, 3},
	{"TEST_RDCRDTARB_CFG%d",			0x07968, 4},
	{"PIC_DEBUG_CONTROL",				0x07988, 1},
	{"SPI_CONTROL_3_REG",				0x079D8, 1},
	{"CLOCK_CFG0",					0x079E0, 1},
	{"STATS_BP_CTRL",				0x079E8, 1},
	{"KDFCDMA_BP_CTRL",				0x079F0, 1},
	{"INTCTL_BP_CTRL",				0x079F8, 1},
	{"VECTOR_SRPCIM_ALARM_MAP_%d",			0x07A00, 9},
	{"VPLANE_RDCRDTARB_CFG0_%d",			0x07B10, 17},
	{"MRPCIM_SPI_CONTROL",				0x07BA0, 1},
	{"MRPCIM_SPI_DATA",				0x07BA8, 1},
	{"MRPCIM_SPI_WRITE_PROTECT",			0x07BB0, 1},
	{"CHIP_FULL_RESET",				0x07BE0, 1},
	{"BF_SW_RESET",					0x07BE8, 1},
	{"SW_RESET_STATUS",				0x07BF0, 1},
	{"RIC_TIMEOUT",					0x07C28, 1},
	{"MRPCIM_PCI_CONFIG_ACCESS_CFG1",		0x07C30, 1},
	{"MRPCIM_PCI_CONFIG_ACCESS_CFG2",		0x07C38, 1},
	{"MRPCIM_PCI_CONFIG_ACCESS_STATUS",		0x07C40, 1},
	{"RDCRDTARB_STATUS0_VPLANE%d",			0x07CA8, 17},
	{"MRPCIM_DEBUG_STATS0",				0x07D30, 1},
	{"MRPCIM_DEBUG_STATS1_VPLANE%d",		0x07D38, 17},
	{"MRPCIM_DEBUG_STATS2_VPLANE%d",		0x07DC0, 17},
	{"MRPCIM_DEBUG_STATS3_VPLANE%d",		0x07E48, 17},
	{"MRPCIM_DEBUG_STATS4",				0x07ED0, 1},
	{"GENSTATS_COUNT01",				0x07ED8, 1},
	{"GENSTATS_COUNT23",				0x07EE0, 1},
	{"GENSTATS_COUNT4",				0x07EE8, 1},
	{"GENSTATS_COUNT5",				0x07EF0, 1},
	{"MRPCIM_MMIO_CFG1",				0x07EF8, 1},
	{"MRPCIM_MMIO_CFG2",				0x07F00, 1},
	{"GENSTATS_CFG_%d",				0x07F08, 6},
	{"GENSTAT_64BIT_CFG",				0x07F38, 1},
	{"PLL_SLIP_COUNTERS",				0x07F40, 1},
	{"GCMG3_INT_STATUS",				0x08000, 1},
	{"GCMG3_INT_MASK",				0x08008, 1},
	{"GSTC_ERR0_REG",				0x08010, 1},
	{"GSTC_ERR0_MASK",				0x08018, 1},
	{"GSTC_ERR0_ALARM",				0x08020, 1},
	{"GSTC_ERR1_REG",				0x08028, 1},
	{"GSTC_ERR1_MASK",				0x08030, 1},
	{"GSTC_ERR1_ALARM",				0x08038, 1},
	{"GH2L_ERR0_REG",				0x08040, 1},
	{"GH2L_ERR0_MASK",				0x08048, 1},
	{"GH2L_ERR0_ALARM",				0x08050, 1},
	{"GHSQ_ERR_REG",				0x08058, 1},
	{"GHSQ_ERR_MASK",				0x08060, 1},
	{"GHSQ_ERR_ALARM",				0x08068, 1},
	{"GHSQ_ERR2_REG",				0x08070, 1},
	{"GHSQ_ERR2_MASK",				0x08078, 1},
	{"GHSQ_ERR2_ALARM",				0x08080, 1},
	{"GHSQ_ERR3_REG",				0x08088, 1},
	{"GHSQ_ERR3_MASK",				0x08090, 1},
	{"GHSQ_ERR3_ALARM",				0x08098, 1},
	{"GH2L_SMERR0_REG",				0x080A0, 1},
	{"GH2L_SMERR0_MASK",				0x080A8, 1},
	{"GH2L_SMERR0_ALARM",				0x080B0, 1},
	{"HCC_ALARM_REG",				0x080B8, 1},
	{"HCC_ALARM_MASK",				0x080C0, 1},
	{"HCC_ALARM_ALARM",				0x080C8, 1},
	{"GSTC_CFG%d",					0x080D0, 3},
	{"STC_ARB_CFG%d",				0x080E8, 4},
	{"STC_JHASH_CFG",				0x08108, 1},
	{"STC_SMI_ARB_CFG%d",				0x08110, 2},
	{"STC_CAA_ARB_CFG0%d",				0x08120, 2},
	{"STC_ECI_ARB_CFG0%d",				0x08130, 2},
	{"STC_ECI_CFG0",				0x08140, 1},
	{"STC_PRM_CFG0",				0x08148, 1},
	{"H2L_MISC_CFG",				0x08150, 1},
	{"HSQ_CFG_%d",					0x08158, 17},
	{"USDC_VPBP_CFG",				0x081E0, 1},
	{"KDFC_VPBP_CFG",				0x081E8, 1},
	{"TXPE_VPBP_CFG",				0x081F0, 1},
	{"ONE_VPBP_CFG",				0x081F8, 1},
	{"HOPARB_WRR_CTRL_%d",				0x08200, 20},
	{"HOPARB_WRR_CMP_%d",				0x082A0, 3},
	{"HOP_BCK_STATS0",				0x082E8, 1},
	{"PCMG3_INT_STATUS",				0x08400, 1},
	{"PCMG3_INT_MASK",				0x08408, 1},
	{"DAM_ERR_REG",					0x08410, 1},
	{"DAM_ERR_MASK",				0x08418, 1},
	{"DAM_ERR_ALARM",				0x08420, 1},
	{"PSTC_ERR_REG",				0x08428, 1},
	{"PSTC_ERR_MASK",				0x08430, 1},
	{"PSTC_ERR_ALARM",				0x08438, 1},
	{"PH2L_ERR0_REG",				0x08440, 1},
	{"PH2L_ERR0_MASK",				0x08448, 1},
	{"PH2L_ERR0_ALARM",				0x08450, 1},
	{"DAM_BYPASS_QUEUE_%d",				0x08458, 3},
	{"DAM_ECC_CTRL",				0x08470, 1},
	{"PH2L_CFG0",					0x08478, 1},
	{"PSTC_CFG0",					0x08480, 1},
	{"NETERION_MEMBIST_CONTROL",			0x08510, 1},
	{"NETERION_MEMBIST_ERRORS",			0x08518, 1},
	{"RR_CQM_CACHE_RTL_TOP_0",			0x08520, 1},
	{"RR_CQM_CACHE_RTL_TOP_1",			0x08528, 1},
	{"RR_SQM_CACHE_RTL_TOP_0",			0x08530, 1},
	{"RR_SQM_CACHE_RTL_TOP_1",			0x08538, 1},
	{"RF_SQM_LPRPEDAT_RTL_TOP_0",			0x08540, 1},
	{"RF_SQM_LPRPEDAT_RTL_TOP_1",			0x08548, 1},
	{"RR_SQM_DMAWQERSP_RTL_TOP_0",			0x08550, 1},
	{"RR_SQM_DMAWQERSP_RTL_TOP_1",			0x08558, 1},
	{"RF_CQM_DMACQERSP_RTL_TOP",			0x08560, 1},
	{"RF_SQM_RPEREQDAT_RTL_TOP_0",			0x08568, 1},
	{"RF_SQM_RPEREQDAT_RTL_TOP_1",			0x08570, 1},
	{"RF_SSCC_SSR_RTL_TOP_0_0",			0x08578, 1},
	{"RF_SSCC_SSR_RTL_TOP_1_0",			0x08580, 1},
	{"RF_SSCC_SSR_RTL_TOP_0_1",			0x08588, 1},
	{"RF_SSCC_SSR_RTL_TOP_1_1",			0x08590, 1},
	{"RF_SSC_CM_RESP_RTL_TOP_1_SSC0",		0x08598, 1},
	{"RF_SSC_CM_RESP_RTL_TOP_0_SSC1",		0x085A0, 1},
	{"RF_SSC_CM_RESP_RTL_TOP_1_SSCL",		0x085A8, 1},
	{"RF_SSC_CM_RESP_RTL_TOP_0_SSC0",		0x085B0, 1},
	{"RF_SSC_CM_RESP_RTL_TOP_1_SSC1",		0x085B8, 1},
	{"RF_SSC_CM_RESP_RTL_TOP_0_SSCL",		0x085C0, 1},
	{"RF_SSC_SSR_RESP_RTL_TOP_SSC0",		0x085C8, 1},
	{"RF_SSC_SSR_RESP_RTL_TOP_SSC1",		0x085D0, 1},
	{"RF_SSC_SSR_RESP_RTL_TOP_SSCL",		0x085D8, 1},
	{"RF_SSC_TSR_RESP_RTL_TOP_1_SSC0",		0x085E0, 1},
	{"RF_SSC_TSR_RESP_RTL_TOP_2_SSC0",		0x085E8, 1},
	{"RF_SSC_TSR_RESP_RTL_TOP_2_SSC1",		0x085F0, 1},
	{"RF_SSC_TSR_RESP_RTL_TOP_0_SSCL",		0x085F8, 1},
	{"RF_SSC_TSR_RESP_RTL_TOP_0_SSC0",		0x08600, 1},
	{"RF_SSC_TSR_RESP_RTL_TOP_0_SSC1",		0x08608, 1},
	{" RF_SSC_TSR_RESP_RTL_TOP_1_SSC1",		0x08610, 1},
	{"RF_SSC_TSR_RESP_RTL_TOP_1_SSCL",		0x08618, 1},
	{"RF_SSC_TSR_RESP_RTL_TOP_2_SSCL",		0x08620, 1},
	{"RF_SSC_STATE_RTL_TOP_1_SSC0",			0x08628, 1},
	{"RF_SSC_STATE_RTL_TOP_2_SSC0",			0x08630, 1},
	{"RF_SSC_STATE_RTL_TOP_1_SSC1",			0x08638, 1},
	{"RF_SSC_STATE_RTL_TOP_2_SSC1",			0x08640, 1},
	{"RF_SSC_STATE_RTL_TOP_1_SSCL",			0x08648, 1},
	{"RF_SSC_STATE_RTL_TOP_2_SSCL",			0x08650, 1},
	{"RF_SSC_STATE_RTL_TOP_0_SSC0",			0x08658, 1},
	{"RF_SSC_STATE_RTL_TOP_3_SSC0",			0x08660, 1},
	{"RF_SSC_STATE_RTL_TOP_0_SSC1",			0x08668, 1},
	{"RF_SSC_STATE_RTL_TOP_3_SSC1",			0x08670, 1},
	{"RF_SSC_STATE_RTL_TOP_0_SSCL",			0x08678, 1},
	{"RF_SSC_STATE_RTL_TOP_3_SSCL",			0x08680, 1},
	{"RF_SSCC_TSR_RTL_TOP_%d",			0x08688, 3},
	{"RF_UQM_CMCREQ_RTL_TOP",			0x086A0, 1},
	{"RR%d_G3IF_CM_CTRL_RTL_TOP",			0x086A8, 3},
	{"RF_G3IF_CM_RD_RTL_TOP%d",			0x086C0, 3},
	{"RF_CMG_MSG2CMG_RTL_TOP_0_0",			0x086D8, 1},
	{"RF_CMG_MSG2CMG_RTL_TOP_1_0",			0x086E0, 1},
	{"RF_CMG_MSG2CMG_RTL_TOP_0_1",			0x086E8, 1},
	{"RF_CMG_MSG2CMG_RTL_TOP_1_1",			0x086F0, 1},
	{"RF_CP_DMA_RESP_RTL_TOP_0",			0x086F8, 1},
	{"RF_CP_DMA_RESP_RTL_TOP_1",			0x08700, 1},
	{"RF_CP_DMA_RESP_RTL_TOP_2",			0x08708, 1},
	{"RF_CP_QCC2CXP_RTL_TOP",			0x08710, 1},
	{"RF_CP_STC2CP_RTL_TOP",			0x08718, 1},
	{"RF_CP_XT_TRACE_RTL_TOP",			0x08720, 1},
	{"RF_CP_XT_DTAG_RTL_TOP",			0x08728, 1},
	{"RF_CP_XT_ICACHE_RTL_TOP_0_0",			0x08730, 1},
	{"RF_CP_XT_ICACHE_RTL_TOP_1_0",			0x08738, 1},
	{"RF_CP_XT_ICACHE_RTL_TOP_0_1",			0x08740, 1},
	{"RF_CP_XT_ICACHE_RTL_TOP_1_1",			0x08748, 1},
	{"RF_CP_XT_ITAG_RTL_TOP",			0x08750, 1},
	{"RF_CP_XT_DCACHE_RTL_TOP_0_0",			0x08758, 1},
	{"RF_CP_XT_DCACHE_RTL_TOP_1_0",			0x08760, 1},
	{"RF_CP_XT_DCACHE_RTL_TOP_0_1",			0x08768, 1},
	{"RF_CP_XT_DCACHE_RTL_TOP_1_1",			0x08770, 1},
	{"RF_XTMC_BDT_MEM_RTL_TOP_0",			0x08778, 1},
	{"RF_XTMC_BDT_MEM_RTL_TOP_1",			0x08780, 1},
	{"RF_XT_PIF_SRAM_RTL_TOP_SRAM0",		0x08788, 1},
	{"RF_XT_PIF_SRAM_RTL_TOP_SRAM1",		0x08790, 1},
	{"RF_STC_SRCH_MEM_RTL_TOP_0_0",			0x08798, 1},
	{"RF_STC_SRCH_MEM_RTL_TOP_1_0",			0x087A0, 1},
	{"RF_STC_SRCH_MEM_RTL_TOP_0_1",			0x087A8, 1},
	{"RF_STC_SRCH_MEM_RTL_TOP_1_1",			0x087B0, 1},
	{"RF_DAM_WRRESP_RTL_TOP",			0x087B8, 1},
	{"RF_DAM_RDSB_FIFO_RTL_TOP",			0x087C0, 1},
	{"RF_DAM_WRSB_FIFO_RTL_TOP",			0x087C8, 1},
	{"RR_DBF_LADD_0_DBL_RTL_TOP",			0x087D0, 1},
	{"RR_DBF_LADD_1_DBL_RTL_TOP",			0x087D8, 1},
	{"RR_DBF_LADD_2_DBL_RTL_TOP",			0x087E0, 1},
	{"RR_DBF_HADD_0_DBL_RTL_TOP",			0x087E8, 1},
	{"RR_DBF_HADD_1_DBL_RTL_TOP",			0x087F0, 1},
	{"RR_DBF_HADD_2_DBL_RTL_TOP",			0x087F8, 1},
	{"RF_USDC_0_FIFO_RTL_TOP",			0x08800, 1},
	{"RF_USDC_1_FIFO_RTL_TOP",			0x08808, 1},
	{"RF_USDC_0_WA_RTL_TOP",			0x08810, 1},
	{"RF_USDC_1_WA_RTL_TOP",			0x08818, 1},
	{"RF_USDC_0_SA_RTL_TOP",			0x08820, 1},
	{"RF_USDC_1_SA_RTL_TOP",			0x08828, 1},
	{"RF_USDC_0_CA_RTL_TOP",			0x08830, 1},
	{"RF_USDC_1_CA_RTL_TOP",			0x08838, 1},
	{"RF_G3IF_FB_RD1",				0x08840, 1},
	{"RF_G3IF_FB_RD2",				0x08848, 1},
	{"RF_G3IF_FB_CTRL_RTL_TOP1",			0x08850, 1},
	{"RF_G3IF_FB_CTRL_RTL_TOP",			0x08858, 1},
	{"RR_ROCRC_FRMBUF_RTL_TOP_0",			0x08860, 1},
	{"RR_ROCRC_FRMBUF_RTL_TOP_1",			0x08868, 1},
	{"RR_FAU_XFMD_INS_RTL_TOP",			0x08870, 1},
	{"RF_FBMC_XFMD_RTL_TOP_A1",			0x08878, 1},
	{"RF_FBMC_XFMD_RTL_TOP_A2",			0x08880, 1},
	{"RF_FBMC_XFMD_RTL_TOP_A3",			0x08888, 1},
	{"RF_FBMC_XFMD_RTL_TOP_B1",			0x08890, 1},
	{"RF_FBMC_XFMD_RTL_TOP_B2",			0x08898, 1},
	{"RF_FBMC_XFMD_RTL_TOP_B3",			0x088A0, 1},
	{"RR_FAU_MAC2F_W_H_RTL_TOP_PORT0",		0x088A8, 1},
	{"RR_FAU_MAC2F_W_H_RTL_TOP_PORT1",		0x088B0, 1},
	{"RR_FAU_MAC2F_N_H_RTL_TOP_PORT0",		0x088B8, 1},
	{"RR_FAU_MAC2F_N_H_RTL_TOP_PORT1",		0x088C0, 1},
	{"RR_FAU_MAC2F_W_L_RTL_TOP_PORT2",		0x088C8, 1},
	{"RR_FAU_MAC2F_N_L_RTL_TOP_PORT2",		0x088D0, 1},
	{"RF_ORP_FRM_FIFO_RTL_TOP_0",			0x088D8, 1},
	{"RF_ORP_FRM_FIFO_RTL_TOP_1",			0x088E0, 1},
	{"RF_TPA_DA_LKP_RTL_TOP_0_0",			0x088E8, 1},
	{"RF_TPA_DA_LKP_RTL_TOP_1_0",			0x088F0, 1},
	{"RF_TPA_DA_LKP_RTL_TOP_0_1",			0x088F8, 1},
	{"RF_TPA_DA_LKP_RTL_TOP_1_1",			0x08900, 1},
	{"RF_TMAC_TPA2MAC_RTL_TOP_0_0",			0x08908, 1},
	{"RF_TMAC_TPA2MAC_RTL_TOP_1_0",			0x08910, 1},
	{"RF_TMAC_TPA2MAC_RTL_TOP_2_0",			0x08918, 1},
	{"RF_TMAC_TPA2MAC_RTL_TOP_0_1",			0x08920, 1},
	{"RF_TMAC_TPA2MAC_RTL_TOP_1_1",			0x08928, 1},
	{"RF_TMAC_TPA2MAC_RTL_TOP_2_1",			0x08930, 1},
	{"RF_TMAC_TPA2MAC_RTL_TOP_0_2",			0x08938, 1},
	{"RF_TMAC_TPA2MAC_RTL_TOP_1_2",			0x08940, 1},
	{"RF_TMAC_TPA2MAC_RTL_TOP_2_2",			0x08948, 1},
	{"RF_TMAC_TPA2M_DA_RTL_TOP",			0x08950, 1},
	{"RF_TMAC_TPA2M_SB_RTL_TOP",			0x08958, 1},
	{"RF_XT_TRACE_RTL_TOP_MP",			0x08960, 1},
	{"RF_MP_XT_DTAG_RTL_TOP",			0x08968, 1},
	{"RF_MP_XT_ICACHE_RTL_TOP_0_0",			0x08970, 1},
	{"RF_MP_XT_ICACHE_RTL_TOP_1_0",			0x08978, 1},
	{"RF_MP_XT_ICACHE_RTL_TOP_0_1",			0x08980, 1},
	{"RF_MP_XT_ICACHE_RTL_TOP_1_1",			0x08988, 1},
	{"RF_MP_XT_ITAG_RTL_TOP",			0x08990, 1},
	{"RF_MP_XT_DCACHE_RTL_TOP_0_0",			0x08998, 1},
	{"RF_MP_XT_DCACHE_RTL_TOP_1_0",			0x089A0, 1},
	{"RF_MP_XT_DCACHE_RTL_TOP_0_1",			0x089A8, 1},
	{"RF_MP_XT_DCACHE_RTL_TOP_1_1",			0x089B0, 1},
	{"RF_MSG_BWR_PF_RTL_TOP_0",			0x089B8, 1},
	{"RF_MSG_BWR_PF_RTL_TOP_1",			0x089C0, 1},
	{"RF_MSG_UMQ_RTL_TOP_0",			0x089C8, 1},
	{"RF_MSG_UMQ_RTL_TOP_1",			0x089D0, 1},
	{"RF_MSG_DMQ_RTL_TOP_0",			0x089D8, 1},
	{"RF_MSG_DMQ_RTL_TOP_1",			0x089E0, 1},
	{"RF_MSG_DMQ_RTL_TOP_2",			0x089E8, 1},
	{"RF_MSG_DMA_RESP_RTL_TOP_0",			0x089F0, 1},
	{"RF_MSG_DMA_RESP_RTL_TOP_1",			0x089F8, 1},
	{"RF_MSG_DMA_RESP_RTL_TOP_2",			0x08A00, 1},
	{"RF_MSG_CMG2MSG_RTL_TOP_0_0",			0x08A08, 1},
	{"RF_MSG_CMG2MSG_RTL_TOP_1_0",			0x08A10, 1},
	{"RF_MSG_CMG2MSG_RTL_TOP_0_1",			0x08A18, 1},
	{"RF_MSG_CMG2MSG_RTL_TOP_1_1",			0x08A20, 1},
	{"RF_MSG_TXPE2MSG_RTL_TOP",			0x08A28, 1},
	{"RF_MSG_RXPE2MSG_RTL_TOP",			0x08A30, 1},
	{"RF_MSG_RPE2MSG_RTL_TOP",			0x08A38, 1},
	{"RR_TIM_BMAP_RTL_TOP",				0x08A40, 1},
	{"RF_TIM_VBLS_RTL_TOP",				0x08A48, 1},
	{"RF_TIM_BMAP_MSG_RTL_TOP_0_0",			0x08A50, 1},
	{"RF_TIM_BMAP_MSG_RTL_TOP_1_0",			0x08A58, 1},
	{"RF_TIM_BMAP_MSG_RTL_TOP_2_0",			0x08A60, 1},
	{"RF_TIM_BMAP_MSG_RTL_TOP_0_1",			0x08A68, 1},
	{"RF_TIM_BMAP_MSG_RTL_TOP_1_1",			0x08A70, 1},
	{"RF_TIM_BMAP_MSG_RTL_TOP_2_1",			0x08A78, 1},
	{"RF_TIM_BMAP_MSG_RTL_TOP_0_2",			0x08A80, 1},
	{"RF_TIM_BMAP_MSG_RTL_TOP_1_2",			0x08A88, 1},
	{"RF_TIM_BMAP_MSG_RTL_TOP_2_2",			0x08A90, 1},
	{"RF_TIM_BMAP_MSG_RTL_TOP_0_3",			0x08A98, 1},
	{"RF_TIM_BMAP_MSG_RTL_TOP_1_3",			0x08AA0, 1},
	{"RF_TIM_BMAP_MSG_RTL_TOP_2_3",			0x08AA8, 1},
	{"RF_TIM_BMAP_MSG_RTL_TOP_0_4",			0x08AB0, 1},
	{"RF_TIM_BMAP_MSG_RTL_TOP_1_4",			0x08AB8, 1},
	{"RF_TIM_BMAP_MSG_RTL_TOP_2_4",			0x08AC0, 1},
	{"RF_XT_TRACE_RTL_TOP_UP",			0x08AC8, 1},
	{"RF_UP_XT_DTAG_RTL_TOP",			0x08AD0, 1},
	{"RF_UP_XT_ICACHE_RTL_TOP_0_0",			0x08AD8, 1},
	{"RF_UP_XT_ICACHE_RTL_TOP_1_0",			0x08AE0, 1},
	{"RF_UP_XT_ICACHE_RTL_TOP_0_1",			0x08AE8, 1},
	{"RF_UP_XT_ICACHE_RTL_TOP_1_1",			0x08AF0, 1},
	{"RF_UP_XT_ITAG_RTL_TOP",			0x08AF8, 1},
	{"RF_UP_XT_DCACHE_RTL_TOP_0_0",			0x08B00, 1},
	{"RF_UP_XT_DCACHE_RTL_TOP_1_0",			0x08B08, 1},
	{"RF_UP_XT_DCACHE_RTL_TOP_0_1",			0x08B10, 1},
	{"RF_UP_XT_DCACHE_RTL_TOP_1_1",			0x08B18, 1},
	{"RR_RXPE_XT0_IRAM_RTL_TOP_0",			0x08B20, 1},
	{"RR_RXPE_XT0_IRAM_RTL_TOP_1",			0x08B28, 1},
	{"RR_RXPE_XT_DRAM_RTL_TOP_0",			0x08B30, 1},
	{"RR_RXPE_XT_DRAM_RTL_TOP_1",			0x08B38, 1},
	{"RF_RXPE_MSG2RXPE_RTL_TOP_0",			0x08B40, 1},
	{"RF_RXPE_MSG2RXPE_RTL_TOP_1",			0x08B48, 1},
	{"RF_RXPE_XT0_FRM_RTL_TOP",			0x08B50, 1},
	{"RF_RPE_PDM_RCMD_RTL_TOP",			0x08B58, 1},
	{"RF_RPE_RCQ_RTL_TOP",				0x08B60, 1},
	{"RF_RPE_RCO_PBLE_RTL_TOP",			0x08B68, 1},
	{"RR_RXPE_XT1_IRAM_RTL_TOP_0",			0x08B70, 1},
	{"RR_RXPE_XT1_IRAM_RTL_TOP_1",			0x08B78, 1},
	{"RR_RPE_SCCM_RTL_TOP_0",			0x08B80, 1},
	{"RR_RPE_SCCM_RTL_TOP_1",			0x08B88, 1},
	{"RR_PE_PET_TIMER_RTL_TOP_0",			0x08B90, 1},
	{"RR_PE_PET_TIMER_RTL_TOP_1",			0x08B98, 1},
	{"RF_PE_DLM_LWRQ_RTL_TOP_0",			0x08BA0, 1},
	{"RF_PE_DLM_LWRQ_RTL_TOP_1",			0x08BA8, 1},
	{"RF_TXPE_MSG2TXPE_RTL_TOP_%d",			0x08BB0, 2},
	{"RF_PCI_RETRY_BUF_RTL_TOP_%d",			0x08BC0, 6},
	{"RF_PCI_SOT_BUF_RTL_TOP",			0x08BF0, 1},
	{"RF_PCI_RX_PH_RTL_TOP",			0x08BF8, 1},
	{"RF_PCI_RX_NPH_RTL_TOP",			0x08C00, 1},
	{"RF_PCI_RX_PD_RTL_TOP_%d",			0x08C08, 12},
	{"RF_PCI_RX_NPD_RTL_TOP_%d",			0x08C68, 2},
	{"RF_PIC_KDFC_DBL_RTL_TOP_%d",			0x08C78, 5},
	{"RF_PCC_TXDO_RTL_TOP_PCC%d",			0x08CA0, 8},
	{"RR_PCC_ASS_BUF_RTL_TOP_PCC1",			0x08CE0, 1},
	{"RR_PCC_ASS_BUF_RTL_TOP_PCC3",			0x08CE8, 1},
	{"RR_PCC_ASS_BUF_RTL_TOP_PCC5",			0x08CF0, 1},
	{"RR_PCC_ASS_BUF_RTL_TOP_PCC7",			0x08CF8, 1},
	{"RR_PCC_ASS_BUF_RTL_TOP_PCC0",			0x08D00, 1},
	{"RR_PCC_ASS_BUF_RTL_TOP_PCC2",			0x08D08, 1},
	{"RR_PCC_ASS_BUF_RTL_TOP_PCC6",			0x08D10, 1},
	{"RR_PCC_ASS_BUF_RTL_TOP_PCC4",			0x08D18, 1},
	{"RF_ROCRC_CMDQ_BP_RTL_TOP_0_WRAPPER0",		0x08D20, 1},
	{"RF_ROCRC_CMDQ_BP_RTL_TOP_1_WRAPPER0",		0x08D28, 1},
	{"RF_ROCRC_CMDQ_BP_RTL_TOP_2_WRAPPER0",		0x08D30, 1},
	{"RF_ROCRC_CMDQ_BP_RTL_TOP_0_WRAPPER1",		0x08D38, 1},
	{"RF_ROCRC_CMDQ_BP_RTL_TOP_1_WRAPPER1",		0x08D40, 1},
	{"RF_ROCRC_CMDQ_BP_RTL_TOP_2_WRAPPER1",		0x08D48, 1},
	{"RF_ROCRC_CMDQ_BP_RTL_TOP_0_WRAPPER2",		0x08D50, 1},
	{"RF_ROCRC_CMDQ_BP_RTL_TOP_1_WRAPPER2",		0x08D58, 1},
	{"RF_ROCRC_CMDQ_BP_RTL_TOP_2_WRAPPER2",		0x08D60, 1},
	{"RR_ROCRC_RXD_RTL_TOP_RXD%d",			0x08D68, 2},
	{"RF_ROCRC_UMQ_MDQ_RTL_TOP_%d",			0x08D78, 8},
	{"RF_ROCRC_IMMDBUF_RTL_TOP",			0x08DB8, 1},
	{"RF_ROCRC_QCC_BYP_RTL_TOP_%d",			0x08DC0, 2},
	{"RR_RMAC_DA_LKP_RTL_TOP_%d",			0x08DD0, 4},
	{"RR_RMAC_PN_LKP_D_RTL_TOP",			0x08DF0, 1},
	{"RF_RMAC_PN_LKP_S_RTL_TOP_%d",			0x08DF8, 2},
	{"RF_RMAC_RTH_LKP_RTL_TOP_0_0",			0x08E08, 1},
	{"RF_RMAC_RTH_LKP_RTL_TOP_1_0",			0x08E10, 1},
	{"RF_RMAC_RTH_LKP_RTL_TOP_0_1",			0x08E18, 1},
	{"RF_RMAC_RTH_LKP_RTL_TOP_1_1",			0x08E20, 1},
	{"RF_RMAC_DS_LKP_RTL_TOP",			0x08E28, 1},
	{"RF_RMAC_RTS_PART_RTL_TOP_0_RMAC0",		0x08E30, 1},
	{"RF_RMAC_RTS_PART_RTL_TOP_1_RMAC0",		0x08E38, 1},
	{"RF_RMAC_RTS_PART_RTL_TOP_0_RMAC1",		0x08E40, 1},
	{"RF_RMAC_RTS_PART_RTL_TOP_1_RMAC1",		0x08E48, 1},
	{"RF_RMAC_RTS_PART_RTL_TOP_0_RMAC2",		0x08E50, 1},
	{"RF_RMAC_RTS_PART_RTL_TOP_1_RMAC2",		0x08E58, 1},
	{"RF_RMAC_RTH_MASK_RTL_TOP_%d",			0x08E60, 4},
	{"RF_RMAC_VID_LKP_RTL_TOP_1",			0x08E88, 0},
	{"RF_RMAC_VID_LKP_RTL_TOP_2",			0x08E90, 0},
	{"RF_RMAC_VID_LKP_RTL_TOP_3",			0x08E98, 0},
	{"RF_RMAC_VID_LKP_RTL_TOP_4",			0x08EA0, 0},
	{"RF_RMAC_VID_LKP_RTL_TOP_5",			0x08EA8, 0},
	{"RF_RMAC_VID_LKP_RTL_TOP_6",			0x08EB0, 0},
	{"RF_RMAC_VID_LKP_RTL_TOP_7",			0x08EB8, 0},
	{"RF_RMAC_STATS_RTL_TOP_0_STATS_0",		0x08EC0, 1},
	{"RF_RMAC_STATS_RTL_TOP_1_STATS_0",		0x08EC8, 1},
	{"RF_RMAC_STATS_RTL_TOP_0_STATS_1",		0x08ED0, 1},
	{"RF_RMAC_STATS_RTL_TOP_1_STATS_1",		0x08ED8, 1},
	{"RF_RMAC_STATS_RTL_TOP_0_STATS_2",		0x08EE0, 1},
	{"RF_RMAC_STATS_RTL_TOP_1_STATS_2",		0x08EE8, 1},
	{"RF_RMAC_STATS_RTL_TOP_0_STATS_3",		0x08EF0, 1},
	{"RF_RMAC_STATS_RTL_TOP_1_STATS_3",		0x08EF8, 1},
	{"RF_RMAC_STATS_RTL_TOP_0_STATS_4",		0x08F00, 1},
	{"RF_RMAC_STATS_RTL_TOP_1_STATS_4",		0x08F08, 1},
	{"G3IFCMD_FB_INT_STATUS",			0x09000, 1},
	{"G3IFCMD_FB_INT_MASK",				0x09008, 1},
	{"G3IFCMD_FB_ERR_REG",				0x09010, 1},
	{"G3IFCMD_FB_ERR_MASK",				0x09018, 1},
	{"G3IFCMD_FB_ERR_ALARM",			0x09020, 1},
	{"G3IFCMD_FB_DLL_CK0",				0x09028, 1},
	{"G3IFCMD_FB_IO_CTRL",				0x09030, 1},
	{"G3IFCMD_FB_IOCAL",				0x09038, 1},
	{"G3IFCMD_FB_MASTER_DLL_CK",			0x09040, 1},
	{"G3IFCMD_FB_DLL_TRAINING",			0x09048, 1},
	{"G3IFGR01_FB_GROUP0_DLL_RDQS",			0x09110, 1},
	{"G3IFGR01_FB_GROUP0_DLL_RDQS1",		0x09118, 1},
	{"G3IFGR01_FB_GROUP0_DLL_WDQS",			0x09120, 1},
	{"G3IFGR01_FB_GROUP0_DLL_WDQS1",		0x09128, 1},
	{"G3IFGR01_FB_GROUP0_DLL_TRAINING1",		0x09130, 1},
	{"G3IFGR01_FB_GROUP0_DLL_TRAINING2",		0x09138, 1},
	{"G3IFGR01_FB_GROUP0_DLL_TRAINING3",		0x09140, 1},
	{"G3IFGR01_FB_GROUP0_DLL_ACT_TRAINING5",	0x09148, 1},
	{"G3IFGR01_FB_GROUP0_DLL_TRAINING6",		0x09150, 1},
	{"G3IFGR01_FB_GROUP0_DLL_ATRA_OFFSET",		0x09158, 1},
	{"G3IFGR01_FB_GROUP0_DLL_TRA_HOLD",		0x09160, 1},
	{"G3IFGR01_FB_GROUP0_DLL_ATRA_HOLD",		0x09168, 1},
	{"G3IFGR01_FB_GROUP0_DLL_MASTER_CODES",		0x09170, 1},
	{"G3IFGR01_FB_GROUP0_DLL_ATRA_TIMER",		0x09178, 1},
	{"G3IFGR01_FB_GROUP1_DLL_RDQS",			0x09180, 1},
	{"G3IFGR01_FB_GROUP1_DLL_RDQS1",		0x09188, 1},
	{"G3IFGR01_FB_GROUP1_DLL_WDQS",			0x09190, 1},
	{"G3IFGR01_FB_GROUP1_DLL_WDQS1",		0x09198, 1},
	{"G3IFGR01_FB_GROUP1_DLL_TRAINING1",		0x091A0, 1},
	{"G3IFGR01_FB_GROUP1_DLL_TRAINING2",		0x091A8, 1},
	{"G3IFGR01_FB_GROUP1_DLL_TRAINING3",		0x091B0, 1},
	{"G3IFGR01_FB_GROUP1_DLL_ACT_TRAINING5",	0x091B8, 1},
	{"G3IFGR01_FB_GROUP1_DLL_TRAINING6",		0x091C0, 1},
	{"G3IFGR01_FB_GROUP1_DLL_ATRA_OFFSET",		0x091C8, 1},
	{"G3IFGR01_FB_GROUP1_DLL_TRA_HOLD",		0x091D0, 1},
	{"G3IFGR01_FB_GROUP1_DLL_ATRA_HOLD",		0x091D8, 1},
	{"G3IFGR01_FB_GROUP1_DLL_MASTER_CODES",		0x091E0, 1},
	{"G3IFGR01_FB_GROUP1_DLL_ATRA_TIMER",		0x091E8, 1},
	{"G3IFGR23_FB_GROUP2_DLL_RDQS",			0x09210, 1},
	{"G3IFGR23_FB_GROUP2_DLL_RDQS1",		0x09218, 1},
	{"G3IFGR23_FB_GROUP2_DLL_WDQS",			0x09220, 1},
	{"G3IFGR23_FB_GROUP2_DLL_WDQS1",		0x09228, 1},
	{"G3IFGR23_FB_GROUP2_DLL_TRAINING1",		0x09230, 1},
	{"G3IFGR23_FB_GROUP2_DLL_TRAINING2",		0x09238, 1},
	{"G3IFGR23_FB_GROUP2_DLL_TRAINING3",		0x09240, 1},
	{"G3IFGR23_FB_GROUP2_DLL_ACT_TRAINING5",	0x09248, 1},
	{"G3IFGR23_FB_GROUP2_DLL_TRAINING6",		0x09250, 1},
	{"G3IFGR23_FB_GROUP2_DLL_ATRA_OFFSET",		0x09258, 1},
	{"G3IFGR23_FB_GROUP2_DLL_TRA_HOLD",		0x09260, 1},
	{"G3IFGR23_FB_GROUP2_DLL_ATRA_HOLD",		0x09268, 1},
	{"G3IFGR23_FB_GROUP2_DLL_MASTER_CODES",		0x09270, 1},
	{"G3IFGR23_FB_GROUP2_DLL_ATRA_TIMER",		0x09278, 1},
	{"G3IFGR23_FB_GROUP3_DLL_RDQS",			0x09280, 1},
	{"G3IFGR23_FB_GROUP3_DLL_RDQS1",		0x09288, 1},
	{"G3IFGR23_FB_GROUP3_DLL_WDQS",			0x09290, 1},
	{"G3IFGR23_FB_GROUP3_DLL_WDQS1",		0x09298, 1},
	{"G3IFGR23_FB_GROUP3_DLL_TRAINING1",		0x092A0, 1},
	{"G3IFGR23_FB_GROUP3_DLL_TRAINING2",		0x092A8, 1},
	{"G3IFGR23_FB_GROUP3_DLL_TRAINING3",		0x092B0, 1},
	{"G3IFGR23_FB_GROUP3_DLL_ACT_TRAINING5",	0x092B8, 1},
	{"G3IFGR23_FB_GROUP3_DLL_TRAINING6",		0x092C0, 1},
	{"G3IFGR23_FB_GROUP3_DLL_ATRA_OFFSET",		0x092C8, 1},
	{"G3IFGR23_FB_GROUP3_DLL_TRA_HOLD",		0x092D0, 1},
	{"G3IFGR23_FB_GROUP3_DLL_ATRA_HOLD",		0x092D8, 1},
	{"G3IFGR23_FB_GROUP3_DLL_MASTER_CODES",		0x092E0, 1},
	{"G3IFGR23_FB_GROUP3_DLL_ATRA_TIMER",		0x092E8, 1},
	{"G3IFCMD_CMU_INT_STATUS",			0x09400, 1},
	{"G3IFCMD_CMU_INT_MASK",			0x09408, 1},
	{"G3IFCMD_CMU_ERR_REG",				0x09410, 1},
	{"G3IFCMD_CMU_ERR_MASK",			0x09418, 1},
	{"G3IFCMD_CMU_ERR_ALARM",			0x09420, 1},
	{"G3IFCMD_CMU_DLL_CK0",				0x09428, 1},
	{"G3IFCMD_CMU_IO_CTRL",				0x09430, 1},
	{"G3IFCMD_CMU_IOCAL",				0x09438, 1},
	{"G3IFCMD_CMU_MASTER_DLL_CK",			0x09440, 1},
	{"G3IFCMD_CMU_DLL_TRAINING",			0x09448, 1},
	{"G3IFGR01_CMU_GROUP0_DLL_RDQS",		0x09510, 1},
	{"G3IFGR01_CMU_GROUP0_DLL_RDQS1",		0x09518, 1},
	{"G3IFGR01_CMU_GROUP0_DLL_WDQS",		0x09520, 1},
	{"G3IFGR01_CMU_GROUP0_DLL_WDQS1",		0x09528, 1},
	{"G3IFGR01_CMU_GROUP0_DLL_TRAINING1",		0x09530, 1},
	{"G3IFGR01_CMU_GROUP0_DLL_TRAINING2",		0x09538, 1},
	{"G3IFGR01_CMU_GROUP0_DLL_TRAINING3",		0x09540, 1},
	{"G3IFGR01_CMU_GROUP0_DLL_ACT_TRAINING5",	0x09548, 1},
	{"G3IFGR01_CMU_GROUP0_DLL_TRAINING6",		0x09550, 1},
	{"G3IFGR01_CMU_GROUP0_DLL_ATRA_OFFSET",		0x09558, 1},
	{"G3IFGR01_CMU_GROUP0_DLL_TRA_HOLD",		0x09560, 1},
	{"G3IFGR01_CMU_GROUP0_DLL_ATRA_HOLD",		0x09568, 1},
	{"G3IFGR01_CMU_GROUP0_DLL_MASTER_CODES",	0x09570, 1},
	{"G3IFGR01_CMU_GROUP0_DLL_ATRA_TIMER",		0x09578, 1},
	{"G3IFGR01_CMU_GROUP1_DLL_RDQS",		0x09580, 1},
	{"G3IFGR01_CMU_GROUP1_DLL_RDQS1",		0x09588, 1},
	{"G3IFGR01_CMU_GROUP1_DLL_WDQS",		0x09590, 1},
	{"G3IFGR01_CMU_GROUP1_DLL_WDQS1",		0x09598, 1},
	{"G3IFGR01_CMU_GROUP1_DLL_TRAINING1",		0x095A0, 1},
	{"G3IFGR01_CMU_GROUP1_DLL_TRAINING2",		0x095A8, 1},
	{"G3IFGR01_CMU_GROUP1_DLL_TRAINING3",		0x095B0, 1},
	{"G3IFGR01_CMU_GROUP1_DLL_ACT_TRAINING5",	0x095B8, 1},
	{"G3IFGR01_CMU_GROUP1_DLL_TRAINING6",		0x095C0, 1},
	{"G3IFGR01_CMU_GROUP1_DLL_ATRA_OFFSET",		0x095C8, 1},
	{"G3IFGR01_CMU_GROUP1_DLL_TRA_HOLD",		0x095D0, 1},
	{"G3IFGR01_CMU_GROUP1_DLL_ATRA_HOLD",		0x095D8, 1},
	{"G3IFGR01_CMU_GROUP1_DLL_MASTER_CODES",	0x095E0, 1},
	{"G3IFGR01_CMU_GROUP1_DLL_ATRA_TIMER",		0x095E8, 1},
	{"G3IFGR23_CMU_GROUP2_DLL_RDQS",		0x09610, 1},
	{"G3IFGR23_CMU_GROUP2_DLL_RDQS1",		0x09618, 1},
	{"G3IFGR23_CMU_GROUP2_DLL_WDQS",		0x09620, 1},
	{"G3IFGR23_CMU_GROUP2_DLL_WDQS1",		0x09628, 1},
	{"G3IFGR23_CMU_GROUP2_DLL_TRAINING1",		0x09630, 1},
	{"G3IFGR23_CMU_GROUP2_DLL_TRAINING2",		0x09638, 1},
	{"G3IFGR23_CMU_GROUP2_DLL_TRAINING3",		0x09640, 1},
	{"G3IFGR23_CMU_GROUP2_DLL_ACT_TRAINING5",	0x09648, 1},
	{"G3IFGR23_CMU_GROUP2_DLL_TRAINING6",		0x09650, 1},
	{"G3IFGR23_CMU_GROUP2_DLL_ATRA_OFFSET",		0x09658, 1},
	{"G3IFGR23_CMU_GROUP2_DLL_TRA_HOLD",		0x09660, 1},
	{"G3IFGR23_CMU_GROUP2_DLL_ATRA_HOLD",		0x09668, 1},
	{"G3IFGR23_CMU_GROUP2_DLL_MASTER_CODES",	0x09670, 1},
	{"G3IFGR23_CMU_GROUP2_DLL_ATRA_TIMER",		0x09678, 1},
	{"G3IFGR23_CMU_GROUP3_DLL_RDQS",		0x09680, 1},
	{"G3IFGR23_CMU_GROUP3_DLL_RDQS1",		0x09688, 1},
	{"G3IFGR23_CMU_GROUP3_DLL_WDQS",		0x09690, 1},
	{"G3IFGR23_CMU_GROUP3_DLL_WDQS1",		0x09698, 1},
	{"G3IFGR23_CMU_GROUP3_DLL_TRAINING1",		0x096A0, 1},
	{"G3IFGR23_CMU_GROUP3_DLL_TRAINING2",		0x096A8, 1},
	{"G3IFGR23_CMU_GROUP3_DLL_TRAINING3",		0x096B0, 1},
	{"G3IFGR23_CMU_GROUP3_DLL_ACT_TRAINING5",	0x096B8, 1},
	{"G3IFGR23_CMU_GROUP3_DLL_TRAINING6",		0x096C0, 1},
	{"G3IFGR23_CMU_GROUP3_DLL_ATRA_OFFSET",		0x096C8, 1},
	{"G3IFGR23_CMU_GROUP3_DLL_TRA_HOLD",		0x096D0, 1},
	{"G3IFGR23_CMU_GROUP3_DLL_ATRA_HOLD",		0x096D8, 1},
	{"G3IFGR23_CMU_GROUP3_DLL_MASTER_CODES",	0x096E0, 1},
	{"G3IFGR23_CMU_GROUP3_DLL_ATRA_TIMER",		0x096E8, 1},
	{"G3IFCMD_CML_INT_STATUS",			0x09800, 1},
	{"G3IFCMD_CML_INT_MASK",			0x09808, 1},
	{"G3IFCMD_CML_ERR_REG",				0x09810, 1},
	{"G3IFCMD_CML_ERR_MASK",			0x09818, 1},
	{"G3IFCMD_CML_ERR_ALARM",			0x09820, 1},
	{"G3IFCMD_CML_DLL_CK0",				0x09828, 1},
	{"G3IFCMD_CML_IO_CTRL",				0x09830, 1},
	{"G3IFCMD_CML_IOCAL",				0x09838, 1},
	{"G3IFCMD_CML_MASTER_DLL_CK",			0x09840, 1},
	{"G3IFCMD_CML_DLL_TRAINING",			0x09848, 1},
	{"G3IFGR01_CML_GROUP0_DLL_RDQS",		0x09910, 1},
	{"G3IFGR01_CML_GROUP0_DLL_RDQS1",		0x09918, 1},
	{"G3IFGR01_CML_GROUP0_DLL_WDQS",		0x09920, 1},
	{"G3IFGR01_CML_GROUP0_DLL_WDQS1",		0x09928, 1},
	{"G3IFGR01_CML_GROUP0_DLL_TRAINING1",		0x09930, 1},
	{"G3IFGR01_CML_GROUP0_DLL_TRAINING2",		0x09938, 1},
	{"G3IFGR01_CML_GROUP0_DLL_TRAINING3",		0x09940, 1},
	{"G3IFGR01_CML_GROUP0_DLL_ACT_TRAINING5",	0x09948, 1},
	{"G3IFGR01_CML_GROUP0_DLL_TRAINING6",		0x09950, 1},
	{"G3IFGR01_CML_GROUP0_DLL_ATRA_OFFSET",		0x09958, 1},
	{"G3IFGR01_CML_GROUP0_DLL_TRA_HOLD",		0x09960, 1},
	{"G3IFGR01_CML_GROUP0_DLL_ATRA_HOLD",		0x09968, 1},
	{"G3IFGR01_CML_GROUP0_DLL_MASTER_CODES",	0x09970, 1},
	{"G3IFGR01_CML_GROUP0_DLL_ATRA_TIMER",		0x09978, 1},
	{"G3IFGR01_CML_GROUP1_DLL_RDQS",		0x09980, 1},
	{"G3IFGR01_CML_GROUP1_DLL_RDQS1",		0x09988, 1},
	{"G3IFGR01_CML_GROUP1_DLL_WDQS",		0x09990, 1},
	{"G3IFGR01_CML_GROUP1_DLL_WDQS1",		0x09998, 1},
	{"G3IFGR01_CML_GROUP1_DLL_TRAINING1",		0x099A0, 1},
	{"G3IFGR01_CML_GROUP1_DLL_TRAINING2",		0x099A8, 1},
	{"G3IFGR01_CML_GROUP1_DLL_TRAINING3",		0x099B0, 1},
	{"G3IFGR01_CML_GROUP1_DLL_ACT_TRAINING5",	0x099B8, 1},
	{"G3IFGR01_CML_GROUP1_DLL_TRAINING6",		0x099C0, 1},
	{"G3IFGR01_CML_GROUP1_DLL_ATRA_OFFSET",		0x099C8, 1},
	{"G3IFGR01_CML_GROUP1_DLL_TRA_HOLD",		0x099D0, 1},
	{"G3IFGR01_CML_GROUP1_DLL_ATRA_HOLD",		0x099D8, 1},
	{"G3IFGR01_CML_GROUP1_DLL_MASTER_CODES",	0x099E0, 1},
	{"G3IFGR01_CML_GROUP1_DLL_ATRA_TIMER",		0x099E8, 1},
	{"G3IFGR23_CML_GROUP2_DLL_RDQS",		0x09A10, 1},
	{"G3IFGR23_CML_GROUP2_DLL_RDQS1",		0x09A18, 1},
	{"G3IFGR23_CML_GROUP2_DLL_WDQS",		0x09A20, 1},
	{"G3IFGR23_CML_GROUP2_DLL_WDQS1",		0x09A28, 1},
	{"G3IFGR23_CML_GROUP2_DLL_TRAINING1",		0x09A30, 1},
	{"G3IFGR23_CML_GROUP2_DLL_TRAINING2",		0x09A38, 1},
	{"G3IFGR23_CML_GROUP2_DLL_TRAINING3",		0x09A40, 1},
	{"G3IFGR23_CML_GROUP2_DLL_ACT_TRAINING5",	0x09A48, 1},
	{"G3IFGR23_CML_GROUP2_DLL_TRAINING6",		0x09A50, 1},
	{"G3IFGR23_CML_GROUP2_DLL_ATRA_OFFSET",		0x09A58, 1},
	{"G3IFGR23_CML_GROUP2_DLL_TRA_HOLD",		0x09A60, 1},
	{"G3IFGR23_CML_GROUP2_DLL_ATRA_HOLD",		0x09A68, 1},
	{"G3IFGR23_CML_GROUP2_DLL_MASTER_CODES",	0x09A70, 1},
	{"G3IFGR23_CML_GROUP2_DLL_ATRA_TIMER",		0x09A78, 1},
	{"G3IFGR23_CML_GROUP3_DLL_RDQS",		0x09A80, 1},
	{"G3IFGR23_CML_GROUP3_DLL_RDQS1",		0x09A88, 1},
	{"G3IFGR23_CML_GROUP3_DLL_WDQS",		0x09A90, 1},
	{"G3IFGR23_CML_GROUP3_DLL_WDQS1",		0x09A98, 1},
	{"G3IFGR23_CML_GROUP3_DLL_TRAINING1",		0x09AA0, 1},
	{"G3IFGR23_CML_GROUP3_DLL_TRAINING2",		0x09AA8, 1},
	{"G3IFGR23_CML_GROUP3_DLL_TRAINING3",		0x09AB0, 1},
	{"G3IFGR23_CML_GROUP3_DLL_ACT_TRAINING5",	0x09AB8, 1},
	{"G3IFGR23_CML_GROUP3_DLL_TRAINING6",		0x09AC0, 1},
	{"G3IFGR23_CML_GROUP3_DLL_ATRA_OFFSET",		0x09AC8, 1},
	{"G3IFGR23_CML_GROUP3_DLL_TRA_HOLD",		0x09AD0, 1},
	{"G3IFGR23_CML_GROUP3_DLL_ATRA_HOLD",		0x09AD8, 1},
	{"G3IFGR23_CML_GROUP3_DLL_MASTER_CODES",	0x09AE0, 1},
	{"G3IFGR23_CML_GROUP3_DLL_ATRA_TIMER",		0x09AE8, 1},
	{"VPATH_TO_VPLANE_MAP_%d",			0x09B00, 17},
	{"XGXS_CFG_PORT%d",				0x09C30, 2},
	{"XGXS_RXBER_CFG_PORT%d",			0x09C40, 2},
	{"XGXS_RXBER_STATUS_PORT%d",			0x09C50, 2},
	{"XGXS_STATUS_PORT%d",				0x09C60, 2},
	{"XGXS_PMA_RESET_PORT%d",			0x09C70, 2},
	{"XGXS_STATIC_CFG_PORT%d",			0x09C90, 2},
	{"XGXS_SERDES_FW_CFG_PORT%d",			0x09CC0, 2},
	{"XGXS_SERDES_TX_CFG_PORT%d",			0x09CD0, 2},
	{"XGXS_SERDES_RX_CFG_PORT%d",			0x09CE0, 2},
	{"XGXS_SERDES_EXTRA_CFG_PORT%d",		0x09CF0, 2},
	{"XGXS_SERDES_STATUS_PORT%d",			0x09D00, 2},
	{"XGXS_SERDES_CR_ACCESS_PORT%d",		0x09D10, 2},
	{"XGXS_INFO_PORT%d",				0x09D40, 2},
	{"RATEMGMT_CFG_PORT%d",				0x09D50, 2},
	{"RATEMGMT_STATUS_PORT%d",			0x09D60, 2},
	{"RATEMGMT_FIXED_CFG_PORT%d",			0x09D80, 2},
	{"RATEMGMT_ANTP_CFG_PORT%d",			0x09D90, 2},
	{"RATEMGMT_ANBE_CFG_PORT%d",			0x09DA0, 2},
	{"ANBE_CFG_PORT%d",				0x09DB0, 2},
	{"ANBE_MGR_CTRL_PORT%d",			0x09DC0, 2},
	{"ANBE_FW_MSTR_PORT%d",				0x09DE0, 2},
	{"ANBE_HWFSM_GEN_STATUS_PORT%d",		0x09DF0, 2},
	{"ANBE_HWFSM_BP_STATUS_PORT%d",			0x09E00, 2},
	{"ANBE_HWFSM_NP_STATUS_PORT%d",			0x09E10, 2},
	{"ANTP_GEN_CFG_PORT%d",				0x09E30, 2},
	{"ANTP_HWFSM_GEN_STATUS_PORT%d",		0x09E40, 2},
	{"ANTP_HWFSM_BP_STATUS_PORT%d",			0x09E50, 2},
	{"ANTP_HWFSM_XNP_STATUS_PORT%d",		0x09E60, 2},
	{"MDIO_MGR_ACCESS_PORT%d",			0x09E70, 2},
	{"XMAC_VSPORT_CHOICES_VH%d",			0x0A200, 17},
	{"RX_THRESH_CFG_VP%d",				0x0A400, 17},
	{"FAU_ADAPTIVE_LRO_VPATH_ENABLE",		0x0AC00, 1},
	{"FAU_ADAPTIVE_LRO_BASE_SID_VP%d",		0x0AC08, 17},
};

vxge_pci_bar0_t reginfo_srpcim[] =
{
	{"TIM_MR2SR_RESOURCE_ASSIGNMENT_VH",		0x00000, 1},
	{"SRPCIM_PCIPIF_INT_STATUS",			0x00100, 1},
	{"SRPCIM_PCIPIF_INT_MASK",			0x00108, 1},
	{"MRPCIM_MSG_REG",				0x00110, 1},
	{"MRPCIM_MSG_MASK",				0x00118, 1},
	{"MRPCIM_MSG_ALARM",				0x00120, 1},
	{"VPATH_MSG_REG",				0x00128, 1},
	{"VPATH_MSG_MASK",				0x00130, 1},
	{"VPATH_MSG_ALARM",				0x00138, 1},
	{"VF_BARGRP_NO",				0x00158, 1},
	{"SRPCIM_TO_MRPCIM_WMSG",			0x00160, 1},
	{"SRPCIM_TO_MRPCIM_WMSG_TRIG",			0x00168, 1},
	{"MRPCIM_TO_SRPCIM_RMSG",			0x00170, 1},
	{"VPATH_TO_SRPCIM_RMSG_SEL",			0x00178, 1},
	{"PATH_TO_SRPCIM_RMSG",				0x00180, 1},
	{"SRPCIM_GENERAL_INT_STATUS",			0x00200, 1},
	{"SRPCIM_GENERAL_INT_MASK",			0x00210, 1},
	{"SRPCIM_PPIF_INT_STATUS",			0x00220, 1},
	{"SRPCIM_PPIF_INT_MASK",			0x00228, 1},
	{"SRPCIM_GEN_ERRORS_REG",			0x00230, 1},
	{"SRPCIM_GEN_ERRORS_MASK",			0x00238, 1},
	{"SRPCIM_GEN_ERRORS_ALARM",			0x00240, 1},
	{"MRPCIM_TO_SRPCIM_ALARM_REG",			0x00248, 1},
	{"VPATH_TO_SRPCIM_ALARM_MASK",			0x00268, 1},
	{"VPATH_TO_SRPCIM_ALARM_ALARM",			0x00270, 1},
	{"PF_SW_RESET",					0x00280, 1},
	{"SRPCIM_GENERAL_CFG1",				0x00288, 1},
	{"SRPCIM_INTERRUPT_CFG1",			0x00290, 1},
	{"SRPCIM_INTERRUPT_CFG2",			0x00298, 1},
	{"SRPCIM_CLEAR_MSIX_MASK",			0x002A8, 1},
	{"SRPCIM_SET_MSIX_MASK",			0x002B0, 1},
	{"SRPCIM_CLR_MSIX_ONE_SHOT",			0x002B8, 1},
	{"SRPCIM_RST_IN_PROG",				0x002C0, 1},
	{"SRPCIM_REG_MODIFIED",				0x002C8, 1},
	{"TGT_PF_ILLEGAL_ACCESS",			0x002D0, 1},
	{"SRPCIM_MSIX_STATUS",				0x002D8, 1},
	{"USDC_VPL",					0x00318, 1},
	{"ONE_CFG_SR_COPY",				0x00600, 1},
	{"SGRP_ALLOCATED",				0x00608, 1},
	{"SGRP_IWARP_LRO_ALLOCATED",			0x00610, 1},
	{"XGMAC_SR_INT_STATUS",				0x00880, 1},
	{"XGMAC_SR_INT_MASK",				0x00888, 1},
	{"ASIC_NTWK_SR_ERR_REG",			0x00890, 1},
	{"ASIC_NTWK_SR_ERR_MASK",			0x00898, 1},
	{"ASIC_NTWK_SR_ERR_ALARM",			0x008A0, 1},
	{"XMAC_VSPORT_CHOICES_SR_CLONE",		0x008C0, 1},
	{"MR_RQA_TOP_PRTY_FOR_VH",			0x00900, 1},
	{"UMQ_VH_DATA_LIST_EMPTY",			0x00908, 1},
	{"WDE_CFG",					0x00910, 1}
};

vxge_stats_driver_info_t driverInfo[] =
{
	/* ISR statistics */
	{"isr_msix",		0},

	/* Tx statistics */
	{"tx_xmit",		0},
	{"tx_posted",		0},
	{"tx_compl",		0},
	{"tx_tso",		0},
	{"tx_tcode",		0},
	{"tx_low_dtr_cnt",	0},
	{"tx_reserve_failed",	0},
	{"tx_no_dma_setup",	0},
	{"tx_max_frags",	0},
	{"tx_again",		0},

	/* Rx statistics */
	{"rx_compl",		0},
	{"rx_tcode",		0},
	{"rx_no_buf",		0},
	{"rx_map_fail",		0},
	{"rx_lro_queued",	0},
	{"rx_lro_flushed",	0}
};

#endif	/* _VXGE_LOG_H_ */
