//===------- SparcTargetObjectFile.cpp - Sparc Object Info Impl -----------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

#include "SparcTargetObjectFile.h"
#include "MCTargetDesc/SparcMCExpr.h"
#include "llvm/CodeGen/MachineModuleInfoImpls.h"
#include "llvm/Support/Dwarf.h"
#include "llvm/Target/Mangler.h"

using namespace llvm;


const MCExpr *SparcELFTargetObjectFile::
getTTypeGlobalReference(const GlobalValue *GV, Mangler *Mang,
                        MachineModuleInfo *MMI, unsigned Encoding,
                        MCStreamer &Streamer) const {

  if (Encoding & dwarf::DW_EH_PE_pcrel) {
    MachineModuleInfoELF &ELFMMI = MMI->getObjFileInfo<MachineModuleInfoELF>();

    //MCSymbol *SSym = getSymbolWithGlobalValueBase(*Mang, GV, ".DW.stub");
    SmallString<60> NameStr;
    Mang->getNameWithPrefix(NameStr, GV, true);
    NameStr.append(".DW.stub");
    MCSymbol *SSym = getContext().GetOrCreateSymbol(NameStr.str());

    // Add information about the stub reference to ELFMMI so that the stub
    // gets emitted by the asmprinter.
    MachineModuleInfoImpl::StubValueTy &StubSym = ELFMMI.getGVStubEntry(SSym);
    if (StubSym.getPointer() == 0) {
      MCSymbol *Sym = getSymbol(*Mang, GV);
      StubSym = MachineModuleInfoImpl::StubValueTy(Sym, !GV->hasLocalLinkage());
    }

    MCContext &Ctx = getContext();
    return SparcMCExpr::Create(SparcMCExpr::VK_Sparc_R_DISP32,
                               MCSymbolRefExpr::Create(SSym, Ctx), Ctx);
  }

  return TargetLoweringObjectFileELF::
    getTTypeGlobalReference(GV, Mang, MMI, Encoding, Streamer);
}
