/*-
 * Copyright 2001 David E. O'Brien
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of additional contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

 	.file	"crti.S"

	/* The minimum stack frame size (bytes) is:
	 *	16 extended words for saving the current register window,
	 *	1 extended word for "hidden parameter",
	 *	6 extended words in wihch a callee can store its arguments
	 *	("The SPARC Architecure Manual" by  Weaver & Germond)
	 * This gives 184 bytes.  However we must round up to an extended
	 * word boundary, thus 192 bytes.
	 * (if we weren't v9, it would be 96 bytes rather than 192)
	 */
	
	.section .init,"ax",@progbits
	.align	4
	.globl	_init
	.type	_init,#function
_init:
	save %sp,-192,%sp


	.section .fini,"ax",@progbits
	.globl	_fini
	.type	_fini,#function
	.align	4
_fini:
	save %sp,-192,%sp


	.section .rodata
.ascii "$FreeBSD: stable/7/lib/csu/sparc64/crti.S 85612 2001-10-28 00:20:34Z obrien $\0"
