/*
 * Copyright (c) 1995 Christopher G. Demetriou
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Christopher G. Demetriou
 *	for the NetBSD Project.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *	$NetBSD: fpsetround.c,v 1.1 1995/04/29 05:09:57 cgd Exp $
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: stable/5/lib/libc/alpha/gen/fpsetround.c 127091 2004-03-16 20:42:02Z des $");

#include <sys/types.h>
#include <ieeefp.h>
#include <machine/fpu.h>

fp_rnd_t
fpsetround(rnd_dir)
	fp_rnd_t rnd_dir;
{
	union {
		double fpcrval;
		u_int64_t intval;
	} u;
	u_int64_t old, new;

	GET_FPCR(u.fpcrval);

	old = u.intval;
	new = old & (~FPCR_DYN_MASK);
	new |= ((long) rnd_dir << FPCR_DYN_SHIFT) & FPCR_DYN_MASK;

	u.intval = new;
	SET_FPCR(u.fpcrval);

	return ((old & FPCR_DYN_MASK) >> FPCR_DYN_SHIFT);
}
