/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.exchange;

import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.exchange.AbstractMessage;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.TransportManager;

public class MessageExchange {
    private OperationInfo operation;
    private MessageContext context;
    private InMessage inMessage;
    private OutMessage outMessage;
    private AbstractMessage faultMessage;
    private boolean hasOutput = false;
    private boolean hasInput = true;
    private boolean hasFault = true;

    public MessageExchange(MessageContext context) {
        this.context = context;
        if (context.getExchange() != null) {
            this.setInMessage(context.getExchange().getInMessage());
        }
        context.setExchange(this);
    }

    public MessageContext getContext() {
        return this.context;
    }

    public OperationInfo getOperation() {
        return this.operation;
    }

    public void setOperation(OperationInfo operation) {
        this.operation = operation;
        this.hasOutput = operation.hasOutput();
        this.hasInput = operation.hasInput();
    }

    public InMessage getInMessage() throws UnsupportedOperationException {
        return this.inMessage;
    }

    public OutMessage getOutMessage() {
        if (this.outMessage == null && this.hasOutMessage()) {
            this.outMessage = new OutMessage("urn:xfire:channel:backchannel");
            this.outMessage.setChannel(this.getOutChannel());
            this.outMessage.setSoapVersion(this.getInMessage().getSoapVersion());
            this.setOutMessage(this.outMessage);
        }
        return this.outMessage;
    }

    public AbstractMessage getFaultMessage() throws UnsupportedOperationException {
        if (this.faultMessage == null && this.hasFaultMessage()) {
            this.faultMessage = new OutMessage("urn:xfire:channel:backchannel");
            this.faultMessage.setChannel(this.getFaultChannel());
            this.faultMessage.setSoapVersion(this.getInMessage().getSoapVersion());
            this.setFaultMessage(this.faultMessage);
        }
        return this.faultMessage;
    }

    public void setFaultMessage(AbstractMessage faultMessage) {
        this.faultMessage = faultMessage;
    }

    public void setInMessage(InMessage inMessage) {
        this.inMessage = inMessage;
    }

    public void setOutMessage(OutMessage outMessage) {
        this.outMessage = outMessage;
    }

    public boolean hasFaultMessage() {
        return this.hasFault;
    }

    public boolean hasInMessage() {
        return this.hasInput;
    }

    public boolean hasOutMessage() {
        return this.hasOutput;
    }

    public Channel getInChannel() {
        if (this.hasInMessage()) {
            return this.getInMessage().getChannel();
        }
        return this.getDeadLetterChannel();
    }

    public Channel getOutChannel() {
        if (this.hasOutMessage()) {
            return this.getInMessage().getChannel();
        }
        return this.getDeadLetterChannel();
    }

    public Channel getFaultChannel() {
        if (this.hasFaultMessage()) {
            return this.getInMessage().getChannel();
        }
        return this.getDeadLetterChannel();
    }

    public Channel getDeadLetterChannel() {
        TransportManager tm = this.getContext().getXFire().getTransportManager();
        Transport transport = tm.getTransport("dead-letter-transport");
        try {
            return transport.createChannel();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setHasFault(boolean hasFault) {
        this.hasFault = hasFault;
    }

    public void setHasInput(boolean hasInput) {
        this.hasInput = hasInput;
    }

    public void setHasOutput(boolean hasOutput) {
        this.hasOutput = hasOutput;
    }
}

