/************************************************************************
			   3DPath v1.00

		      Copyright (c) 1994 by
       Keith Vertanen, Scott Perowitz & Aleksey Przhelyaskovskiy

	  Contact authors before distributing modified copies

************************************************************************/

#include <iostream.h>
#include <fstream.h>
#include <strstream.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <locale.h>
#include <stdio.h>
#include <math.h>      // for sqrt()
#include "spline.cxx"

#define BOB '\0'
#define VER "v1.01linux"
#define ERR1 "\nERROR: You must specify names of a point and a script files.\n\n"
#define ERR2 "\nERROR: Invalid option.\n\n"
#define ERR3 "\nERROR: File name must be specified.\n\n"
#define ERR4 "\nERROR: Number of frames should be specified.\n\n"
#define ERR5 "\nERROR: Cannot open script file: "
#define ERR6 "\nERROR: Not enough control points for cubic spline.\n\n"
#define ERR7 "\nERROR: No location section.\n\n"
#define ERR8 "\nERROR: No closing '>' in location section.\n\n"
#define ERR9 "\nERROR: No look_at section.\n\n"
#define ERR10 "\nERROR: No closing '>' in look_at section.\n\n"
#define ERR11 "\nERROR: Invalid example batch file.\n\n"
#define ERR12 "\nERROR: Cannot open example file: "
#define ERR13 "\nERROR: Not enough control points for spline.\n\n";
#define ERR14 "\nERROR: Could Not open control points file: "

void show_help();  // display command line help
void read_command_line(int argc, char *argv[], int *num_frames,
			int *degree, int *view, int *test_script, int *batch,
			char point_file[40], char script_file[40],
			char out_file[40], char override_file[40],
			char example_file[40], char static_look_at[40]) ; //parse the command line
int find_length(char *open_file);   // gets # of lines in a file
void read_points(char point_file[40], point *control,
		 int *num_control, int *closed); // read the control points into array
int search(char *text, char *pattern); // find position of pattern in text
void int_to_str(char text[5], int num); // convert int to string
void do_script(char script_file[40], char override_file[40],
	point *position, int num_frames, char static_look_at[40],
	int closed);
void make_test_script(char script_file[40],char override_file[40],
			point *position,int num_frames);

void main(int argc, char *argv[])
{
  char point_file[40],
       script_file[40],
       out_file[40],
       override_file[40],
       example_file[40];
  int num_frames,
      num_control=0,
      degree=3,
      view=0,
      test_script=0,
      batch=0,
      closed=0,
      j;

  point *control_points, *position;
  char static_look_at[40];

  for (j=0; j<40; j++)           // null all the filename arrays
  {
    point_file[j]= BOB;
    script_file[j]=BOB;
    out_file[j]=BOB;
    override_file[j]=BOB;
    example_file[j]=BOB;
    static_look_at[j]=BOB;
  }
  strcpy(example_file, "3dsample.bat");

  // get all the filenames and options from the command line

  read_command_line(argc,argv,&num_frames,&degree,&view,&test_script,
			&batch,point_file,script_file,out_file,
			override_file,example_file,static_look_at);
  // allocate the control array and read it from the point file
  num_control=find_length(point_file);
  if (num_control<=degree)
  {
    cout << ERR13;
    exit(-1);
  }
  control_points=new point[num_control+1];

  read_points(point_file, control_points, &num_control, &closed);

  // allocate the position array and calculate it from the bspline
  if (closed)        // add an extra if closed since we'll drop the duplicate last point
	{
    	num_frames++;
	}
  position=new point[num_frames];
  bspline(num_control-1,degree+1,control_points,position,num_frames);

  if (test_script)    // does user want just a test script generated
  {
    make_test_script(script_file,override_file,position,num_frames);
  }
  else
  {

      do_script(script_file,override_file,position,num_frames,
		static_look_at,closed);
 }
}

void show_help()
{
    cout << "Path3D " << VER << " Copyright (c) 1994 by\n";
    cout << "Keith Vertanen, Scott Perowitz & Aleksey Przhelyaskovskiy\n";
    cout << "LINUX port by Tracy Camp send bugs to: camp@industrial.com 1996\n";
    cout << "=================================================================\n";
    cout << "Command line:\n";
    cout << "  path3d  pointfile[.3d]  scriptfile[.pov]\n\n";

    cout << "Optional switches:\n";
    cout << "  -f(# frames) how many frames to generate (default 100)\n";
    cout << "  -p(#)        degree of polynomial for spline (default 3)\n";
    cout << "  -l(x,y,z)    use static look_at vector of x,y,z (i.e. -l100,50,25)\n";
    cout << "  -t           create test script with path as spheres\n";
}


void read_command_line(int argc, char *argv[], int *num_frames,
			int *degree, int *view, int *test_script,
			int *batch,char point_file[40],
			char script_file[40],char out_file[40],
			char override_file[40],char example_file[40],
			char static_look_at[40])
{
  int i,j,k,l;
  int found;

  // if # of arguments < 2, print help screen & exit
  if (argc <= 2)
  {
    show_help();
    // this line should be changed to the call to a help screen
    exit(-1);
  } //if


  *num_frames=-1;

  // go through the arguments
  for (i=1; i < argc; i++)
  {
    switch (i)
    {
      case  1:
	  {
	    found=0;
	    for (j=0; j<strlen(&argv[i][0]) && j<39; j++)
	    {
	      point_file[j]=argv[i][j];
	      if (argv[i][j]=='.')
		found=1;
	    }
	    if ((!found) && (j<37))              // if no extension, add .3D
	    {
	      point_file[j]='.';
	      j++;
	      point_file[j]='3';
	      j++;
	      point_file[j]='d';
	    }
	  }
	break;
      case  2:
	  {
	    found=0;
	    for (j=0; j<strlen(&argv[i][0]) && j<39; j++)
	    {
	      script_file[j]=argv[i][j];
	      if (argv[i][j]=='.')
		found=1;
	    }
	    if ((!found) && (j<37))             // if no extension, add .POV
	    {
	      script_file[j]='.';
	      j++;
	      script_file[j]='p';
	      j++;
	      script_file[j]='o';
	      j++;
	      script_file[j]='v';
	    }

	  }
	break;
     case  3:
     case  4:
     case  5:
     case  6:
	  if (((argv[i][0] == '-') || (argv[i][0] == '/'))  // create test script
		    && (argv[i][1] == 't' ))
	  {
	    *test_script=1;
	    break;
	  } // if

	  if (((argv[i][0] == '-') || (argv[i][0] == '/'))  // static look_at vector
		    && (argv[i][1] == 'l' ))
	  {
	      for (j=0; j<strlen(&argv[i][2]); j++)
		static_look_at[j]=argv[i][j+2];
	    break;
	  } // if

	  if (((argv[i][0] == '-') || (argv[i][0] == '/'))
		    && (argv[i][1] == 'p' ))
	  {
	      *degree = atoi(&argv[i][2]);
	      if (atoi (&argv[i][2]) == 0)
		*degree=3;
	    break;
	  } // if

	  if (((argv[i][0] == '-') || (argv[i][0] == '/'))
		    && (argv[i][1] == 'o' ))
	  {
	      for (j=0; j<strlen(&argv[i][2]) && argv[i][j+2]!='.'; j++)
		override_file[j]=argv[i][j+2];
	      if (&argv[i][2] == BOB)
	      {
		cout << ERR3;
		show_help();
		exit(-1);
	      }
	    break;
	  } // if

	  if (((argv[i][0] == '-') || (argv[i][0] == '/'))
		    && (argv[i][1] == 'f' ))
	  {
	      *num_frames = atoi(&argv[i][2]);
	      if (atoi (&argv[i][2]) == 0)
	      {
		*num_frames=-1;
	      }
	    break;
	  } // if

      default:
	  cout << ERR2 << argv[i];
	  show_help();
	  exit(-1);
	break;
    } // switch
  } //for

  cout << "\n/// Path3D " << VER << " /// \n";
  cout << "Copyright (c) 1994 by Keith Vertanen, Scott Perowitz & Aleksey Przhelyaskovskiy\n\n";
  cout << "LINUX port by Tracy Camp send bugs to: camp@industrial.com 1996\n";

  if (*num_frames<0)    // if no -f specified
  {
    cout << "No frame number specified, defaulting to 100.\n";
    *num_frames=100;
  }
}

int find_length(char *open_file)
{
  int num_lines=0;
  int flag = 1;
  int len = 255;
  char line[256];
  FILE *source;

  if(source = fopen(open_file,"r"))
	{
	while(flag == 1)
		{
		fgets(line,len,source);
        	if ((line[0]!='#') && (strlen(line)>1))
			{
			num_lines++;
			}
		if(feof(source) > 0)
			{
			flag = 0;
			break;
			}
		}
	fclose(source);
        }
   else
	{
	cout << ERR14 << open_file << endl;
	exit(-1);
	}
    return num_lines;
}

void read_points(char *point_file, point *control, int *num_lines,
		 int *closed)
{
  int i;
  char line[256];
  double x,y,z;
  int len=255;
  FILE *source;

  if(source = fopen(point_file,"r"))
  {
    i=0;
    while (i<(*num_lines))
    {
      fgets(line,len,source);
      if ((line[0]!='#') && (strlen(line)>1))
      {
	istrstream ins(line,strlen(line));
	ins >> x >> y >> z;
	(control[i]).x=x;
	(control[i]).y=y;
	(control[i]).z=z;
	i++;
      }
    }
  }
  else
  {
    cout << ERR14 << point_file << "\n";
    exit(-1);
  }
  if ((control[i-1].x==control[0].x) &&
     (control[i-1].y==control[0].y) &&
     (control[i-1].z==control[0].z))    // if first pt = last pt, insert smoothing point
  {
    double dx,dy,dz;
    control[i].x=control[i-1].x;   // copy last point down one
    control[i].y=control[i-1].y;
    control[i].z=control[i-1].z;
    dx=control[1].x-control[0].x;
    dy=control[1].y-control[0].y;
    dz=control[1].z-control[0].z;
    control[i-1].x=control[0].x-dx;
    control[i-1].y=control[0].y-dy;
    control[i-1].z=control[0].z-dz;
    *num_lines=*num_lines+1;  // pass back that we have one more control point
    cout << "Closed path detected, inserting control point to smooth.\n";
    *closed=1;
  }
}

int search(char *text, char *pattern)
{
  int i, j, M, N;

  M=strlen(pattern);
  N=strlen(text);

  for (i=0, j=0; j<M && i<N; i++, j++)
  {
    if (toupper(text[i])!=toupper(pattern[j]))
    {
      j=-1;
    }
  }
  if (j==M) return i-M; else return i;
};

void int_to_str(char text[6], int num)
{
  // there has got to be a bloody primitive for this...  what is it???
  int i, a, j=0;
  int e=10000;

  for (i=0; i<5; i++)
  {
    a=num/e;
    if ((a>0) || (j>0))  // no leading zeros wanted
    {
      switch (a)
      {
	case 0 : { text[j]='0'; break; }
	case 1 : { text[j]='1'; break; }
	case 2 : { text[j]='2'; break; }
	case 3 : { text[j]='3'; break; }
	case 4 : { text[j]='4'; break; }
	case 5 : { text[j]='5'; break; }
	case 6 : { text[j]='6'; break; }
	case 7 : { text[j]='7'; break; }
	case 8 : { text[j]='8'; break; }
	case 9 : { text[j]='9'; break; }
      }
      j++;
      num=num-(e*a);
    }
    e=e/10;
  }
  for (i=j; i<6; i++)
    text[i]=BOB;
}

void do_script(char script_file[40], char override_file[40],
		point *position, int num_frames, char static_look_at[40],
		int closed)
{
  int current_frame, end_camera, i = 0;
  int begin_camera_pos;
  int begin_location, end_location, begin_look_at, end_look_at = 0;
  int begin_location_pos, end_location_pos, begin_look_at_pos, end_look_at_pos = 0;
  int j;
  char ch, insertion[200];
  char x[16];
  double xt,yt,zt;
  FILE *script;

 if(script = fopen(script_file,"r"))
  {
    int len=255;
    char stop='\n';
    char line[256];
    char *ptr;
    char a='>';

    // We will now find, with surgical precision, the line number and
    // position of the location and look_at keywords in the camera section
    // of the script file.  NOTE: location must precede look_at or else

    while (feof(script)==0)  // search the file to find the location of camera section
    {
      fgets(line,len,script);
      begin_camera_pos=search(line,"camera");
      if (begin_camera_pos<strlen(line))
      {
	begin_camera_pos++;
	begin_location_pos=search(line,"location");
	while (begin_location_pos>=strlen(line))
	{
	  if (feof(script))
	  {
	    cout << ERR7;
	    exit(-1);
	  }
	  fgets(line,len,script);

	  begin_location_pos=search(line,"location");
	  i++;
	}
	begin_location=i+1;
	begin_location_pos++;
	ptr=strchr(line,a);
	while (!ptr)
	{
	  if (feof(script))
	  {
            cout << ERR8;
	    exit(-1);
	  }
	  fgets(line,len,script);
	  ptr=strchr(line,a);
	  i++;
	}
	end_location_pos=ptr-line+1;
	end_location=i+1;

	begin_look_at_pos=search(line,"look_at");
	while (begin_look_at_pos>=strlen(line))
	{
	  if (feof(script))
	  {
            cout << ERR9;
	    exit(-1);
	  }
	  fgets(line,len,script);
	  begin_look_at_pos=search(line,"look_at");
	  i++;
	}
	begin_look_at=i+1;
	begin_look_at_pos++;
	ptr=strchr(line,a);
	while (!ptr)
	{
	  if (feof(script))
	  {
	    cout << ERR10;
	    exit(-1);
	  }
	  fgets(line,len,script);
	  ptr=strchr(line,a);
	  i++;
	}
	end_look_at_pos=ptr-line+1;
	end_look_at=i+1;
	break;
      }
      i++;
    }
    fclose(script);

    // okay, lets make the actual files
    char our_name[40];

    for (i=0; i<40; i++) // blank out the array
      our_name[i]=BOB;

    if (strlen(override_file)==0)     // did the user give us an override name
    {
      i=0;
      while (i<40 && script_file[i]!='.')
      {
	our_name[i]=script_file[i];
	i++;
      }
    }
    else
    {
      i=0;
      while (i<40 && override_file[i]!='.')
      {
	our_name[i]=override_file[i];
	i++;
      }
    }

    ofstream output;
    char numstr[6];
    char numstr2[6];
    char open_name[40];

    int_to_str(numstr,num_frames);

    j=strlen(our_name)-1;
    while ((j>=0) && (our_name[j]!='\\'))
      j--;

    int_to_str(numstr2,num_frames);

    // here is the loop that actually generates the output script files
    cout << "Generating frame #\n";

    if (closed)      // if smooth closed path, don't double up the first and last frames
      num_frames--;

// start of loop
    for (i=1; i<=num_frames; i++)
    {
      cout << i << endl;
      int_to_str(numstr,i);
      strcpy(open_name,our_name); // copy our_name
      for (j=0; j<strlen(numstr2)-strlen(numstr); j++)  // add leading zeros
	strcat(open_name,"0");
      strcat(open_name,numstr);   // put the number suffix on
      strcat(open_name,".pov");   // put the .POV extension on

      output.open(open_name);     // open up output file

      script = fopen(script_file,"r");
      for (j=1; j<begin_location; j++)        // get to location line
      {
	 fgets(line,len,script);
	 output.write(line,strlen(line));
	 output.put('\n');
      }
      for (j=1; j<begin_location_pos; j++)   // get to location position
      {
	ch = fgetc(script);
	output.put(ch);
      }
      for (j=0; j<200; j++)
	{
	insertion[j]=BOB;
	}

      xt=0;
      yt=0;
      zt=0;

      xt=position[i-1].x;
      yt=position[i-1].y;
      zt=position[i-1].z;

      sprintf(insertion, "location <%.6f,%.6f,%.6f>", xt, yt, zt);

      output.write(insertion,strlen(insertion));

      if (begin_location!=end_location)  // if closure on different line
      {
	for (j=begin_location; j<end_location; j++)
		{
	        fgets(line,len,script);
		}
	begin_location_pos=1;
      }

      for (j=begin_location_pos; ch!='\n'; j++) // get to end of location line
      {
	if (j>end_location_pos)
		{
		ch = fgetc(script);
//	  	output.put(ch);
		}
      }

      for (j=end_location+1; j<begin_look_at; j++)   // get to look_at line
      {
	 fgets(line,len,script);
	 output.write(line,strlen(line));
	 output.put('\n');
      }
      for (j=1; j<begin_look_at_pos; j++)   // get to look_at position
      {
	ch = fgetc(script);
	output.put(ch);
      }
      for (j=0; j<200; j++)
	{
	insertion[j]=BOB;
	}

      if (strlen(static_look_at)>0)
      {
	strcpy(insertion, "look_at <");
	strcat(insertion,static_look_at);
	strcat(insertion,">");
      }
      else
      {
	if (i<num_frames)
	{
	  xt=position[i].x;
	  yt=position[i].y;
	  zt=position[i].z;
	}
	else
	{
	  xt=2*position[i-1].x-position[i-2].x;
	  yt=2*position[i-1].y-position[i-2].y;
	  zt=2*position[i-1].z-position[i-2].z;
	}
	sprintf(insertion, "look_at <%.6f,%.6f,%.6f>", xt, yt, zt);
      }
      output.write(insertion,strlen(insertion));

      if (begin_look_at!=end_look_at)  // if closure on different line
      {
	for (j=begin_look_at; j<end_look_at; j++)
		{
	  	fgets(line,len,script);
		}
      }

      ch=BOB;
      for (j=begin_look_at_pos; ch!='\n'; j++) // get to end of look_at line
      {
	ch = fgetc(script);
	if (j>end_look_at_pos)
	 {
	  output.put(ch);
	 }
      }
      while (!feof(script))
      {
	 fgets(line,len,script);
	 output.write(line,strlen(line));
	 output.put('\n');
      }

      fclose(script);
      output.close();
    }
    cout << "\n";
  }
  else
  {
    cout << "\nERROR: Cannot open script file: " << script_file << "\n";
    exit(-1);
  }
}


void make_test_script(char script_file[40],char override_file[40],
			point *position,int num_frames)
{
  char our_name[40];
  int i,j;
  double x,y,z;
  double x2,y2,z2;
  double radius;
  char *t;
  char insertion[255];

  strcpy(our_name,script_file);

  i=strlen(our_name)-1;            // backup to beginning of filename
  while ((our_name[i]!='\\') && (i>0))
    i--;
  j=0;
  while ((our_name[i]!='.') && (strlen(our_name) != i))
  {
    i++;
    j++;
  }
  our_name[i]='.';
  i++;
  our_name[i]='3';
  i++;
  our_name[i]='d';
  i++;
  our_name[i]='.';
  i++;
  our_name[i]='p';
  i++;
  our_name[i]='o';
  i++;
  our_name[i]='v';
  i++;

  for (j=i; j<40; j++)
	{
    	our_name[j]=BOB;
	}

FILE *input;

  if (input = fopen(script_file, "r"))
  {
  cout << "Creating test script file: " << our_name << "\n";
  ofstream output;
  output.open(our_name);      // open up output file

  int len=255;
  char stop='\n';
  char line[256];

  while (!feof(input))  // copy the whole script file intact
  {
    fgets(line,len,input);
    output.write(line,strlen(line));
    output.put('\n');
  }
  fclose(input);
  radius=0;
  for (i=0; i<num_frames; i++)
  {
    x=position[i].x;
    y=position[i].y;
    z=position[i].z;

    if (i+1==num_frames)
    {
      x2=position[i-1].x;
      y2=position[i-1].y;
      z2=position[i-1].z;

    }
    else
    {
      x2=position[i+1].x;
      y2=position[i+1].y;
      z2=position[i+1].z;
    }
    radius=radius+sqrt((x-x2)*(x-x2)+(y-y2)*(y-y2)+(z-z2)*(z-z2));
  }
  radius=radius/num_frames;

  for (i=0; i<num_frames; i++)
  {
    x=position[i].x;
    y=position[i].y;
    z=position[i].z;

    sprintf(insertion, "sphere { <%.6f,%.6f,%.6f>%.6f", x, y, z, (radius*0.9));

    output.write(insertion,strlen(insertion));

    strcpy(insertion,"  pigment {color Red} }\n");
    output.write(insertion,strlen(insertion));
  }
  }
  else
  {
    cout << ERR5 << script_file << "\n";  // couldn't open script file
    exit(-1);
  }
}



