/* html-strip - a small utility to strip HTML tags out of a text file.
 * Written & tested on a Linux system but should compile OK with any ANSI-
 * compliant C compiler.
 * 
 * Copyright (c) 1996 Adam Lloyd. */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define TRUE 1
#define FALSE 0

FILE *inFile,*outFile;
char out_name[63];          /* name for the temporary output file */

void display_help(void);
void perform_html_strip(void);

int main(int argc,char *argv[])
{
   int theChar;
   
   if(argc!=2) {
      fprintf(stderr,"usage: html-strip <in-file>\n");
      fprintf(stderr,"For help type 'html-strip -h'\n");
      exit(-1);
   }
   
   if(!strcmp(argv[1],"-h")) display_help();
   
   inFile=fopen(argv[1],"rb");
   if(!inFile) {
      fprintf(stderr,"html-strip: could not open input file (%s)\n",argv[1]);
      exit(-1);
   }
   
   /* If we get here, the parameter list was correct and the input file has
    * been opened successfully. We must now open a temporary output file. */
   
   if(!tmpnam(out_name)) {
      fprintf(stderr,"html-strip: could not create temporary file\n");
      fclose(inFile);
      exit(-1);
   }
   
   /* Now we have the name we can open the file. */
   if(!(outFile=fopen(out_name,"wb"))) {
      fprintf(stderr,"html-strip: %s could not be opened for output\n",
	      out_name);
      fclose(inFile);
      exit(-1);
   }
   
   /* Once we've got here we have a file pointer to the input file and
    * to an output file. The next step is to process the file. */
   
   perform_html_strip();
   
   /* Close the files, delete the original and rename the new one. */
   fclose(outFile);
   fclose(inFile);
   remove(argv[1]); /* argv[1] holds the input name - delete that file */
   rename(out_name,argv[1]); /* rename the new file with the old file's name */
   
   return 0;
}

/* Display help for the program. */
void display_help(void)
{
   printf("\nhtml-strip v0.0d1: Copyright (c) 1996 Adam Lloyd.\n\n");
   printf("html-strip is a small utility that takes an HTML file and strips all\n");
   printf("the HTML tags out of it. It's not 100%% foolproof, but does the job most\n");
   printf("of the time and is fairly simple to use: 'html-strip <in-file>' is all \n");
   printf("you need to type, where <in-file> is the name of your input HTML file.\n");
   printf("Please note that html-strip overwrites the original file.\n\n");
   printf("Comments, etc. to adam@park78.demon.co.uk.\n\n");
   exit(0);
}

/* Do the actual processing of the file (ie: remove all HTML tags). */
void perform_html_strip(void)
{
   int the_char;
   char write_enable; /* flag to indicate if we are to write or not */
   
   write_enable=TRUE;
   
   the_char=fgetc(inFile);
   while(!feof(inFile)){
      if(the_char=='<') write_enable=FALSE;
      if(write_enable==TRUE) {
	 fputc(the_char,outFile);
      }
      if(the_char=='>') write_enable=TRUE;
      the_char=fgetc(inFile);
   }
   
}
