/*
 * Copyright (C) 2000, 2001 by Dmitry Morozhnikov, 
 * under the terms of the GNU General Public License, version 2.
 */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <sysexits.h>
#include <errno.h>
#include <assert.h>
#include "datfile2.h"
#include "memofile.h"
#include "datview.h"

static unsigned char *add_memoblk(dat_header_t *h, unsigned char *memo, memo_t *memoblk, 
								  datview_opts_t *opts)
{
	static int memosize;
	static int memolen;
	static int memocutlen;
	int i;
	
	if(memo == NULL)
	{
		memosize = 0;
		memolen = 0;
		memocutlen = 0;
	};
	i = 0;
	while(i < sizeof(memoblk->memo) && memoblk->memo[i])
	{
		if(memolen >= memosize)
		{
			memosize += (10 * sizeof(memoblk->memo));
			memo = (unsigned char *) realloc(memo, memosize);
			assert(memo);
		};
		if(opts->cutmemo && memocutlen == h->memowid)
		{
			if(opts->nostripsp != 1)
			{
				memolen--;
				while(memolen > -1 && memo[memolen] == ' ')
				{
					memo[memolen] = '\0';
					memolen--;
				};
				memolen++;
			};
			memo[memolen] = '\n';
			memolen++;
			memocutlen = 0;
		};
		memocutlen++;
		memo[memolen] = memoblk->memo[i];
		memolen++;
		i++;
	};
	return memo;
};

int memo_info(int fd, datview_opts_t *opts)
{
	int rc;
	memo_header_t memo_header;
	
	rc = lseek(fd, 0, SEEK_SET);
	if(rc == -1)
	{
		fprintf(stderr, "Can`t lseek to memo header: %s\n", strerror(errno));
		exit(EX_DATAERR);
	};
	rc = read(fd, &memo_header, sizeof(memo_header_t));
	if(rc != sizeof(memo_header_t))
	{
		fprintf(stderr, "Can`t read memo header: %s\n", strerror(errno));
		exit(EX_DATAERR);
	};
	printf("memo signature:     0x%04x", memo_header.memsig);
	if(memo_header.memsig == 0x334D)
	{
		printf(", ok\n");
	}
	else
	{
		printf(", WRONG\n");
	};
	printf("first deleted memo: %lu\n", memo_header.firstdel);
	return 0;
};

unsigned char *memo_read(dat_header_t *h, int fd, int memo_no, datview_opts_t *opts)
{
	unsigned char *memo;
	memo_t *memo_buf;
	int memo_len;
	unsigned long offset;
	int rc;
	int cont;
	
	memo_buf = (memo_t *) malloc(sizeof(memo_t));
	assert(memo_buf);
	memo = NULL;
	memo_len = 0;
	offset = ((memo_no - 1) * sizeof(memo_t)) + sizeof(memo_header_t);
	cont = 1;
	while(cont)
	{
		rc = lseek(fd, offset, SEEK_SET);
		if(rc == -1)
		{
			fprintf(stderr, "Can`t lseek to memo: %s\n", strerror(errno));
			exit(EX_DATAERR);
		};
		rc = read(fd, memo_buf, sizeof(memo_t));
		if(rc != sizeof(memo_t))
		{
			fprintf(stderr, "Can`t read memo: %s\n", strerror(errno));
			exit(EX_DATAERR);
		};
		memo_len++;
		memo = add_memoblk(h, memo, memo_buf, opts);
		if(memo_buf->nxtblk != 0)
		{
			offset = ((memo_buf->nxtblk - 1) * sizeof(memo_t)) + sizeof(memo_header_t);
		}
		else
		{
			cont = 0;
		};
	};
	return memo;
};
