/*
 * Copyright (C) 2000, 2001 by Dmitry Morozhnikov, 
 * under the terms of the GNU General Public License, version 2.
 */

/*
 * Info of format from
 * Jerzy Tarasiuk <jt@fuw.edu.pl>
 */

#ifndef _DATFILE2_H
# define _DATFILE2_H

struct _dat_header_t
{
	unsigned short filesig;     /* file signature */
	unsigned short sfatr;	    /* file attribute and status */
	unsigned char numbkeys;     /* number of keys in file */
	unsigned long numrecs;      /* number of records in file */
	unsigned long numdels;      /* number of deleted records */
	unsigned short numflds;	    /* number of fields */
	unsigned short numpics;	    /* number of pictures */
	unsigned short nummars;	    /* number of array descriptors */
	unsigned short reclen;	    /* record length (including record header) */
	unsigned long offset;	    /* start of data area */
	unsigned long logoef;	    /* logical end of file */
	unsigned long logbof;	    /* logical beginning of file */
	unsigned long freerec;	    /* first usable deleted record */
	unsigned char recname[12];  /* record name without prefix */
	unsigned char memnam[12];   /* memo name without prefix */
	unsigned char filpre[3];    /* file name prefix */
	unsigned char recpre[3];    /* record name prefix */
	unsigned short memolen;	    /* size of memo */
	unsigned short memowid;	    /* column width of memo */
	unsigned long reserved;	    /* reserved */
	unsigned long chgtime;	    /* time of last change */
	unsigned long chgdate;	    /* date of last change */
	unsigned short reserved2;   /* reserved */
}
__attribute__ ((packed));
typedef struct _dat_header_t dat_header_t;

struct _dat_field_t
{
	unsigned char fldtype;	    /* type of field */
	unsigned char fldname[16];  /* name of field */
	unsigned short foffset;	    /* offset into record */
	unsigned short length;	    /* length of field */
	unsigned char decsig;	    /* significance for decimals */
	unsigned char decdec;	    /* number of decimal places */
	unsigned short arrnum;	    /* array number */
	unsigned short picnum;	    /* picture number */
}
__attribute__ ((packed));
typedef struct _dat_field_t dat_field_t;

struct _dat_rec_t
{
	unsigned char rhd;		/* record header type and status */
	unsigned long rptr;		/* pointer for next deleted record or memo if active */
}
__attribute__ ((packed));
typedef struct _dat_rec_t dat_rec_t;

# define DAT_SFATR_LOCKED	  (1<<0) /* file is locked */
# define DAT_SFATR_OWNED	  (1<<1) /* file is owned */
# define DAT_SFATR_ENCRYPTED  (1<<2) /* records are encrypted */
# define DAT_SFATR_MEMO		  (1<<3) /* memo file exists */
# define DAT_SFATR_COMPRESS	  (1<<4) /* file is compressed */
# define DAT_SFATR_DELETED	  (1<<5) /* reclaim deleted records */
# define DAT_SFATR_RO		  (1<<6) /* file is read only */
# define DAT_SFATR_CREATED	  (1<<7) /* file may be created */

# define DAT_FLDTYPE_LONG	  1
# define DAT_FLDTYPE_REAL	  2
# define DAT_FLDTYPE_STRING	  3
# define DAT_FLDTYPE_STRINGP  4 /* STRING WITH PICTURE TOKEN */
# define DAT_FLDTYPE_BYTE	  5
# define DAT_FLDTYPE_SHORT	  6
# define DAT_FLDTYPE_GROUP	  7
# define DAT_FLDTYPE_DECIMAL  8

# define DAT_RHD_NEW		  (1<<0) /* new record */
# define DAT_RHD_OLD		  (1<<1) /* old record */
# define DAT_RHD_REVISED	  (1<<2) /* revised record */
# define DAT_RHD_DELETED	  (1<<3) /* deleted record */
# define DAT_RHD_HELD		  (1<<4) /* record held */

#endif /* _DATFILE2_H */
