/******************************************************************************

NAME:
   normalizer.c -- skeleton normalizer code

DESCRIPTION:
   Writing normalizers is easier if you start from this skeleton file.

******************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <ctype.h>
#include <string.h>
#include "shred.h"

static linenum_t linecount;

int normalizer_init(unsigned char *buf)
/* initialize line filtering */
{
    /* option parsing goes here */
}

void normalizer_mode(int mask)
/* set the normalizer mode -- meant to be called at the start of a file scan */
{
    linecount = 0;
}

static int normalize(char *buf)
/* normalize a buffer in place, return 0 if it should be skipped */
{
    return(1);
}

feature_t *normalizer_get(const struct filehdr_t *file, FILE *fp, linenum_t *linenump)
/* get a feature (in this case, a line) from the input stream */
{
    char	buf[BUFSIZ];
    static feature_t	feature;

    while (fgets(buf, sizeof(buf), fp) != NULL)
    {
	int	braceline = 0;

	linecount++;
	if (linecount >= MAX_LINENUM)
	{
	    fprintf(stderr, "comparator: %s too large, only first %d lines will be compared.\n", file->name, MAX_LINENUM-1);
	    break;
	}

	if (!normalize(buf))
	    continue;

	/* maybe we can get the file type from the first line? */
	if (linecount == 1 && buf[0] == '#')
	    if (strstr(buf, "sh"))
	    {
		normalizer_mode(SHELL_CODE);
		linecount = 1;
	    }

	/* time to return the feature */
	feature.text = strdup(buf);
	feature.flags = filter_pass(buf) ? INSIGNIFICANT : 0;
	*linenump = linecount;
	return &feature;
    }

    *linenump = linecount;
    return(NULL);
}

void normalizer_free(const char *text)
/* free a piece of storage previously handed to shredtree */
{
    free((char *)text);
}

void normalizer_dump(char *buf)
/* dump a Normalization line representing current options */
{

}

/* our method table */
struct normalizer_t normalizer =
{
    init: normalizer_init,
    mode: normalizer_mode,
    get:  normalizer_get,
    free: normalizer_free,
    dumpopt: normalizer_dump,
};

/* normalizer.c ends here */
