#include <stdio.h>
#include <string.h>
#include <time.h>

 #include "alphaU.h"
 #include <curses.h>
 #define LIGHTGREEN 1

void printcell(char l, int p, int col,int y);
void scroll_message(char *,int ,int ,int );
void wait_a_bit(void);

char mesg[250];
char tempbuf[250];
char header[] = "           ";

char head = 9;
char tail = 0;

char winbuf[11];

 int x = 1;
 int i,n,m;
 long int d;
 int reg_4x = 0;

main(int argc,char *argv[])
{
 if (argc == 3)
 {
   initscr();
   savetty();
   raw(); 
   nonl();
   start_color();
   init_pair(1,COLOR_GREEN,COLOR_BLACK);
   attrset(COLOR_PAIR(1));
   scroll_message(argv[1],10,atoi(argv[2]),1);  
   resetty();
   endwin();
 }
 else
 perror("usage  matrixU  \" message to display\"  NO_OF_SCROLLS");
   
 return 0;
}





void scroll_message(char *s,int y,int scrolls,int w)
{
    

    strcpy(mesg,s);
    strcpy(tempbuf,header);
    strcat(tempbuf,mesg);
    strcat(tempbuf,header);
    strcpy(mesg,tempbuf);


  while (scrolls > 0)
  {
    head = 9;
    tail = 0;

    while(head <= (strlen(mesg)) -2)
    {

      for(n = tail,i = 0; n <= head ; n++,i++)
      {
	winbuf[i] = mesg[n];

	printcell(winbuf[i],i,LIGHTGREEN,y);
        refresh();
      }

      winbuf[i] = '\0';

      wait_a_bit(); 
         
      head++;
      tail++;
    }
    scrolls--;
  }
}



void printcell(char l, int p,int col,int y)
{
   static short pos[10] = {2,10,18,26,34,42,50,58,66,74};
   int n,s,index;


   l = toupper(l);

   for (n = 0;n <= 7; n++)
     {
       if (l != 32)
       {
	 for(s = 0;s <= 4;s++)
	 {
	 
	 move( (y+n),(pos[p]) +s );
	 

	   if(isalpha(l))
	   {
	     if (cell[l -65][n][s] == '*')
	     {
	      	         
	         addch(ACS_CKBOARD);
	     }
	      else
	      {		
		addch(' ');
	      }
	    }

	    if(isdigit(l))
	    {
	      index = l -48;
	      index = index +27;
	      if (cell[index][n][s] == '*')
	      {	     
	        addch(ACS_CKBOARD);
	      }
	      else
	      {	    	
		addch(' ');
	      }
	    }

	    if(l == '.')
	    {
	      index = 37;

	      if (cell[index][n][s] == '*')
	      {	     	         
	         addch(ACS_CKBOARD);
	      }
	      else
	      {                 				
		addch(' ');
	      }
	    }
	 }
       }
       else
	{      
	 move((y+n),(pos[p]));
	 addstr("     ");
	}     
         move((y+n),(pos[p]));
     }
}



void wait_a_bit(void)
{
  double clocks_per_second = (double) CLOCKS_PER_SEC;
  double t = 0;
  clock_t start,finish;
  start = clock();
  
  while(t < 0.4)
  { 
    finish = clock() ;
    t = (finish - start) / clocks_per_second ;
    
  }  
}   