// SCBIND.C The "compiler" part of the AWC Shell Script Compiler
// Written in 1990 by Al Williams
// Updated 1998 for Linux/ANSI
#include <stdio.h>
#include <string.h>
#include <ctype.h>

char linebuf[8192];
char *decode();
FILE *efopen();

main(int argc,char *argv[])
  {
  FILE *in,*out;
  int first=1;
  int linect=0;
  int n=0;
/* For now first 4 arguments are required */
  if (argc!=5&&argc!=6) help();
  in=efopen(argv[1],"r");
  out=efopen(argv[2],"w");
  strcpy(linebuf,argv[4]);
  while (isspace(*(linebuf+n))) n++;  /* skip spaces */
  if (linebuf[n]!='#' || linebuf[n+1]!='!')
    strcpy(linebuf,"#!/bin/sh");
  else
    while (isspace(*(linebuf+n+2))) n++;
  fprintf(out,"char *shell=\"%s\";\n",linebuf+n+2);
  if (argc==6)
    fprintf(out,"char *opt=\"%s\";\n",argv[5]);
  else
    fprintf(out,"char *opt=(char *)0;\n");
  fprintf(out,"char *name=\"%s\";\n\n",argv[3]);
  fprintf(out,"char lines[]={\n");
  while (!feof(in))
    {
    char *lp;
      lp=fgets(linebuf,sizeof(linebuf),in);
      if (!lp) 
        if (feof(in)) break; else error("input file");
      lp=strchr(linebuf,'\n');
/*      if (!lp) error("Line too long"); */
      *lp='\0';
      lp=decode(linebuf);
      while(*lp)
          { 
          if (linect++>10) { linect=0; fprintf(out,"\n\t"); }
          fprintf(out,"%c%d",first?'\t':',',*lp++);
          first=0;
          }
      fprintf(out,",0");
    }
  fprintf(out,"\n\t};\n\nunsigned linesize=sizeof(lines);\n");
  if (fclose(out)) error("output file");
  exit(0);
  }

help()
  {
  fprintf(stderr,"SCBIND -- shell script binder by Al Williams\n");  
  fprintf(stderr,"Usage: scbind INFILE OUTFILE NAME SHELL [ARG]\n");
  exit(1);
  }

error(char *s)
  {
  perror(s);
  exit(1);
  }

FILE *efopen(char *fn,char *mode)
  {
  FILE *fp;
  if (!(fp=fopen(fn,mode))) error(fn);
  return fp;
  }



















