/*-
 * Copyright (c) 1995, 1998, 2002
 *      Torsten Poulin.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      $Id: line.c,v 1.2 2002/02/21 19:38:35 tp Exp $
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright (c) 1995, 1998, 2002  Torsten Poulin.  All rights reserved.\n";
#endif /* not lint */

#ifndef lint
static char rcsid[] = "$Id: line.c,v 1.2 2002/02/21 19:38:35 tp Exp $";
#endif /* not lint */

#include <stdlib.h>
#include <signal.h>
#include <unistd.h>

#define LINLEN	1024

static char line[LINLEN];

static void 
alarm_handler(int dummy)
{

	exit(1);
}

static void
usage(void)
{

	write(2, "usage: line [-t timeout]\n", 25);
	exit(1);
}

int 
main(int argc, char *argv[])
{
	char	*tval = NULL;
	char	ch;
	char	newline = '\n';
	char	*lp;
	char	*endp;
	int	retval;
	long	secs = 0;

	if (--argc > 0) {
		argv++;
		if (*argv[0] == '-' && argv[0][1] == 't') {
			if (argv[0][2] != '\0')
				tval = &argv[0][2];
			else if (--argc > 0)
				tval = argv[1];
			else
				usage();

			if ((secs = atol(tval)) <= 0) {
				write(2, "line: bad argument\n", 19);
				exit(2);
			}
		} else
			usage();
	}

	if (secs) {
		signal(SIGALRM, alarm_handler);
		alarm(secs);
	}

	retval = 0;
	lp = line;
	endp = lp + LINLEN;
	for (;;) {
		if (read(0, &ch, 1) != 1) {
			ch = '\n';
			retval = 1;
		}
		if (ch == '\n')
			break;
		if (lp == endp) {
			write(1, line, LINLEN);
			lp = line;
		}
		*lp++ = ch;
	}

	write(1, line, lp - line);
	write(1, &newline, 1);

	exit(retval);
}
