.TH line 1 "May 29, 1995" Linux
.SH NAME
line \- read one line from user input
.SH SYNOPSIS
.B line
.RI [ option ]
.SH DESCRIPTION
.B line
copies one line up to a new-line from its standard input and writes it
to its standard output. An exit code of 1 is returned on
.SM EOF
and it always prints at least a new-line.
It can be used in shell scripts to read from the user's terminal.
.SS Options
The following options are accepted
by
.BR line :
.TP
.RI "\-t, \-\-timeout" " timeout"
Timeout after
.I timeout
seconds where
.I timeout
is a positive integer value.
.TP
\-\-help
Print a usage message on standard output and exit successfully.
.TP
\-\-version
Print version information on standard output then exit successfully.
.SS "Compatibility note"
The options are not documented in
.SM POSIX
and other industry standards, and should not be used in portable
applications.
.SH EXAMPLES
The following shell script fragment prompts for a file name and
displays information about the file:
.nf
.IP
echo 'Enter a file name:'
file=`line`
ls \-l $file
.fi
.PP
To limit the response time to, say, 15 seconds, use the following:
.IP
file=`line \-\-timeout 15`
.PP
then test for no response possibly selecting a default behaviour.
.SH "SEE ALSO"
.BR sh (1).
.SH COPYRIGHT
Copyright (C) 1995 Torsten Poulin (torsten@diku.dk).
.\" $Id: line.man,v 1.2 1995/05/29 17:18:55 torsten Exp $
