/*
	seek.h		Char Seek Functions Header
	Copyright (c) 1996-8, 2000 Kriang Lerdsuwanakij
	email:		lerdsuwa@users.sourceforge.net

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __K_SEEK_H
#define __K_SEEK_H

#include "config.h"

USING_NAMESPACE_STD

// nest = 0, no nested " ' `
// nest = 1, nested " ' `
// nest = 2, nested " ' ` with \" \' \` not treated as quotes

int	SeekChar(char c, const char *buffer, int from, int length, int nest = 0);
int	SeekString(const char *str, const char *buffer, int from, int length, int nest = 0);
int	SeekCaseString(const char *str, const char *buffer, int from, int length, int nest = 0);
int	SeekTokenEnd(const char *buffer, int from, int length);
int	SeekConfigTokenEnd(const char *buffer, int from, int length);
int	SeekNonSpace(const char *buffer, int from, int length);
int	SeekPastEqualSign(const char *buffer, int from, int length);

int	IsEmpty(const char *buffer, int from, int length);

#endif	/* __K_SEEK_H */
