/* eo - execute a cmd on each line in a file.
   Tim Ryan tpr@ntrnet.net 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

				    

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fnmatch.h>
#include <unistd.h>

void valid_entry(int argc, char **argv, char *cmd);
void help(void);		
void run_cmd(char *cmd);
void strReplace(char *runner, char *line, char *cmd);

int verbose = 0, interactive = 0, pattern = 0;
FILE *fil;
char patrn[81];

int main(int argc, char **argv)
{
	char cmd[81];

	valid_entry(argc, argv, cmd);
	
	run_cmd(cmd);
	printf("\n"); 
	
	exit(0);
}

void valid_entry(int argc, char **argv, char *cmd)
{
	char c;
	
	if(argc < 2) help();

	while((c = getopt(argc, argv, "hip:v")) != EOF) {
		/* process each leter */
		switch(c){
			case 'v': verbose = 1;
				  break;
			case 'h': help();
				  break;
			case 'i': interactive = 1;
				  break;
			case 'p': pattern = 1;
				  strcpy(patrn, optarg);	  
				  break;
			default: /* unexpected letter */
				  help();
		}
	}
		
	if(optind == (argc - 2)) { /* two args left */
	        fil = fopen(argv[optind], "r");
	        if(!fil) {
			printf("Could not open file %s.\n", argv[1]);
				exit(-1);
		}
		strcpy(cmd, argv[optind+1]);
	}
	else if(optind == (argc - 1)) {
		if(!fil)  fil = stdin;
		strcpy(cmd, argv[optind]);
	}
	else {
		printf("eo: incorect arguments entered.\n");
		help();
	}
}	

void help()		
{
	printf("\nUsage: eo [OPTION]... [FILE] 'COMMAND @'\n");
	printf("Execute COMMAND on list in FILE. The '@' is\n");
	printf("replaced with each line in FILE.\n");
	printf("If FILE is not given use stdin.\n\n");
	printf("     options: -h help\n");
	printf("              -v verbose\n");
	printf("              -i interactive (not with stdin)\n");
	printf("              -p <'pattern'>\n");
	printf("Version 1.3 %s\n", __DATE__);
	printf("Tim Ryan tpr@ntrnet.net\n\n");
	exit(-1);
}

void run_cmd(char *cmd)
{
	char line[256], runner[256];
	int yesno(), flag;
	
	while(fgets(line, sizeof(line), fil)) {
		strReplace(runner, line, cmd);
		flag = 1;
		if(pattern) {
			if(fnmatch (patrn, line, 0)) 
				flag = 0;
		}
		if(verbose && flag) {
			printf("eo: %s\n", runner);
		}
		if(interactive && flag) {
			if(fil == stdin) {
				printf("eo: Can't use -i with stdin.\n");
				help();
			}
			printf("eo: Execute \'%s\'? ", runner);
			if(!yesno()) {
				flag = 0;
			}
		}
		if(flag) system(runner);
	}
}

void strReplace(char *runner, char *line, char *cmd)
{
	 char *buf, cmd2[256];

	 cmd2[0] = '\0';
	 strcpy(runner, cmd);

	 if((buf = strchr(line, '\n'))) buf[0] = '\0';

	 buf = strchr(runner, '@');
	 if(strlen(buf) > 1) {
	 	strcpy(cmd2, &buf[1]);
	 }
	 buf[0] = '\0';
	 strcat(runner, line);
	 strcat(runner, cmd2);
}
