#include "dialog.h"

#include <sys/types.h>
#include <string.h>
#include <errno.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/stat.h>
#include <stdlib.h>

unsigned char dialog_file_result[MAX_LEN + 1];


static char **directories;
static char **fileNames;
static char pwd[1024];
static char filename[1024];
static char currentInput[1024];

static int  dirCount;
static int  file_count;

static int activeDirC = 0;
static int currentFileTop = 0;
static int currentDirTop = 0;
static int activeFileC = 0;
static int activeCount = -1;

static int hscroll;
static int active = 0;
static int mymode = 0;

static bool scanDir(void);
static void fillWindows( WINDOW *win, int height, int width, char **lines, int lineCount);
static void print_line (WINDOW * win, int row, int width, char *line);
static void shell_escape_string(char * string);
static void reverse_escape( char * string);

static WINDOW *dirs,*files;

int dialog_file( const char* title, const char *prompt, int height, int width, int mode, const char *init)
{
	
    int i, x, y, cur_x, cur_y;
    int dir_x,dir_y,dir_width,dir_height;
    int file_x,file_y,file_height,file_width;
    int box_width, box_x, box_y;
    int input_x=0, scroll=0, key=0, button=-1;
    unsigned char *instr = dialog_file_result;

    int buttonStyle;
    int erg = 1;
    char* string_pos = -1;
    int heightDiffer = 0;
    int activeMax = 4;
    chtype activeStyle;
    
    WINDOW *dialog; //, *dirs,*files;
    strcpy(pwd,prompt);
    reverse_escape(pwd);
    mymode = mode;	
    if(mode == 2 || mode == 3){ /* create-file or directory mode */
	heightDiffer = 4;
	activeMax = 5;
    }
    directories = malloc(1024*sizeof(char*));
    fileNames   = malloc(1024*sizeof(char*));
    for(i = 0; i< 1024; i++){
	directories[i] = malloc(1024*sizeof(char));
	fileNames[i]   = malloc(1024*sizeof(char));
    }

    scanDir();

    x = (COLS  - width)  / 2;
    y = (LINES - height) / 2;
    
#ifdef HAVE_NCURSES
   if(use_shadow)
	draw_shadow ( stdscr, y, x, height, width);
#endif


   dir_x      = x + 2;
   dir_y      = y + 3;
   dir_width  = width  / 2 - 3;
   dir_height = height - 6 - heightDiffer;

   file_x      = dir_x + dir_width ;
   file_y      = y + 3;
   file_width  = dir_width;
   file_height = dir_height;

   box_width = width -4;
   box_x = 2;
   box_y = height - 5;

   if( file_x + file_width > width)
	//--file_width;
   dialog = newwin ( height, width, y, x);
   dirs  = subwin( dialog, dir_height-2, dir_width-2, dir_y+1, dir_x+1);
   files = subwin( dialog, file_height-2, file_width-2, file_y+1, file_x+1);
   if( dirs == NULL || files == NULL){
	return 0;
   }
   mouse_setbase(x,y);

   keypad(dialog, TRUE);
   keypad(dirs,   TRUE);
   keypad(files,  TRUE);

   draw_box( dialog, 0, 0, height, width, dialog_attr, border_attr);
   wattrset(dialog,border_attr);
   draw_box( dialog, 3,2,dir_height,dir_width, dialog_attr, dialog_attr); 
   wattrset(dialog,border_attr);
   draw_box( dialog, 3,2+dir_width,file_height,file_width, dialog_attr, border_attr);
    
   if( mode == 2 || mode == 3){
	wattrset(dialog,border_attr);
	draw_box( dialog,  height - 6, 1, 3, width - 2, dialog_attr, border_attr);
   }
   wattrset(dialog,border_attr);
   wmove(dialog,height-3,0);
   waddch(dialog,ACS_LTEE);
   for( i = 0; i < width -2; i++)
	waddch(dialog, ACS_HLINE);
   wattrset(dialog,dialog_attr);
   waddch(dialog,ACS_RTEE);
   wmove(dialog,height-2,1);
   for( i = 0; i < width - 2; i++)
	waddch(dialog,' ');
   if( title != 0){
	wattrset(dialog, title_attr);
	wmove(dialog,0,(width-strlen(title))/2 - 1);
        waddch(dialog,' ');
	waddstr(dialog,title);
  	waddch(dialog,' ');
   }
   wattrset(dialog,title_attr);
   wmove(dialog,2,dir_x-x);
   waddstr(dialog,"Verzeichnisse:");
   wmove(dialog,2,file_x-x);
   waddstr(dialog,"Dateien:");
   if( pwd[0] != '\0'){
	wattrset(dialog,dialog_attr);
	wmove(dialog,1,2);
	waddstr(dialog,prompt);
   }
   if(mode == 2){
	wattrset(dialog,title_attr);
	wmove(dialog,height-7,1);
	waddstr(dialog,"Neues Verzeichnis:");
   }
   if( mode == 3){
	wattrset(dialog,title_attr);
	wmove(dialog,height-7,1);
	waddstr(dialog,"Neue Datei:");
   }
   print_button(dialog,"   OK   ", height -2, width / 3 - 3, FALSE);
   print_button(dialog," CANCEL ", height -2, 2*(width/3) - 4, FALSE);
   wnoutrefresh(dialog);
  
   if( init == NULL)
	   currentInput[0] = '\0';
   else{
	  strcpy(currentInput,init);
	  reverse_escape(currentInput);
   }
   
	if( mode == 2 || mode == 3){
		input_x = strlen(currentInput);
		if( input_x >= box_width){
			scroll=input_x - box_width + 1;
			input_x = box_width - 1;
		}
		
		wattrset(dialog,inputbox_attr);
		wmove(dialog,box_y,box_x);
		waddnstr(dialog,currentInput+scroll,box_width);
	}
   getyx( dialog,cur_y,cur_x);
   wrefresh(dialog);
   fillWindows(dirs,dir_height-2,dir_width-2,directories,dirCount);
   fillWindows(files,file_height-2,file_width-2,fileNames,file_count);
   wrefresh(dirs);
   wrefresh(files);

//   wrefresh(dialog);
   while( (key != ESC)){ // && (key != '\n')){
	key = mouse_wgetch(dialog);
	if( active == 4){
	  switch(key){
            case TAB:
            case KEY_UP:
            case KEY_DOWN:
            case M_EVENT + 'i':
            case M_EVENT + 'o':
            case M_EVENT + 'c':
                break;
            case KEY_LEFT:
                continue;
            case KEY_RIGHT:
                continue;
            case KEY_BACKSPACE:
            case 127:
                if (input_x || scroll) {
                    wattrset (dialog, inputbox_attr);
                    if (!input_x) {
                        scroll = scroll < box_width -1 ?
                            0 : scroll - (box_width - 1);
                        wmove (dialog, box_y, box_x);
                        for (i = 0; i < box_width; i++)
                            waddch (dialog, currentInput[scroll + input_x + i] ?
                                    currentInput[scroll + input_x + i] : ' ');
                        input_x = strlen (currentInput) - scroll;
                    } else
                        input_x--;
                    currentInput[scroll + input_x] = '\0';
                    wmove (dialog, box_y, input_x + box_x);
                    waddch (dialog, ' ');
                    wmove (dialog, box_y, input_x + box_x);
                    wrefresh (dialog);
                }
                continue;
            default:
                if (key < 0x100 && isprint (key)) {
                    if (scroll + input_x < 1024) {
                        wattrset (dialog, inputbox_attr);
                        currentInput[scroll + input_x] = key;
                        currentInput[scroll + input_x + 1] = '\0';
                        if (input_x == box_width - 1) {
                            scroll++;
                            wmove (dialog, box_y, box_x);
                            for (i = 0; i < box_width - 1; i++)
                                waddch (dialog, currentInput[scroll + i]);
                        } else {
                            wmove (dialog, box_y, input_x++ + box_x);
                            waddch (dialog, key);
                        }
                        wrefresh (dialog);
                    } else
                        flash ();       /* Alarm user about overflow */
                    continue;
                }
            }                                                                                                                       
	}
	switch( key){
	   case ' ':
	   case '\n':
		if( active == 0){
			strcpy(filename,pwd);
			if( strcmp(directories[activeDirC],".") != 0){
			 	if( strcmp(directories[activeDirC] , "..") == 0){
					string_pos = strrchr(pwd,'/');
					if( string_pos != NULL){
						strncpy(string_pos,"\0",1);
						if( strlen(pwd) == 0){
							pwd[0] = '/';
							pwd[1] = '\0';
						}
					}
				}
				else{
					strcat(pwd,"/");
					strcat(pwd,directories[activeDirC]);	
				}
				
				if( !scanDir()){
					flash(); /* inform user that sHe has no permission to access this dir */
					strcpy(pwd,filename);
					scanDir();
				}
			}
		}
		else if( active == 1 ){
			if(mode == 0){
				strcat(pwd,"/");
				strcat(pwd,fileNames[activeFileC]);
				strcpy(instr,pwd);
				key = ESC;
				erg = 0;
			}
		}
		else if(active == 2){
			if(mode == 0){
				strcat(pwd,"/");
				strcat(pwd,fileNames[activeFileC]);
			}
			else if(mode == 1){
				strcat(pwd,"/");
				strcat(pwd,directories[activeDirC]);
			}
			else if(mode == 2 || mode == 3){
				strcat(pwd,"/");
				strcat(pwd,currentInput);
			}
			strcpy(instr,pwd);
			erg=0;
			key=ESC;
		}
		else if( active == 3){
			key = ESC;
			erg = 1;
		}
		break;
	   case M_EVENT + 'C':
	   case 'C':
           case 'c':
		key = ESC;
		erg = 1;
		break;
	   case M_EVENT + 'O':
	   case 'O':
	   case 'o':
		if(mode == 0){
			strcat(pwd,"/");
			strcat(pwd,fileNames[activeFileC]);
		}
		else if(mode == 1){
			strcat(pwd,"/");
			strcat(pwd,directories[activeDirC]);
		}
		else if(mode == 2 || mode == 3){
			strcat(pwd,"/");
			strcat(pwd,currentInput);
		}
			strcpy(instr,pwd);
		erg=0;
		key=ESC;
		break;
          case TAB:
		if( mode < 2)
	 	  	active = (++active) % activeMax;
		else{
			if( active == 4)
				active = 2;
			else if( active == 1)
				active = 4;
			else if(active == 3)
				active = 0;
			else
			 	active = ++active % activeMax;
		}
		break;
	  case KEY_UP:
		if(active==0){
			activeDirC = activeDirC == 0 ? activeDirC : --activeDirC;
			currentDirTop = activeDirC - ( activeDirC % (dir_height-2));
			if(mode == 2){
				  strcpy(currentInput,directories[activeDirC]);
				  reverse_escape(currentInput);
				input_x = strlen(currentInput);
				if( input_x >= box_width){
					scroll=input_x - box_width + 1;
					input_x = box_width - 1;
				}
		
				wattrset(dialog,inputbox_attr);
				wmove(dialog,box_y,box_x);
				waddnstr(dialog,currentInput+scroll,box_width);
			}
		}
		else if(active==1){
			activeFileC = activeFileC == 0 ? activeFileC : --activeFileC;
			currentFileTop = activeFileC - ( activeFileC % (dir_height-2));
			if(mode == 3){
				  strcpy(currentInput,fileNames[activeFileC]);
				  reverse_escape(currentInput);
				input_x = strlen(currentInput);
				if( input_x >= box_width){
					scroll=input_x - box_width + 1;
					input_x = box_width - 1;
				}
		
				wattrset(dialog,inputbox_attr);
				wmove(dialog,box_y,box_x);
				waddnstr(dialog,currentInput+scroll,box_width);
			}
		}
		break;
	  case KEY_DOWN:
		if(active==0){
			activeDirC = activeDirC == dirCount - 1 ? activeDirC : ++activeDirC;
			if(mode == 2){
				  strcpy(currentInput,directories[activeDirC]);
				  reverse_escape(currentInput);
				input_x = strlen(currentInput);
				if( input_x >= box_width){
					scroll=input_x - box_width + 1;
					input_x = box_width - 1;
				}
		
				wattrset(dialog,inputbox_attr);
				wmove(dialog,box_y,box_x);
				waddnstr(dialog,currentInput+scroll,box_width);
			}
			currentDirTop = activeDirC - ( activeDirC % (dir_height-2));
		}
		else if(active==1){
			activeFileC = activeFileC == file_count - 1 ? activeFileC : ++activeFileC;
			currentFileTop = activeFileC - ( activeFileC % (dir_height-2));
			if(mode == 3){
				  strcpy(currentInput,fileNames[activeFileC]);
				  reverse_escape(currentInput);
				input_x = strlen(currentInput);
				if( input_x >= box_width){
					scroll=input_x - box_width + 1;
					input_x = box_width - 1;
				}
		
				wattrset(dialog,inputbox_attr);
				wmove(dialog,box_y,box_x);
				waddnstr(dialog,currentInput+scroll,box_width);
			}
		}
		break;
	  case KEY_PPAGE:
	 	if( active==0){
			activeDirC = MAX( 0,(activeDirC-(dir_height-2)));
			currentDirTop = activeDirC - (activeDirC % (dir_height-2));
		}
		else if(active==1){
			activeFileC = MAX( 0,(activeFileC-dir_height-2));
			currentFileTop = activeFileC - (activeFileC % (dir_height-2));
		}
		break;
	  case KEY_NPAGE:
	 	if( active==0){
			activeDirC = MIN( dirCount - 1,(activeDirC+(dir_height-2)));
			currentDirTop = activeDirC - (activeDirC % (dir_height-2));
		}
		else if(active==1){
			activeFileC = MIN( file_count -1,(activeFileC+dir_height-2));
			currentFileTop = activeFileC - (activeFileC % (dir_height-2));
		}
		break;
	  case KEY_HOME:
	 	if( active==0){
			activeDirC = 0;
			currentDirTop = 0;
		}
		else if(active==1){
			activeFileC = 0;
			currentFileTop = 0;
		}
		break;
	  case KEY_END:
	 	if( active==0){
			activeDirC = dirCount -1;
			currentDirTop = activeDirC - (activeDirC % (dir_height-2)); ;
		}
		else if(active==1){
			activeFileC = file_count -1;
			currentFileTop = activeFileC - (activeFileC % (dir_height-2));
		}
		break;
	  case KEY_RIGHT:
	  case KEY_LEFT:
		switch(active){
			case 0:
				active=1;
				break;
			case 1:
				active=0;
				break;
			case 2:
				active=3;
				break;
			case 3:
				active=2;
				break;
			default:
				break;
		}
		break;
	  default:
		break;
	}// switch key

   		draw_box( dialog, 0, 0, height, width, dialog_attr, border_attr);
		activeStyle = active == 0 ? dialog_attr : border_attr;
   		draw_box( dialog, 3,2,dir_height,dir_width, dialog_attr, activeStyle); 
		activeStyle = active == 1 ? dialog_attr : border_attr;
   		draw_box( dialog, 3,2+dir_width,file_height,file_width, dialog_attr, activeStyle); 
   		if( mode == 2 || mode == 3){
			activeStyle = active == 4 ? dialog_attr : border_attr;
			wattrset(dialog,border_attr);
			draw_box( dialog,  height - 6, 1, 3, width - 2, dialog_attr, activeStyle);
		}
  		wattrset(dialog,border_attr);
		wmove(dialog,height-3,0);
		waddch(dialog,ACS_LTEE);
		for( i = 0; i < width -2; i++)
			waddch(dialog, ACS_HLINE);
		wattrset(dialog,dialog_attr);
		waddch(dialog,ACS_RTEE);
		wmove(dialog,height-2,1);
		for( i = 0; i < width - 2; i++)
		 waddch(dialog,' ');
		if( title != 0){
		 wattrset(dialog, title_attr);
		 wmove(dialog,0,(width-strlen(title))/2 - 1);
		 waddch(dialog,' ');
		 waddstr(dialog,title);
	         waddch(dialog,' ');
		}
   wattrset(dialog,title_attr);
   wmove(dialog,2,dir_x-x);
   waddstr(dialog,"Verzeichnisse:");
   wmove(dialog,2,file_x-x);
   waddstr(dialog,"Dateien:");
		if( pwd[0] != '\0'){
	  	 wattrset(dialog,dialog_attr);
		 wmove(dialog,1,2);
		 waddstr(dialog,pwd);
		}
   if(mode == 2 ){
	wattrset(dialog,title_attr);
	wmove(dialog,height-7,1);
	waddstr(dialog,"Neues Verzeichnis:");
   }
   if( mode == 3){
	wattrset(dialog,title_attr);
	wmove(dialog,height-7,1);
	waddstr(dialog,"Neue Datei:");
   }
		buttonStyle = active == 2 ? TRUE : FALSE;
		print_button(dialog,"   OK   ", height - 2, width / 3 - 3, buttonStyle);
		buttonStyle = active == 3 ? TRUE : FALSE;
		print_button(dialog," CANCEL ", height -2, 2*(width/3) - 4, buttonStyle);
	fillWindows( dirs,dir_height-2,dir_width-2,directories,dirCount);
	fillWindows( files, file_height-2, file_width-2,fileNames,file_count);
	if( mode == 2 || mode == 3){
		wattrset(dialog,inputbox_attr);
		wmove(dialog,box_y,box_x);
		waddnstr(dialog,currentInput+scroll,box_width);
	}
   }//while key
   delwin(dirs);
   delwin(files);
   for( i = 0; i < 1024; i++){
	free(directories[i]);
	free(fileNames[i]);
   }
   free(directories);
   free(fileNames);
   delwin(dialog);
   shell_escape_string(instr);
   return erg;
}


static bool scanDir(void){
	struct dirent **nameList = 0;
	struct dirent *file;
	int fileCount = 0,i=0;
	struct stat fileStats;

	gid_t myGid;
	uid_t myUid;
	stat(pwd,&fileStats);
	myGid = getgid();
	myUid = getuid();
	if( fileStats.st_uid != myUid){
		if( fileStats.st_gid != myGid){
			if(! ( (fileStats.st_mode & S_IROTH) && (fileStats.st_mode & S_IXOTH)))
				return FALSE;
		}
		else
			if(! ( (fileStats.st_mode & S_IRGRP) && (fileStats.st_mode & S_IXGRP)))
				return FALSE;
	}
	else if(! ( (fileStats.st_mode & S_IRUSR) && (fileStats.st_mode & S_IEXEC)))
		return FALSE;
	fileCount  = scandir( pwd,&nameList,0,alphasort);
	
	dirCount   = 0;
	file_count = 0;
	activeFileC = 0;
	activeDirC  = 0;
	currentDirTop = 0;
	currentFileTop = 0;
	while( i < fileCount){
		file = nameList[i];
		filename[0] = '\0';
		strcat(filename,pwd);
		strcat(filename,"/");
		strcat(filename,file->d_name);
		if( stat(filename,&fileStats) == 0){
			if( S_ISDIR(fileStats.st_mode)){ // & S_IFDIR) && !(fileStats.st_mode & S_IFREG)){
				strcpy(directories[dirCount],file->d_name);
				++dirCount;
			}
			else if( S_ISREG(fileStats.st_mode)){
				strcpy(fileNames[file_count],file->d_name);
				++file_count;
			}
		}
		i++;
	}
	free(nameList);	
	return TRUE;
}


static void fillWindows( WINDOW *win, int height, int width, char **lines, int lineCount){
	int count = 0;
	int current;
	if((active == 0 || mymode == 1) && win == dirs){
		activeCount = activeDirC - currentDirTop;
	}
	else if((mymode == 0 || mymode == 3) && win == files){
		activeCount = activeFileC - currentFileTop;
	}
	else
		activeCount = -1;

	current = win==dirs ? currentDirTop : currentFileTop;	
	while( count < lineCount && count < height){
		print_line(win,count,width,lines[count+current]);
		++count;
	}
}

static void
print_line (WINDOW * win, int row, int width, char *line)
{
    int i, y, x;
    wmove (win, row, 0);        /* move cursor to correct line */

    if(row!=activeCount)
	    wattrset(win, item_attr);
    else
	    wattrset(win,item_selected_attr);
    waddch (win, ' ');
#ifdef HAVE_NCURSES
    waddnstr (win, line, MIN (strlen (line), width - 2));
#else
    line[MIN (strlen (line), width - 2)] = '\0';
    waddstr (win, line);
#endif
 
    getyx (win, y, x);
    /* Clear 'residue' of previous line */
    for (i = 0; i < width - x; i++)
        waddch (win, ' ');
}

void shell_escape_string( char * string){
	char temp[1024];
	int i,j, length;
	length=strlen(string);
	for( i = 0, j = 0;  (i < length); i++,j++){
		if( string[i] == '&' ||
		    string[i] == ' ' ||
		    string[i] == '[' ||
		    string[i] == ']' ||
		    string[i] == '(' ||
		    string[i] == ')'){
			temp[j] = '\\';
			++j;
		}
		temp[j] = string[i];
	}
	--j;
	if(temp[j] != '/')
		++j;
	temp[j] = '\0';
	strcpy(string,temp);
} 
void reverse_escape( char * string){

	char temp[1024];
	int i,j,length;
	length=strlen(string);
	for( i = 0, j = 0; i < length; i++,j++){
		if( string[i] == '\\')
			++i;
		temp[j] = string[i];
	}
	--j;
	if(temp[j] != '/')
		++j;
	temp[j]='\0';
	strcpy(string,temp);
}
