/*
 * Portable process handling routines.
 * $Id: process.h 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#ifndef	__PROC_PROCESS_H__
#define	__PROC_PROCESS_H__

#ifndef	__STD_PROCESS_H__
#include <std/process.h>
#endif

/* Spawn services under UNIX fork()	*/

#define	P_NOWAIT	0x00	/* Default, run concurrent */
#define	P_WAIT		0x01	/* Wait for and return exit status */
#define	P_BACKGROUND	0x02	/* Detach child from our stdio */
#define	P_SESSION	0x04	/* Use setsid() on child */
#define	P_OVERLAY	0x08	/* Really 'exec' called via spawn */

/* Some common/portable spawn varients and masks */

#define	P_DETACH	P_NOWAIT | P_SESSION | P_BACKGROUND
#define	P_NOWAITO	P_NOWAIT | P_SESSION

/* Daemon initialization options */

#define	D_KEEPSTDIO	0	/* Daemon keeps stdio connection */
#define	D_KEEPALL	1	/* Daemon keeps all open files */
#define	D_KEEPNONIO	2	/* Detach from stdio, keep others open */
#define	D_KEEPNONE	3	/* Deamon closes all files */

#ifdef	__cplusplus
extern "C" {
#endif

/* Common process invokation services using fork() */ 

#ifdef	__NAMESPACE
#define	spawnv	__NAMESPACE(spawnv)
#define	spawnvp	__NAMESPACE(spawnvp)
#define	pdetach	__NAMESPACE(pdetach)
#define	priority __NAMEPSACE(priority)
#endif

int	spawnv(const int P_mode, const char *path, char *const argv[]);
int	spawnvp(const int P_mode, const char *path, char *const argv[]);
pid_t	pdetach(const int D_flag);	/* Make current process a daemon */
int	priority(int pri);	/* set realtime priorities */

#ifdef	__cplusplus
}
#endif

#endif
