/*
 * Hex digit conversions.
 * $Id: xval.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <other/strcvt.h>

int     xdigit(char c)
{
        if(c > '9')
                return upper(c) - '7';

        return digit(c);
};

ulong   xtol(const char *s)
{
        ulong v = 0l;

        while(isxdigit(*s))
        {
                v = v << 4 | xdigit(*s);
                ++s;
        }
        return v;
};
