/*
 * Portable string handling routines.
 * $Id: string.h 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#ifndef	__OTHER_STRINGS_H__
#define	__OTHER_STRINGS_H__

#ifndef	__STD_STRING_H__
#include <std/string.h>
#endif

#ifndef	__STD_TYPES_H__
#include <std/types.h>
#endif

#ifdef	__cplusplus
extern "C" {
#endif

#ifdef	__NAMESPACE
#define	__SPACES	__NAMESPACE(__SPACES)
#endif

extern	char	__SPACES[];

#ifdef	__NAMESPACE
#define	strblank	__NAMESPACE(strblank)
#define	strtrim		__NAMESPACE(strtrim)
#define	strrtrim	__NAMESPACE(strrtrim)
#define	strltrim	__NAMESPACE(strltrim)
#define	right		__NAMESPACE(right)
#define	left		__NAMESPACE(left)
#define	ccount		__NAMESPACE(ccount)
#define	tail		__NAMESPACE(tail)
#define	field		__NAMESPACE(field)
#define	token		__NAMESPACE(token)
#define	strcopy		__NAMESPACE(strcopy)
#define	strncopy	__NAMESPACE(strncopy)
#define	strdiff		__NAMESPACE(strdiff)
#define	getargv		__NAMESPACE(getargv)
#endif

bool	strblank(const char *str);
char 	*strtrim(char *s, const char *trim);
char 	*strrtrim(char *s, const char *trim);
char 	*strltrim(char *s, const char *trim);
char 	*right(char *str, size_t len);
char	*left(char *str, size_t len);
int  	ccount(const char *str, const char *list);
char	*tail(const char *str);
char	*field(char **ptr, const char *tok);
char	*token(char **ptr, const char *tok);
char	*strcopy(char *to, const char *from);
char	*strncopy(char *to, const char *from, int len);
int	strdiff(const char *s1, const char *s2);
int	getargv(char *base[], char *str);
void	fatal(int exitcode, const char *format, ...);
#ifdef	__cplusplus
}
#endif

#endif
