/*
 * File path search routines.
 * $Id: search.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <other/files.h>
#include <other/string.h>
#include <std/process.h>

#ifdef	QNX
#define	PATHMARK	"!"
#endif

#ifndef	PATHMARK
#define	PATHMARK	":"
#endif

char	*search(const char *path, const char *file)
{
	static	char	buf[PATH_MAX + 1];
	char	pbuf[PATH_MAX + 1];
	char	*p;

	if(!path)
		return NULL;

	strcpy(pbuf, path);

	p = strtok(pbuf, PATHMARK);

	while(p)
	{
		if(*p)
			fncat(strcpy(buf, p), file);
		else
			strcpy(buf, file);
		if(isfile(buf))
			return buf;
		p = strtok(NULL, PATHMARK);
	}
	return NULL;
}

		
