/*
 * Relallocate and release memory pools.
 * $Id: memrelease.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <other/memory.h>

void	memrelease(MEMPOOL *mem)
{
	MEMPAGE	*page = memfirst(mem);
	MEMPAGE	*next;

	while(page)
	{
		next = page->page_next;
		free(page);
		page = next;
	}
}

void	memreuse(MEMPOOL *mem)
{
	MEMPAGE	*page = memfirst(mem);
	MEMPAGE	*next;

	page = page->page_next;
	while(page)
	{
		next = page->page_next;
		free(page);
		page = next;
	}
	mem->mem_pused = 1;
	mem->mem_free = NULL;
	page = mem->mem_last = memfirst(mem);
	page->page_used = 0;
	page->page_next = NULL;
}

	
	
