/*
 * Advanced free space deallocation for memory pools.
 * $Id: memfree.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <other/memory.h>
#include <std/math.h>

void	memfree(MEMPOOL *mem, void *obj, int len)
{
	_MEMFREE *free = mem->mem_free;
	_MEMCELL *cell = (_MEMCELL *)obj;
	len = align(len, __OBJALIGN);

	while(free)
	{
		if(free->size == len)
			break;

		free = free->next;
	}

	if(!free)
	{
		free = memreq(mem, sizeof(_MEMFREE));
		free->list = NULL;
		free->next = mem->mem_free;
		mem->mem_free = free;
	}

	if(free)
	{
		cell->next = free->list;
		free->list = cell;
	}
}
