/*
 * Portable support for file manipulation and access related functions.
 * $Id: files.h 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#ifndef	__OTHER_FILES_H__
#define	__OTHER_FILES_H__

#ifndef	__STD_FILES_H__
#include <std/files.h>
#endif

#define	isdir(fpath)	isftype(fpath, S_IFDIR)
#define	isfile(fpath)	isftype(fpath, S_IFREG)
#define	islink(fpath)	isftype(fpath, S_IFLNK)
#define	isfifo(fpath)	isftype(fpath, S_IFIFO)
#define	pathfname(fn)	basename(fn)
#define	rewind(fd)	lseek(fd, (off_t)0, SEEK_SET)

#ifdef	__cplusplus
extern "C" {
#endif

#ifdef	__NAMESPACE
#define	isnewfile	__NAMESPACE(isnewfile)
#define	isftype		__NAMESPACE(isftype)
#define	ispath		__NAMESPACE(ispath)
#define	isroot		__NAMESPACE(isroot)
#define	fncat		__NAMESPACE(fncat)
#define	search		__NAMESPACE(search)
#define	basename	__NAMESPACE(basename)
#define	dirname		__NAMESPACE(dirname)
#define	extfname	__NAMESPACE(extfname)
#endif

bool	isnewfile(const char *from, const char *to);
bool	isftype(const char *fpath, int ftype);
bool	ispath(const char *fpath);
bool	isroot(const char *fpath);
char	*fncat(char *prefix, const char *suffix);
char	*search(const char *path, const char *fname);
char	*basename(const char *path);
char	*dirname(char *path);
char	*extfname(const char *path);

#ifdef	__cplusplus
}
#endif

#endif
