/*
 * String expansion and normalization of 'plain text' line data.
 * $Id: expand.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <std/string.h>

char	*expand(const char *s)
{
	static	char	buf[320];
	
	int pos = 0;

	while(*s)
	{
		if(*s == '\t')
		{
			buf[pos++] = ' ';
			while(pos % 8)
				buf[pos++] = ' ';
		}
		else if (*s > 31)
			buf[pos++] = *s;
		else
		{
			buf[pos++] = '^';
			buf[pos++] = *s + '@';
		}
		++s;
	}
	buf[pos] = 0;
	return buf;
}

