/*
 * Common values found in process environment space.
 * $Id: env.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * See conditions of distribution and reuse see product license.
 */

#include <other/env.h>
#include <std/string.h>

char	*homedir(void)
{
	char	*env = getenv("HOME");

	if(!env)
		env = "/";

	return env;
}

char	*language(void)
{
	static	char	lbuf[32] = "default";

	char	*env = getenv("LANG");

	if(env)
	{
		strncpy(lbuf, env, 31);
		lbuf[31] = 0;
		strtok(lbuf, "._");
	}
	return lbuf;
}
	
	
