/*
 * Portable human readable config text file parsing routines.
 * $Id: config.h 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and use see product license.
 *
 * Abstract:
 *	The config routines allow locating, opening, and parsing of
 *	human readable .conf files.  These .conf files are broken into
 *	seperate named [] sections, each of which may be individually
 *	located and examined, and config data.  Config data is usually
 *	in the form of a 'keyword = value' statement.
 *
 * Data types:
 *	CONFIG - object line parse buffer for an open config file.
 */

#ifndef	__OTHER_CONFIG_H__
#define	__OTHER_CONFIG_H__

#ifndef	__OTHER_STRING_H__
#include <other/string.h>
#endif

#ifndef	__OTHER_FILES_H__
#include <other/files.h>
#endif

typedef	struct
{
	bool	cfg_flag;
	FILE	*cfg_fp;
	char	cfg_test[33];
	char	cfg_lbuf[ EMPTY ];
}	CONFIG;

#ifdef	__cplusplus
extern "C" {
#endif

#ifdef	__NAMESPACE
#define	open_config	__NAMESPACE(open_config)
#define	sys_config	__NAMESPACE(sys_config)
#define	usr_config	__NAMESPACE(usr_config)
#define	first_config	__NAMESPACE(first_config)
#define	next_config	__NAMESPACE(next_config)
#define	seek_config	__NAMESPACE(seek_config)
#define	read_config	__NAMESPACE(read_config)
#define	close_config	__NAMESPACE(close_config)
#define	get_config	__NAMESPACE(get_config)
#endif

CONFIG	*open_config(const char *name);
CONFIG 	*sys_config(const char *name);
CONFIG 	*usr_config(const char *name);
char	*first_config(CONFIG *cfg);
char	*next_config(CONFIG *cfg);
bool	seek_config(CONFIG *cfg, const char *name);
char 	*read_config(CONFIG *cfg);
void 	close_config(CONFIG *cfg);
char 	*get_config(CONFIG *cfg, const char *option);

#ifdef	__cplusplus
}
#endif

#endif
