/*
 * Portable socket and peer name services.
 * $Id: sockname.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <net/socket.h>

char	*homename(SOCKET so)
{
	struct	hostent	*hp;
	struct	sockaddr_in	sin;
	int		len = sizeof(sin);

	if(getsockname(so, (struct sockaddr *)&sin, &len) < 0)
		return NULL;

	hp = gethostbyaddr((char *)&sin.sin_addr, sizeof(struct in_addr), AF_INET);
	if(hp)
		return (char *)hp->h_name;
	else
		return inet_ntoa(sin.sin_addr);
}

char	*homeaddr(SOCKET so)
{
	struct	sockaddr_in	sin;
	int		len = sizeof(sin);

	if(getsockname(so, (struct sockaddr *)&sin, &len) < 0)
		return NULL;

	return inet_ntoa(sin.sin_addr);
}

char	*peername(SOCKET so)
{
	struct	hostent	*hp;
	struct	sockaddr_in	sin;
	int	len = sizeof(sin);

	if(getpeername(so, (struct sockaddr *)&sin, &len) < 0)
		return NULL;

	hp = gethostbyaddr((char *)&sin.sin_addr, sizeof(struct in_addr), AF_INET);
	if(hp)
		return (char *)hp->h_name;
	else
		return inet_ntoa(sin.sin_addr);
}

char	*peeraddr(SOCKET so)
{
	struct	sockaddr_in	sin;
	int	len = sizeof(sin);

	if(getpeername(so, (struct sockaddr *)&sin, &len) < 0)
		return NULL;

	return inet_ntoa(sin.sin_addr);
}
