#!/bin/bash
#
# Kernel PerCentage (version 2) written by ste.b@theoffice.net (Stephen Bowyer)
#
# 30/May/1998
#

KPC_STAT="1"
KPC_VER="2"
KPC_DIR="$HOME"
KPC_FILE="./screen.dump"
KPC_TEMP="/tmp"
KPC_USER="$LOGNAME"
KPC_PERCENT="0"
KPC_LINUX="/usr/src/linux"
KPC_VER1="`grep "VERSION =" $KPC_LINUX/Makefile | sed 's/VERSION = //' -`"
KPC_VER2="`grep "PATCHLEVEL =" $KPC_LINUX/Makefile | sed 's/PATCHLEVEL = //' -`"
KPC_VER3="`grep "SUBLEVEL =" $KPC_LINUX/Makefile | sed 's/SUBLEVEL = //' -`"
KPC_KERVER="$KPC_VER1.$KPC_VER2.$KPC_VER3"
KPC_INFO1="KPC works with 2.0.x and 2.1.x Linux kernels, and has been tested"
KPC_INFO2="only with version 2.1.102."
KPC_1="for i in kernel drivers"
KPC_5="/drivers/block"
KPC_7="/char"
KPC_8="/net"
KPC_10="/pci"
KPC_14="/pnp"
KPC_17="drivers/cdrom"
KPC_20="/mm"
KPC_22="/vfat"
KPC_24="/proc"
KPC_25="/isofs"
KPC_27="/nfs"
KPC_33="/lockd"
KPC_36="/fs/nls"
KPC_38="/umsdos"
KPC_42="/smbfs"
KPC_46="/autofs"
KPC_50="/net/core"
KPC_55="/ethernet"
KPC_58="/sched"
KPC_60="/net/802"
KPC_64="/ipv4"
KPC_68="/net/unix"
KPC_70="/ipv6"
KPC_71="/netlink"
KPC_72="/packet"
KPC_74="/bridge"
KPC_76="/net/ipx"
KPC_80="/sunrpc"
KPC_85="/ipc"
KPC_90="linux/lib"
KPC_94="i386/arch/"
KPC_99="grep"
KPC_100="System is"

KPC_WORDS="$KPC_100
$KPC_99
$KPC_94
$KPC_90
$KPC_85
$KPC_80
$KPC_76
$KPC_74
$KPC_72
$KPC_71
$KPC_70
$KPC_68
$KPC_64
$KPC_60
$KPC_58
$KPC_55
$KPC_50
$KPC_46
$KPC_42
$KPC_38
$KPC_36
$KPC_33
$KPC_27
$KPC_25
$KPC_24
$KPC_22
$KPC_20
$KPC_17
$KPC_14
$KPC_10
$KPC_8
$KPC_7
$KPC_5
$KPC_1"


echo
echo "Kernel PerCentage (version $KPC_VER)"
echo "-----------------------------"
echo 
echo -n "Do you want to check the development of your compiling kernel (y/N)?"
read KPC_INPUT
echo

if [ "$KPC_INPUT" = "y" ]; then
	KPC_INPUT="Y"; fi

if [ ! "$KPC_INPUT" = "Y" ]; then

	echo "You have chosen not to check the development of your compiling kernel.."
	echo
	echo "Thank you for using KPC!"
	echo

else

	echo -n "Which tty number is your kernel compiling on (number only)?"
	read KPC_INPUT
	if [ "a$KPC_INPUT" = "a" ]; then

		echo "You have chosen to quit!"
		echo
		echo "Thank you for using KPC!"
		echo

	else

		cd "$KPC_DIR"
		KPC_TTY="$KPC_INPUT"
		setterm -dump 0$KPC_TTY 1>/dev/null 2>/dev/null
		if [ ! -f "$KPC_FILE" ]; then

			echo
			echo "You have specified an incorrect terminal number or you do not"
			echo "have sufficent rights over /dev/vcsa$KPC_TTY"
			echo
			echo "Thank you for using KPC!"
			echo

		else

			echo
			echo $KPC_INFO1
			echo $KPC_INFO2
			echo
			echo -n "Press [ENTER] to start scanning..."
			read KPC_DUMMY
			clear
			KPC_STAT="1"
			KPC_PERCENT="0"
			KPC_DISPLAY=""
			KPC_SLEEP="0s"
			while [ "$KPC_STAT" = "1" ]; do

				echo
				clear
				echo "KPC (version $KPC_VER)"
				echo "---------------"
				echo
				echo "$KPC_DISPLAY"
				echo
				echo
				sleep $KPC_SLEEP
				KPC_SLEEP="5s"

				if [ "$KPC_PERCENT" = "100" ]; then

					echo
					echo "Thank you for using KPC!"
					echo
					exit

				fi

				echo -n "Checking..."
				cd "$KPC_DIR"
				setterm -dump $KPC_TTY 1>/dev/null 2>/dev/null

				if [ ! -f "$KPC_FILE" ]; then

					echo
					echo "Error searching for $KPC_FILE! Quitting!"
					KPC_STAT="0"
					exit

				fi

				chmod 0600 $KPC_FILE
				mv $KPC_FILE $KPC_TEMP/kpc-$KPC_USER-1
				grep -F "$KPC_WORDS" - <$KPC_TEMP/kpc-$KPC_USER-1 >$KPC_TEMP/kpc-$KPC_USER-2
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-2


				grep -e "$KPC_100" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="100"
				else

				grep -e "$KPC_99" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="99"
				else

				grep -e "$KPC_94" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="94"

					grep -e "modules" - <$KPC_TEMP/kpc-$KPC_USER-1 >$KPC_TEMP/kpc-$KPC_USER-4
					chmod 0600 $KPC_TEMP/kpc-$KPC_USER-4
					KPC_GREPPED=""
					read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-4
					if [ ! "$KPC_GREPPED" = "" ]; then
						KPC_PERCENT="100"
					fi

				else

				grep -e "$KPC_90" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="90"
				else

				grep -e "$KPC_85" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="85"
				else

				grep -e "$KPC_80" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="80"
				else

				grep -e "$KPC_76" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="76"
				else

				grep -e "$KPC_74" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="74"
				else

				grep -e "$KPC_72" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="72"
				else

				grep -e "$KPC_71" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="71"
				else

				grep -e "$KPC_70" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="70"
				else

				grep -e "$KPC_68" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="68"
				else

				grep -e "$KPC_64" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="64"
				else

				grep -e "$KPC_60" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="60"
				else

				grep -e "$KPC_58" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="58"
				else

				grep -e "$KPC_55" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="55"
				else

				grep -e "$KPC_50" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="50"
				else

				grep -e "$KPC_46" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="46"
				else

				grep -e "$KPC_42" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="42"
				else

				grep -e "$KPC_38" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="38"
				else

				grep -e "$KPC_36" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="36"
				else

				grep -e "$KPC_33" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="33"
				else

				grep -e "$KPC_27" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="27"
				else

				grep -e "$KPC_25" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="25"
				else

				grep -e "$KPC_24" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="24"
				else

				grep -e "$KPC_22" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="22"
				else

				grep -e "$KPC_20" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="20"
				else

				grep -e "$KPC_17" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="17"
				else

				grep -e "$KPC_14" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="14"
				else

				grep -e "$KPC_10" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="10"
				else

				grep -e "$KPC_8" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="8"
				else

				grep -e "$KPC_7" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="7"
				else

				grep -e "$KPC_5" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="5"
				else

				grep -e "$KPC_1" - <$KPC_TEMP/kpc-$KPC_USER-2 >$KPC_TEMP/kpc-$KPC_USER-3
				chmod 0600 $KPC_TEMP/kpc-$KPC_USER-3
				KPC_GREPPED=""
				read KPC_GREPPED <$KPC_TEMP/kpc-$KPC_USER-3
				if [ ! "$KPC_GREPPED" = "" ]; then
					KPC_PERCENT="1"
				else

				KPC_PERCENT="0"

				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				fi
				rm -f $KPC_TEMP/kpc-$KPC_USER-*

				KPC_DISPLAY="Linux kernel version $KPC_KERVER compiling... Currently $KPC_PERCENT% complete!"

				if [ "$KPC_PERCENT" = "0" ]; then

					KPC_DISPLAY="Linux kernel compilation not found... Retrying..."

				fi

			done

		fi
	fi
fi


