/* $Id: tpm.c,v 1.10 1997/10/27 22:08:44 imil Exp imil $
 */

/*****************************************************************************/
/*                                                                           */
/*    TarGzip Package Management v0.3, a rpm-like tool for tar.gz archives   */
/*    Copyright (C) 1997, iMil -*- gRUIK cODERS uNITED -*-                   */
/*                                                                           */
/*    This program is free software; you can redistribute it and/or modify   */
/*    it under the terms of the GNU General Public License as published by   */
/*    the Free Software Foundation; either version 2 of the License, or      */
/*    (at your option) any later version.                                    */
/*                                                                           */
/*    This program is distributed in the hope that it will be useful,        */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of         */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*    GNU General Public License for more details.                           */
/*                                                                           */
/*    You should have received a copy of the GNU General Public License      */
/*    along with this program; if not, write to the Free Software            */
/*    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              */
/*                                                                           */
/*    You can reach me at :                                                  */
/*                          eheitor@cie.fr                                   */
/*                                                                           */
/*    Or visit my Web site at :                                              */
/*                              http://www.chez.com/imil                     */
/*                                                                           */
/*****************************************************************************/


#include "tpm.h"

main(int argc, char **argv)
{
  char *pack;
  char *arg;
  char *instpath;
  uid_t user;

  user=getuid();

  if (argc<3) {
    if (argc>1 && strlen(argv[1])>1)
      {
	if (argv[1][1]=='a') listall();
	if (argv[1][1]=='v') {
	  printf("\nTarGzip Package Management, v0.3\n");
	  printf("by iMil\n\n");
	  exit(1);
	}
      }
    usage();
    exit(2);
  }
  if (argv[1][0]!='-') {
    usage();
    exit(2);
  }

  switch (argv[1][1])
    {
    case 'i':
      
      if (user) {
	printf("\nSorry, you're not allowed to install things.\n");
	printf("I know, life is difficult...\n\n");
	exit(2);
      }
      
      pack=(char *)malloc(sizeof(char *));
      pname(argv[2], strlen(argv[2]), &pack);
      
      if (checkpack(pack)) {
        printf("\nThe package %s is already installed !\n\n", pack);
        exit(2);
      }

      instpath=ipath();
      install(argv[2], instpath, pack);
      break;
    case 'l':
      list(argv[2]);
      break;
    case 'e':
      if (user) {
	printf("\nSorry, you're not allowed to remove packages.\n");
	printf("How boring I am huh ?...\n\n");
	exit(2);
      }      
      erasepack(argv[2]);
    case 'h':
      usage();
      exit(1);
    default:
      printf("\nInvalid Option\n");
      usage();
      exit(2);
    }
}

void usage()
{
  printf("\nUsage:\n");
  printf("%stpm -i <tar_gzipped_file>  { installs package }\n",\
	 space(SPACE));
  printf("%stpm -l <tar_gzipped_file>  { list contents    }\n",\
	 space(SPACE));
  printf("%stpm -e <tar_gzipped_file>  { erase package    }\n",\
	 space(SPACE));
  printf("%stpm -a                     { list packages    }\n",\
	 space(SPACE));
  printf("%stpm -v                     { tpm version      }\n\n",\
	 space(SPACE));
}

char *ipath()
{
  char *instpath;
  char tmp[1], path[80];
  int size;

  printf("\nInstall types :\n\n");
  printf("c -> Custom path\n");
  printf("r -> Root path    ( root = /          )\n");
  printf("b -> Binary path  ( root = /usr       )\n");
  printf("x -> X path       ( root = /usr/X11   )\n");
  printf("l -> Local path   ( root = /usr/local )\n\n");
  printf("Enter type : ");
  gets(tmp);

  switch(tmp[0])
    {
    case 'c':
      printf("Enter FULL path : ");
      gets(path);
      if (path[0]!='/') {
        printf("\nI SAID : THE FULL PATH !\n\n");
        exit(2);
      }
      size=strlen(path);
      if (path[size-1] != '/') {
        path[size]='/';
        path[size+1]='\0';
      }
        
      instpath=strdup(path);
      return(instpath);
    case 'l':
      instpath=(char *)malloc(sizeof(char *));
      instpath="/usr/local/";
      return(instpath);
    case 'b':
      instpath=(char *)malloc(sizeof(char *));
      instpath="/usr/";
      return(instpath);
    case 'x':
      instpath=(char *)malloc(sizeof(char *));
      instpath="/usr/X11R6/";
      return(instpath);
    case 'r':
      instpath=(char *)malloc(sizeof(char *));
      instpath="/";
      return(instpath);
     default:
      printf("\nInvalid choice\n\n");
      exit(2);
   }
}

char *pname(char *filename, int packlen, char **pack)
{
  int i;

  for(i=packlen;i>=0 && filename[i]!='/';i--);

  i++;

  *pack=&filename[i];

}

void list(char *argv)
{
  int stat;
  pid_t pid;

  execl(TARPATH, TARCMD, "ztvf", argv, NULL);

  exit(1);
}

int checkpack(char *pname)
{
  FILE *fp;
  char *line;
  int nb;

  fp=fopen(PACKFILE, "rb");
  if (!fp) return(0);

  while(1)
    {
      nb=freadline(fp, &line);
      if (!nb) {
        fclose(fp);
        return(0);
      }
      if (!strncmp(pname, line, strlen(pname))) {
        fclose(fp);
        return(1);
      }
    }
}

void install(char *argv,\
             char *instpath,\
             char *pack)
{
  FILE *fp1, *fp2;
  char *line, *end="End Package\n";
  char cr='\n';
  int nb1, nb2, fd, fd2;
  pid_t pid;
  char **arglist;

  arglist=(char **)malloc(sizeof(char *));
  arglist[0]=(char *)malloc(sizeof(char *));
  arglist[0]=TARCMD;
  arglist[1]=(char *)malloc(sizeof(char *));
  arglist[1]="zxvf";
  arglist[2]=(char *)malloc(sizeof(char *));
  arglist[2]=argv;
  arglist[3]=(char *)malloc(sizeof(char *));
  arglist[3]="-C";
  arglist[4]=(char *)malloc(sizeof(char *));
  arglist[4]=instpath;
  arglist[5]=(char *)malloc(sizeof(char *));
  arglist[5]=NULL;

  printf("\nInstalling package %s...\n", argv);

  fd=open("/var/lib/tpm/install.log", O_WRONLY | O_CREAT);
  dup2(fd, 1);

  pid=fork();
  if (!pid)
    execve(TARPATH, arglist, NULL);
  pid=wait(&nb1);

  chmod("/var/lib/tpm/install.log", 00666);
  close(fd);
  fd2=open("/dev/console", O_WRONLY);
  dup2(fd2, 1);

  fp1=fopen("/var/lib/tpm/install.log", "rb");
  fp2=fopen(PACKFILE, "ab");
  
  nb2=fwrite(pack, strlen(pack), 1, fp2);
  nb2=fwrite(&cr, 1, 1, fp2);

  while(nb1=freadline(fp1, &line))
    {
      nb2=fwrite(instpath, strlen(instpath), 1, fp2);
      nb2=fwrite(line, strlen(line), 1, fp2);
      nb2=fwrite(&cr, 1, 1, fp2);
    }
  
  nb2=fwrite(end, strlen(end), 1, fp2);

  fclose(fp1);
  fclose(fp2);

  unlink("/var/lib/tpm/install.log");

  printf("\nDone.\n\n");
  exit(1);
}

int updatepackfile(char *pack)
{
  FILE *fp, *fp2;
  char *line, cr='\n';
  int nb, present=0;

  fp=fopen(PACKFILE, "rb");
  fp2=fopen(PACKTMP, "ab");

  while(1)
    {
      nb=freadline(fp, &line);
      if (!nb) {
        fclose(fp);
        fclose(fp2);
        unlink(PACKFILE);
        rename(PACKTMP, PACKFILE);
        return(0);
      }
      
      if (strcmp(pack, line)) {
        nb=fwrite(line, strlen(line), 1, fp2);
        nb=fwrite(&cr, 1, 1, fp2);
      }
      else {
        do {
          nb=freadline(fp, &line);
        } while(strncmp("End", line, 3));
      }
    }
}

void erasepack(char *pack)
{
  FILE *fp;
  int here, nb=0;
  char *line=NULL, **oldpath=NULL;

  here=checkpack(pack);
  if (!here) { 
    printf("\nThe package %s is not installed !\n\n", pack);
    exit(2);
  }

  fp=fopen(PACKFILE, "rb");

  do {
    freadline(fp, &line);
  } while(strcmp(pack, line));

  printf("\nRemoving package %s\n", pack);

  oldpath=(char **)malloc(sizeof(char *));

  while(1)
    {
      freadline(fp, &line);
      if (!strncmp("End", line, 3)) {
        for(;nb>0; nb--) {
          *oldpath--;
          rmdir(*oldpath);
        }

        updatepackfile(pack);
         
        printf("\nDone.\n\n");
        fclose(fp);
        exit(1);
      }
      else {
        if (line[strlen(line)-1]=='/') {
          *oldpath=(char *)malloc(strlen(line));
          *oldpath=line;
          *oldpath++;
          nb++;
        }
        else {
          unlink(line);
        }
      }
    }
}

void listall()
{
  FILE *fp;
  char *line;
  int test=0;

  printf("\nInstalled packages :\n\n");

  fp=fopen(PACKFILE, "rb");

  while(freadline(fp, &line))
    {
      if (!test) printf("%s\n", line);
      test=1;
      if (!strncmp("End", line, 3)) test=0;
    }
  printf("\n");
  exit(1);
}

