/*****************************************************************************/
/*                                                                           */
/*    GCUshell, some pretty functions based on ncurses                       */
/*    Copyright (C) 1997  iMil                                               */
/*                                                                           */
/*    This program is free software; you can redistribute it and/or modify   */
/*    it under the terms of the GNU General Public License as published by   */
/*    the Free Software Foundation; either version 2 of the License, or      */
/*    (at your option) any later version.                                    */
/*                                                                           */
/*    This program is distributed in the hope that it will be useful,        */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of         */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*    GNU General Public License for more details.                           */
/*                                                                           */
/*    You should have received a copy of the GNU General Public License      */
/*    along with this program; if not, write to the Free Software            */
/*    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              */
/*                                                                           */
/*    You can reach me at :                                                  */
/*                          emile.heitor@inforoute.cgs.fr                    */
/*                          imil@chez.com                                    */
/*                                                                           */
/*    Or visit my Web site at :                                              */
/*                              http://www.chez.com/imil                     */
/*                                                                           */
/*****************************************************************************/


#include "GCUshell.h"

/* ------------------------------------------------------------------------- */
/* - Look'n'Feel ----------------------------------------------------------- */
/* ------------------------------------------------------------------------- */

char *space(int nbspc)
{
  int i;
  char *spc;
  
  spc=(char *)malloc(sizeof(char)*(nbspc+1));

  for (i=0; i<nbspc; i++)
    spc[i]=' ';

  spc[i]='\0';

  return(spc);
}

/* ------------------------------------------------------------------------ */
/* - File Manipulation ---------------------------------------------------- */
/* ------------------------------------------------------------------------ */

int freadline(FILE *fp, char **line)
{
  char name[80];
  int nb, i=0;

  *line=NULL;

  while(!*line)
    {
      nb=fread(&name[i], 1, 1, fp);
      if (!nb) return(0);
      
      if ( name[i] != '\n') i++;
      else {
	if ((name[0]!='#') && (i>0) && (name[0]!=' ')) {
	  name[i]='\0';
	  *line=strdup(name);
	}
	else i=0;
      }
    }
}



