/* webCpp
 * Copyright (C) 2002 Jeffrey Bakker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef STYLE_H
#define STYLE_H

#include <string>
#include "cffile.h"
#include "colour.h"
#include "lang.h"
using namespace std;


class Style {

 public:

  // checks the extension -----------------------------------------------------
  static int getExtension(string filename);
  string checkExtension(string);

  // these check what has to be coloured --------------------------------------
  virtual void cmntCheck()  =0;
  virtual void Colourizer() =0;

  // common for all language types
  void numCheck();
  void strCheck();
  void keysCheck();
  void Angle_Brackets();
  bool isInsideIt(int index, string start, string end);
//  bool isNumBounds(int index);


//  void removeTags(int start, int fin, string e1, string e2);
//  void insertTags(int offset, string open, string close, string colour);

 void eraseTags(int start, int fin);

  void colour_CMNT(int start);
  void colour_NUM(int start, int fin);
  void colour_STR(int index);

  int  getLineCount();
  void mkMargin();
  void toggleMargin();
  void toggleIswitch();
  void toggleOswitch();
  bool isIstd();
  bool isOstd();
  void setCSSfile(string name);
 // void open(string filename, io)

  void openhtml(string name);
  void closehtml();

  void toggleHyperSwitch();
  void toggleMadewithSwitch();
  void toggleCSSSwitch();
  void setBGPicture(string filename);

  // data members -------------------------------------------------------------
  CFfile fIO;
  Colour ColourOf;

 protected:


  string picture;
  bool hyper;
  bool csson;
  bool made;

  Lang* slang;

  int filetype;
  int lncnt;

  bool instring;
  bool incomment;

  bool margin;
  bool redir_I;
  bool redir_O;
  string cssfile;
  string buffer;

  // --------------------------------------------------------------------------

};

#endif  // STYLE_H

