
/* webCpp 0.6
 * Copyright (C) 2001, 2002 Jeffrey Bakker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <fstream>
#include <string>
#include <cctype>
#include "dupe.h"
#include "help.h"
#include "bangbanger.h"
#include "gangbanger.h"
#include "hashbanger.h"
#include "headbanger.h"
using namespace std;

/******************************** MAIN FUNCTION ******************************/
int main(int argc, char **argv)
{
 Help help;
 if (argc < 3) {help.helpme();}

 string type;
 type = argv[1];
 // default filetype is the extension of the input file
 // needs to check if the filetype will be forced by the user
 if(argc > 3) {
  string ar;
  for(int a=3; a < argc; a++) {
   ar = argv[a];
   if (ar.substr(0,3) == "-t=") {type = "." + ar.substr(3);}
   if (ar == "--backup" || ar == "-b") {
    string backup = argv[2];
    backup += ".old";
    Dupe::duplicate(argv[2], backup);
   }
  }
 }

 Style* Source;  // make a Style Pointer
                // and determine the language style
 switch(Style::getExtension(type)) {
  case (0):
  case (1):
  case (2):
  case (3): Source = new HeadBanger; break;
  case (4):
  case (5):
  case (6): Source = new HashBanger; break;
  case (7): Source = new GangBanger; break;
  case (8): Source = new BangBanger; break;
  default : Source = new HeadBanger; break;
 }

 int percent;
 string imode, omode;
 // checking whether the input or ouput mode sould be redirected --------------
 imode = argv[1];
 omode = argv[2];
 percent = 0;

 if (imode == "--pipe" || imode == "-") {
  Source->toggleIswitch();
 } else { 
  ifstream Count;
  string tmp;

  Count.open(imode.data());
  if(!Count) {
   cerr << imode << " cannot be found.\n";
   exit(0);
  }

  while (Count) {
   getline(Count,tmp);
   percent++;
  }
  percent--;
  Count.close();
//  Count.seekg(ios::beg);
  if(!Source->fIO.openR(imode)) {exit(0);}
 }

 if (omode == "--pipe" || omode == "-") {
  Source->toggleOswitch();
 } else {
  if(Source->isIstd()) {Source->fIO.ofile.open(omode.data());}
  else if(!Source->fIO.openW(omode)) {exit(0);}
 }

 //----------------------------------------------------------------------------
 // optional arguments --------------------------------------------------------
 if (argv[3] != NULL) {
  string arg;
  for(int i=3; i < argc; i++) {

   arg = argv[i];
   if (arg == "--dupe" || arg == "-d") {
    if(Dupe::duplicate(argv[1], argv[2])) return 0;
    else exit(1);
   } else if (arg.substr(0,3) == "-t=") {
      cerr << Source->checkExtension("." + arg.substr(3)) << " detected.\n";
   } else if (arg.substr(0,3) == "-c=") {
      Source->ColourOf.schemeIt(arg.substr(3));
   } else if (arg.substr(0,3) == "-C=") {
      Source->toggleCSSSwitch();
      Source->setCSSfile(arg.substr(3));
   } else if (arg.substr(0,3) == "-p=") {
      Source->setBGPicture(arg.substr(3));
   } else if (arg.substr(0,3) == "-w=") {
      Source->ColourOf.schemeIt(arg.substr(3));
      Source->toggleMargin();
      Source->toggleHyperSwitch();
      Source->toggleMadewithSwitch();
   } else if (arg == "--backup"       || arg == "-b") {
   } else if (arg == "--made-with"    || arg == "-m") {
      Source->toggleMadewithSwitch();
   } else if (arg == "--hyperlink"    || arg == "-h") {
      Source->toggleHyperSwitch();
   } else if (arg == "--set-colours"  || arg == "-s") {
      Source->ColourOf.setAllColours();
   } else if (arg == "--line-numbers" || arg == "-l") {
      Source->toggleMargin();
   } else help.helpme();
  }
 }
 //----------------------------------------------------------------------------
 if(!Source->isIstd()) {
  cerr << Source->checkExtension(argv[1]) << " detected.\n";
 }
 //----------------------------------------------------------------------------
 Source->openhtml(argv[1]);
 Source->Colourizer();

 // process each line and display the progress
 while(Source->fIO.ifile && cin) {
  Source->Colourizer();
  if(!Source->isIstd() && ((Source->getLineCount() * 100) / percent) < 101) {
   cerr << "\r"
        << ((Source->getLineCount() * 100) / percent)
        << "% Complete ";
  }
 }

 Source->closehtml();
 Source->fIO.close();
 cerr << endl;
 return 0;
} // END MAIN -----------------------------------------------------------------

